/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.steps;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.custom.PluginUsagesInspector;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.scheduler.reports.ReportItem;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.scheduler.steps.NonFatalStepParams;
import com.dataiku.dip.scheduler.steps.Step;
import com.dataiku.dip.scheduler.steps.StepMeta;
import com.dataiku.dip.scheduler.steps.StepParams;
import com.dataiku.dip.scheduler.steps.StepRun;
import com.dataiku.dip.scheduler.steps.StepRunner;
import com.dataiku.dip.server.services.GitReferencesService;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class PullGitRefsStepRunner
implements StepRunner {
    @Autowired
    private GitReferencesService gitRefsService;
    @Autowired
    private FutureService futureService;
    private final PullGitRefsStepParams params;
    public static final StepMeta META = new StepMeta(){

        @Override
        public Class<? extends StepParams> paramsClass() {
            return PullGitRefsStepParams.class;
        }

        @Override
        public String getType() {
            return "pull_git_refs";
        }

        @Override
        public StepRunner buildRunner(Scenario scenario, Step step) {
            return new PullGitRefsStepRunner(step.getParamsAs(PullGitRefsStepParams.class));
        }

        @Override
        public String buildName(Step step) {
            return "Update Git references";
        }

        @Override
        public String buildId(Step step) {
            PullGitRefsStepParams stepParams = step.getParamsAs(PullGitRefsStepParams.class);
            StringBuilder sb = new StringBuilder();
            sb.append("pull_git_refs");
            if (stepParams != null) {
                if (stepParams.updateAll) {
                    sb.append("_update_all");
                } else {
                    for (String gitReference : stepParams.gitReferences) {
                        sb.append("_").append(gitReference);
                    }
                }
            }
            return sb.toString();
        }

        @Override
        public StepMeta.UnavailableStepInfo checkStepForDeletedPluginComponents(Scenario sc, Step step, PluginUsagesInspector pluginUsagesInspector) {
            return null;
        }
    };

    public PullGitRefsStepRunner(PullGitRefsStepParams params) {
        this.params = params;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run(StepRun stepRun, ReportItem.StepDone stepReportItem) throws Exception {
        projectKey = stepRun.getScenarioRun().getScenario().getProjectKey();
        runAsUser = stepRun.getScenarioRun().getRunAsUser();
        stepReportItem.withStart(DateTime.now().getMillis());
        outcome = ReportItem.Outcome.SUCCESS;
        if (this.params.updateAll) {
            try {
                fr = this.gitRefsService.startPullProjectGitRefs_NT(projectKey, runAsUser);
                fr = this.futureService.waitForFinalResponse(fr);
                if (!InfoMessage.anyFatal((Collection)((InfoMessage.InfoMessages)fr.result).messages)) ** GOTO lbl28
                outcome = ReportItem.Outcome.FAILED;
            }
            catch (Exception ex) {
                stepReportItem.withThrown(ex).withEnd(DateTime.now().getMillis()).withOutcome(ReportItem.Outcome.FAILED);
                throw ex;
            }
        } else {
            for (String gitRefPath : this.params.gitReferences) {
                try {
                    fr = this.gitRefsService.startPullProjectGitRef_NT(projectKey, gitRefPath, runAsUser);
                    fr = this.futureService.waitForFinalResponse(fr);
                    if (outcome != ReportItem.Outcome.SUCCESS || !InfoMessage.anyFatal((Collection)((InfoMessage.InfoMessages)fr.result).messages)) continue;
                    outcome = ReportItem.Outcome.FAILED;
                }
                catch (Exception ex) {
                    stepReportItem.withThrown(ex).withEnd(DateTime.now().getMillis()).withOutcome(ReportItem.Outcome.FAILED);
                    throw ex;
                }
            }
        }
lbl28:
        // 3 sources

        stepReportItem.withEnd(DateTime.now().getMillis()).withOutcome(outcome);
    }

    public static class PullGitRefsStepParams
    extends NonFatalStepParams
    implements StepParams {
        public List<String> gitReferences;
        public boolean updateAll;

        public PullGitRefsStepParams(List<String> gitReferences, boolean updateAll) {
            this.gitReferences = gitReferences;
            this.updateAll = updateAll;
        }
    }
}

