/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.apideployer;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.apideployer.DeployerUtils;
import com.dataiku.dip.apideployer.datamodel.actual.AbstractDeploymentLightStatus;
import com.dataiku.dip.apideployer.datamodel.actual.AbstractGlobalLightStatus;
import com.dataiku.dip.apideployer.datamodel.actual.AbstractInfraBasicInfo;
import com.dataiku.dip.apideployer.datamodel.actual.AbstractPublishedItemBasicInfo;
import com.dataiku.dip.apideployer.datamodel.actual.AbstractPublishedItemLightStatus;
import com.dataiku.dip.apideployer.datamodel.actual.InfraLightStatus;
import com.dataiku.dip.apideployer.datamodel.actual.PublishedApiServicePackageInfo;
import com.dataiku.dip.apideployer.datamodel.config.AbstractAPIDeploymentInfra;
import com.dataiku.dip.apideployer.datamodel.config.AbstractAPIServiceDeployment;
import com.dataiku.dip.apideployer.datamodel.config.AbstractDeployment;
import com.dataiku.dip.apideployer.datamodel.config.AbstractDeploymentInfra;
import com.dataiku.dip.apideployer.deployments.APIServiceDeploymentsService;
import com.dataiku.dip.apideployer.infra.ApiNodeInfrasService;
import com.dataiku.dip.apideployer.published.PublishedAPIServicesService;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.externalinfras.databricks.datamodel.DatabricksWorkspaceDirectoryObject;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.remoterun.RemoteRunNetworkingUtils;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.server.apideployer.AbstractDeployerController;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.services.licensing.AbstractLicenseFeaturesStatusBuilder;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.lambda.model.serverconfig.GenerationsMapping;
import com.dataiku.lambda.model.serverconfig.QueryAPIKey;
import com.dataiku.lambda.model.studioconfig.ApiEndpointQuery;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
public class APIDeployerController
extends AbstractDeployerController<AbstractAPIServiceDeployment, AbstractPublishedItemBasicInfo.PublishedAPIServiceBasicInfo, AbstractAPIDeploymentInfra> {
    @Autowired
    private APIServiceDeploymentsService deploymentsService;
    @Autowired
    private ApiNodeInfrasService apiNodeInfrasService;
    @Autowired
    private PublishedAPIServicesService publishedAPIServicesService;
    @Autowired
    private AuditTrailService auditTrailService;

    public APIDeployerController() {
        super("API");
    }

    protected APIServiceDeploymentsService getDeploymentsService() {
        return this.deploymentsService;
    }

    protected ApiNodeInfrasService getInfrasService() {
        return this.apiNodeInfrasService;
    }

    protected PublishedAPIServicesService getPublishedItemsService() {
        return this.publishedAPIServicesService;
    }

    @Override
    protected boolean hasLicenseFlag(AbstractLicenseFeaturesStatusBuilder.LicenseFeaturesStatus licenseFeatures) {
        return licenseFeatures.apiNodeAllowed;
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/api-deployer/stages"})
    public void listStages(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        APIDeployerController.writeJSON((HttpServletResponse)resp, (Object)ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN().apiDeployerServerSettings.stages);
    }

    @Override
    @AuditedCall(value={"msgType", "apideployer-services-list"})
    @RequestMapping(value={"/api/api-deployer/published-api-services/list-light-status"})
    public void listPublishedLightStatus(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        super.listPublishedLightStatus(req, resp);
    }

    @Override
    @AuditedCall(value={"msgType", "apideployer-services-list"})
    @RequestMapping(value={"/api/api-deployer/published-api-services/list-basic-info"})
    public void listPublishedBasicInfo(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        super.listPublishedBasicInfo(req, resp);
    }

    @Override
    @AuditedCall(value={"msgType", "apideployer-services-get", "serviceId", "${serviceId}"})
    @RequestMapping(value={"/api/api-deployer/published-api-services/get-light-status"})
    public void getPublishedLightStatus(HttpServletRequest req, HttpServletResponse resp, @RequestParam String serviceId) throws Exception {
        super.getPublishedLightStatus(req, resp, serviceId);
    }

    @Override
    @AuditedCall(value={"msgType", "apideployer-services-get", "serviceId", "${serviceId}"})
    @RequestMapping(value={"/api/api-deployer/published-api-services/get-settings"})
    public void getPublishedSettings(HttpServletRequest req, HttpServletResponse resp, @RequestParam String serviceId) throws Exception {
        super.getPublishedSettings(req, resp, serviceId);
    }

    @Override
    @AuditedCall(value={"msgType", "apideployer-service-create", "serviceId", "${serviceId}"})
    @RequestMapping(value={"/api/api-deployer/published-api-services/create"})
    public void createPublished(HttpServletRequest req, HttpServletResponse resp, @RequestParam String serviceId, @RequestParam String label) throws Exception {
        super.createPublished(req, resp, serviceId, label);
    }

    @Override
    @AuditInline
    @RequestMapping(value={"/api/api-deployer/published-api-services/save"})
    public void savePublished(HttpServletRequest req, HttpServletResponse resp, @RequestParam String service) throws Exception {
        super.savePublished(req, resp, service);
    }

    @Override
    @AuditedCall(value={"msgType", "apideployer-service-delete", "serviceId", "${serviceId}"})
    @RequestMapping(value={"/api/api-deployer/published-api-services/delete"})
    public void deletePublished(HttpServletRequest req, HttpServletResponse resp, @RequestParam String serviceId) throws Exception {
        super.deletePublished(req, resp, serviceId);
    }

    @AuditedCall(value={"msgType", "apideployer-service-version-publish", "serviceId", "${serviceId}"})
    @RequestMapping(value={"/api/api-deployer/versions/publish"})
    public void publishVersion(HttpServletRequest req, HttpServletResponse resp, @RequestParam String serviceId, @RequestParam(value="file") MultipartFile filePart) throws Exception {
        AuthCtx user;
        this.checkLicense();
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
        }
        this.publishedAPIServicesService.publishVersionFromStream_NT_Check(serviceId, filePart.getInputStream(), user);
    }

    @AuditedCall(value={"msgType", "apideployer-service-version-delete", "serviceId", "${serviceId}", "versionId", "${versionId}"})
    @RequestMapping(value={"/api/api-deployer/versions/delete"})
    public void deleteVersion(HttpServletRequest req, HttpServletResponse resp, @RequestParam String serviceId, @RequestParam String versionId) throws Exception {
        this.deletePackage(req, resp, serviceId, versionId);
    }

    @Override
    @AuditedCall(value={"msgType", "apideployer-infras-list"})
    @RequestMapping(value={"/api/api-deployer/infras/list-light-status"})
    public void listInfrasLightStatus(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        super.listInfrasLightStatus(req, resp);
    }

    @Override
    @AuditedCall(value={"msgType", "apideployer-infras-list"})
    @RequestMapping(value={"/api/api-deployer/infras/list-basic-info"})
    public void listInfrasBasicInfo(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        super.listInfrasBasicInfo(req, resp);
    }

    @Override
    @AuditedCall(value={"msgType", "apideployer-infra-get-light-status", "infraId", "${infraId}"})
    @RequestMapping(value={"/api/api-deployer/infras/get-light-status"})
    public void getInfraLightStatus(HttpServletRequest req, HttpServletResponse resp, @RequestParam String infraId) throws Exception {
        super.getInfraLightStatus(req, resp, infraId);
    }

    @Override
    @AuditedCall(value={"msgType", "apideployer-infra-get-settings", "infraId", "${infraId}"})
    @RequestMapping(value={"/api/api-deployer/infras/get-settings"})
    public void getInfraSettings(HttpServletRequest req, HttpServletResponse resp, @RequestParam String infraId) throws Exception {
        super.getInfraSettings(req, resp, infraId);
    }

    @AuditedCall(value={"msgType", "apideployer-infra-create", "infraId", "${infraId}", "stage", "${stage}", "type", "${type}"})
    @RequestMapping(value={"/api/api-deployer/infras/create"})
    public void createInfra(HttpServletRequest req, HttpServletResponse resp, @RequestParam String infraId, @RequestParam String stage, @RequestParam String type, @RequestParam(required=false) String governCheckPolicy) throws Exception {
        AuthCtx user;
        this.checkLicense();
        try (Transaction ignored = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
        }
        AbstractAPIDeploymentInfra newInfra = this.apiNodeInfrasService.createDeploymentInfra_NT(user, AbstractDeploymentInfra.InfraType.valueOf(type), infraId, stage, user.getIdentifier(), StringUtils.isBlank((String)governCheckPolicy) ? AbstractDeploymentInfra.GovernCheckPolicy.NO_CHECK : AbstractDeploymentInfra.GovernCheckPolicy.valueOf(governCheckPolicy));
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.getInfrasService().create_Check(newInfra, user);
            t.commitV("Created infra: %s, of type: %s", new Object[]{newInfra.id, JSON.getType((Object)newInfra)});
        }
        APIDeployerController.writeJSON((HttpServletResponse)resp, (Object)newInfra);
    }

    @Override
    protected AbstractAPIDeploymentInfra getInfra(String infra) {
        return (AbstractAPIDeploymentInfra)JSON.parse((String)infra, AbstractAPIDeploymentInfra.class);
    }

    @Override
    @AuditInline
    @RequestMapping(value={"/api/api-deployer/infras/save"})
    public void saveInfra(HttpServletRequest req, HttpServletResponse resp, @RequestParam String infra) throws Exception {
        super.saveInfra(req, resp, infra);
    }

    @Override
    @AuditedCall(value={"msgType", "apideployer-infra-delete", "infraId", "${infraId}"})
    @RequestMapping(value={"/api/api-deployer/infras/delete"})
    public void deleteInfra(HttpServletRequest req, HttpServletResponse resp, @RequestParam String infraId) throws Exception {
        super.deleteInfra(req, resp, infraId);
    }

    @AuditedCall(value={"msgType", "apideployer-infra-get-sagemaker-instance-types"})
    @RequestMapping(value={"/api/api-deployer/infras/get-sagemaker-instance-types"})
    public void getInstanceTypesForSageMakerInfra(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        APIDeployerController.writeJSON((HttpServletResponse)resp, this.apiNodeInfrasService.getSageMakerInstanceTypes());
    }

    @AuditedCall(value={"msgType", "apideployer-infra-get-azureml-instance-types", "infraId", "${infraId}", "azWorkspace", "${azWorkspace}", "azResourceGroup", "${azResourceGroup}", "azSubscription", "${azSubscription}"})
    @RequestMapping(value={"/api/api-deployer/infras/get-azureml-instance-types"})
    public void getInstanceTypesForAzureMLInfra(HttpServletRequest req, HttpServletResponse resp, @RequestParam String infraId, @RequestParam(required=false) String azWorkspace, @RequestParam(required=false) String azResourceGroup, @RequestParam(required=false) String azSubscription, @RequestParam(required=false) String authConnection) throws Exception {
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
        }
        APIDeployerController.writeJSON((HttpServletResponse)resp, this.apiNodeInfrasService.getAzureMLInstanceTypes_NT(user, authConnection, infraId, azWorkspace, azResourceGroup, azSubscription));
    }

    @AuditedCall(value={"msgType", "apideployer-infra-get-vertexai-instance-types", "infraId", "${infraId}", "gcpProject", "${gcpProject}", "gcpRegion", "${gcpRegion}"})
    @RequestMapping(value={"/api/api-deployer/infras/get-vertexai-instance-types"})
    public void getInstanceTypesForVertexAIInfra(HttpServletRequest req, HttpServletResponse resp, @RequestParam String infraId, @RequestParam(required=false) String gcpProject, @RequestParam(required=false) String gcpRegion, @RequestParam(required=false) String authConnection) throws Exception {
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
        }
        APIDeployerController.writeJSON((HttpServletResponse)resp, this.apiNodeInfrasService.getVertexAIInstanceTypes_NT(user, authConnection, infraId, gcpProject, gcpRegion));
    }

    @AuditedCall(value={"msgType", "apideployer-infra-get-vertexai-accelerator-types"})
    @RequestMapping(value={"/api/api-deployer/infras/get-vertexai-accelerator-types"})
    public void getAcceleratorTypesForVertexAIInfra(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        APIDeployerController.writeJSON((HttpServletResponse)resp, this.apiNodeInfrasService.getVertexAIAcceleratorTypes());
    }

    @AuditedCall(value={"msgType", "apideployer-infra-get-databricks-workload-types"})
    @RequestMapping(value={"/api/api-deployer/infras/get-databricks-workload-types"})
    public void getWorkloadTypesForDatabricksInfra(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        APIDeployerController.writeJSON((HttpServletResponse)resp, this.apiNodeInfrasService.getDatabricksWorkloadTypes());
    }

    @AuditedCall(value={"msgType", "apideployer-infra-get-databricks-workload-size-types"})
    @RequestMapping(value={"/api/api-deployer/infras/get-databricks-workload-size-types"})
    public void getWorkloadSizeTypesForDatabricksInfra(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        APIDeployerController.writeJSON((HttpServletResponse)resp, this.apiNodeInfrasService.getDatabricksWorkloadSizeTypes());
    }

    @AuditedCall(value={"msgType", "apideployer-infra-get-databricks-experiment-location-suggestions", "connection", "${connectionName}"})
    @RequestMapping(value={"/api/api-deployer/infras/get-databricks-experiment-location-suggestions"})
    @ResponseBody
    public FutureResponse<SortedSet<DatabricksWorkspaceDirectoryObject>> getDatabricksExperimentLocationSuggestions(HttpServletRequest req, @RequestParam String connectionName) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        return this.apiNodeInfrasService.getDatabricksExperimentLocationSuggestions(authCtx, connectionName, DeployerUtils.getInfraConnectTimeout(), DeployerUtils.getInfraSocketTimeout());
    }

    @AuditedCall(value={"msgType", "apideployer-infra-get-dku-backend-ext-url"})
    @RequestMapping(value={"/api/api-deployer/infras/get-dku-backend-ext-url"})
    public void getDkuBackendExtHost(HttpServletRequest req, HttpServletResponse resp, @RequestParam boolean forK8s) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
        }
        APIDeployerController.writeJSON((HttpServletResponse)resp, (Object)RemoteRunNetworkingUtils.guessDkuBackendExternalUrl(forK8s));
    }

    @AuditedCall(value={"msgType", "apideployer-infra-get-dku-event-server-url-keys"})
    @RequestMapping(value={"/api/api-deployer/infras/get-dku-event-server-url-keys"})
    public void getDkuEventServerUrlAndKeys(HttpServletRequest req, HttpServletResponse resp, @RequestParam boolean forK8s) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.failIfNotAdmin(req);
            AuthCtx user = this.authService.getMandatoryUser(req);
        }
        APIDeployerController.writeJSON((HttpServletResponse)resp, (Object)this.apiNodeInfrasService.getLocalEventServerExtUrlAndKeys(forK8s, req, resp));
    }

    @Override
    @AuditedCall(value={"msgType", "apideployer-infra-status", "infraId", "${infraId}"})
    @RequestMapping(value={"/api/api-deployer/infras/check-status"})
    public void checkInfraStatus(HttpServletRequest req, HttpServletResponse resp, @RequestParam String infraId) throws Exception {
        super.checkInfraStatus(req, resp, infraId);
    }

    @Override
    @AuditedCall(value={"msgType", "apideployer-deployments-list-tags"})
    @RequestMapping(value={"/api/api-deployer/deployments/list-tags"})
    public void listDeploymentsTags(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        super.listDeploymentsTags(req, resp);
    }

    @Override
    @AuditedCall(value={"msgType", "apideployer-deployments-list"})
    @RequestMapping(value={"/api/api-deployer/deployments/list-basic-info"})
    public void listDeploymentsBasicInfo(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        super.listDeploymentsBasicInfo(req, resp);
    }

    @Override
    @AuditedCall(value={"msgType", "apideployer-deployments-list"})
    @RequestMapping(value={"/api/api-deployer/deployments/list-light-status"})
    public void listDeploymentsLightStatus(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        super.listDeploymentsLightStatus(req, resp);
    }

    @Override
    @AuditedCall(value={"msgType", "apideployer-deployment-get", "deploymentId", "${deploymentId}"})
    @RequestMapping(value={"/api/api-deployer/deployments/get-light-status"})
    public void getDeploymentLightStatus(HttpServletRequest req, HttpServletResponse resp, @RequestParam String deploymentId) throws Exception {
        super.getDeploymentLightStatus(req, resp, deploymentId);
    }

    @Override
    @AuditedCall(value={"msgType", "apideployer-deployment-get", "deploymentId", "${deploymentId}"})
    @RequestMapping(value={"/api/api-deployer/deployments/get-settings"})
    public void getDeploymentSettings(HttpServletRequest req, HttpServletResponse resp, @RequestParam String deploymentId) throws Exception {
        super.getDeploymentSettings(req, resp, deploymentId);
    }

    @AuditedCall(value={"msgType", "apideployer-deployment-copy", "deploymentId", "${deploymentId}", "newDeploymentId", "${newDeploymentId}", "newInfraId", "${newInfraId}", "endpointId", "${endpointId}"})
    @RequestMapping(value={"/api/api-deployer/deployments/copy"})
    public void copyDeployment(HttpServletRequest req, HttpServletResponse resp, @RequestParam String deploymentId, @RequestParam String newDeploymentId, @RequestParam String newInfraId, @RequestParam(required=false) String endpointId) throws Exception {
        Object targetDeployment;
        AbstractInfraBasicInfo infraBasicInfo;
        AbstractAPIServiceDeployment sourceDeployment;
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            sourceDeployment = (AbstractAPIServiceDeployment)this.getDeploymentsService().getSettingsMandatoryUnsafe_Check(deploymentId, user);
            this.getDeploymentsService().checkDeployPermissions(newInfraId, sourceDeployment.getPublishedItemId(), user);
            infraBasicInfo = this.getInfrasService().getLightStatusUnsafe_Check((String)newInfraId, (AuthCtx)user).infraBasicInfo;
        }
        PublishedApiServicePackageInfo publishedPackageInfo = null;
        if (sourceDeployment.generationsMapping != null && sourceDeployment.generationsMapping.getEntries().size() == 1) {
            String version = sourceDeployment.generationsMapping.getEntries().get((int)0).generation;
            publishedPackageInfo = this.getPackage(user, sourceDeployment.publishedServiceId, version);
        }
        this.deploymentsService.doGovernanceCheck_NT(infraBasicInfo, sourceDeployment);
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            String deplId = this.deploymentsService.copy_Check(user, deploymentId, newDeploymentId, newInfraId, endpointId, publishedPackageInfo);
            targetDeployment = this.deploymentsService.getSettingsMandatoryUnsafe_Check(deplId, user);
            t.commitV("Created API deployment: %s", new Object[]{((AbstractDeployment)targetDeployment).id});
        }
        APIDeployerController.writeJSON((HttpServletResponse)resp, targetDeployment);
    }

    @AuditedCall(value={"msgType", "apideployer-deployment-create", "deploymentId", "${deploymentId}", "publishedServiceId", "${publishedServiceId}", "infraId", "${infraId}", "version", "${version}", "endpointId", "${endpointId}"})
    @RequestMapping(value={"/api/api-deployer/deployments/create"})
    public void createDeployment(HttpServletRequest req, HttpServletResponse resp, @RequestParam String deploymentId, @RequestParam String publishedServiceId, @RequestParam String infraId, @RequestParam(required=false) String version, @RequestParam(required=false) String endpointId) throws Exception {
        AbstractAPIServiceDeployment deployment;
        GeneralSettingsDAO.GeneralSettings generalSettings;
        AbstractInfraBasicInfo infraBasicInfo;
        AuthCtx user;
        this.checkLicense();
        try (Transaction ignored = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            this.getDeploymentsService().checkDeployPermissions(infraId, publishedServiceId, user);
            infraBasicInfo = this.getInfrasService().getLightStatusUnsafe_Check((String)infraId, (AuthCtx)user).infraBasicInfo;
            generalSettings = ApplicationConfigurator.getGeneralSettings();
        }
        PublishedApiServicePackageInfo publishedPackageInfo = this.getPackage(user, publishedServiceId, version);
        version = publishedPackageInfo.id;
        this.deploymentsService.doGovernanceCheck_NT(infraBasicInfo, publishedServiceId, Collections.singletonList(version));
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            String deplId = this.deploymentsService.create_Check(user, deploymentId, publishedServiceId, infraId, version, endpointId, publishedPackageInfo, true, Collections.emptyList(), generalSettings.dataikuCloudK8SApiDeploymentSettings);
            deployment = (AbstractAPIServiceDeployment)this.deploymentsService.getSettingsMandatoryUnsafe_Check(deplId, user);
            t.commitV("Created API deployment: %s", new Object[]{deployment.id});
        }
        APIDeployerController.writeJSON((HttpServletResponse)resp, (Object)deployment);
    }

    @AuditedCall(value={"msgType", "apideployer-deployment-get-open-api", "deploymentId", "${deploymentId}"})
    @RequestMapping(value={"/api/api-deployer/deployments/get-open-api"})
    public void getDeploymentOpenAPI(HttpServletRequest req, HttpServletResponse resp, @RequestParam String deploymentId) throws Exception {
        AuthCtx user;
        this.checkLicense();
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
        }
        String oad = this.deploymentsService.getDeploymentOpenAPIDocContentOrNull_Check_NT(user, deploymentId);
        if (oad == null) {
            resp.setStatus(204);
            APIDeployerController.writeEmptyJSONObj((HttpServletResponse)resp);
        } else {
            APIDeployerController.writeJSONString((HttpServletResponse)resp, (String)oad);
        }
    }

    @Override
    void saveAndCommit(AuthCtx user, AbstractAPIServiceDeployment updatedDepl, RWTransaction t) throws Exception {
        if (updatedDepl.auth.apiKeys != null) {
            for (QueryAPIKey qak : updatedDepl.auth.apiKeys) {
                if (!StringUtils.isBlank((String)qak.key)) continue;
                qak.key = SecretKeyGenerator.generate((int)32);
                qak.createdOn = System.currentTimeMillis();
                qak.createdBy = t.getUser().getIdentifier();
            }
        }
        super.saveAndCommit(user, updatedDepl, t);
    }

    @AuditInline
    @RequestMapping(value={"/api/api-deployer/deployments/save"})
    public void saveDeployment(HttpServletRequest req, HttpServletResponse resp, @RequestParam String deployment) throws Exception {
        AbstractInfraBasicInfo infraBasicInfo;
        AuthCtx user;
        AbstractAPIServiceDeployment updatedDeployment = (AbstractAPIServiceDeployment)JSON.parse((String)deployment, AbstractAPIServiceDeployment.class);
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            this.getDeploymentsService().checkDeployPermissions(updatedDeployment.id, user);
            infraBasicInfo = this.getInfrasService().getLightStatusUnsafe_Check((String)updatedDeployment.infraId, (AuthCtx)user).infraBasicInfo;
        }
        if (updatedDeployment.generationsMapping == null) {
            throw ErrorContext.iae((String)"The deployment does not contain any version.");
        }
        ArrayList<String> versionIds = new ArrayList<String>();
        updatedDeployment.generationsMapping.validate();
        for (GenerationsMapping.MappingEntry generationsMapping : updatedDeployment.generationsMapping.getEntries()) {
            versionIds.add(generationsMapping.generation);
        }
        this.saveDeployment(req, resp, user, updatedDeployment, infraBasicInfo, updatedDeployment.publishedServiceId, versionIds);
    }

    @AuditedCall(value={"msgType", "apideployer-deployment-set-version", "deploymentId", "${deploymentId}"})
    @RequestMapping(value={"/api/api-deployer/deployments/switch-version"})
    public void switchVersion(HttpServletRequest req, HttpServletResponse resp, @RequestParam String deploymentId, @RequestParam String versionId) throws Exception {
        AbstractInfraBasicInfo infraBasicInfo;
        AbstractAPIServiceDeployment deployment;
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            this.getDeploymentsService().checkDeployPermissions(deploymentId, user);
            deployment = (AbstractAPIServiceDeployment)this.getDeploymentsService().getSettingsMandatoryUnsafe_Check(deploymentId, user);
            infraBasicInfo = this.getInfrasService().getLightStatusUnsafe_Check((String)deployment.infraId, (AuthCtx)user).infraBasicInfo;
        }
        this.switchVersion(req, resp, user, deploymentId, versionId, infraBasicInfo, deployment.publishedServiceId);
    }

    @AuditInline
    @RequestMapping(value={"/api/api-deployer/deployments/get-governance-status-deployment-id"})
    public void getGovernanceStatusForDeploymentId(HttpServletRequest req, HttpServletResponse resp, @RequestParam String deploymentId, @RequestParam(required=false) String version, @RequestParam(required=false) String infraId) throws Exception {
        try {
            AbstractInfraBasicInfo infraBasicInfo;
            String usedInfraId;
            AbstractAPIServiceDeployment deployment;
            try (Transaction t = this.transactionService.beginRead();){
                AuthCtx user = this.authService.getMandatoryUser(req);
                deployment = (AbstractAPIServiceDeployment)this.getDeploymentsService().getSettingsMandatoryUnsafe_Check(deploymentId, user);
                usedInfraId = StringUtils.isBlank((String)infraId) ? deployment.infraId : infraId;
                infraBasicInfo = this.getInfrasService().getLightStatusUnsafe_Check((String)usedInfraId, (AuthCtx)user).infraBasicInfo;
            }
            ArrayList<String> versionIds = new ArrayList<String>();
            if (!StringUtils.isEmpty((String)version)) {
                versionIds.add(version);
            } else {
                if (deployment.generationsMapping == null) {
                    throw ErrorContext.iae((String)"The deployment does not contain any version.");
                }
                deployment.generationsMapping.validate();
                for (GenerationsMapping.MappingEntry generationsMapping : deployment.generationsMapping.getEntries()) {
                    versionIds.add(generationsMapping.generation);
                }
            }
            InfoMessage.InfoMessages governanceMessages = this.deploymentsService.getGovernanceMessages_NT(infraBasicInfo, deployment.publishedServiceId, versionIds);
            APIDeployerController.writeJSON((HttpServletResponse)resp, (Object)governanceMessages);
            this.auditTrailService.generic("apideployer-deployment-governance-status-get").with("deploymentId", deployment.id).with("publishedServiceId", deployment.publishedServiceId).with("infraId", usedInfraId).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("apideployer-deployment-governance-status-get", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/api-deployer/deployments/get-governance-status-deployment"})
    public void getGovernanceStatusForDeployment(HttpServletRequest req, HttpServletResponse resp, @RequestParam String deployment) throws Exception {
        try {
            AbstractInfraBasicInfo infraBasicInfo;
            AbstractAPIServiceDeployment parsedDeployment = (AbstractAPIServiceDeployment)JSON.parse((String)deployment, AbstractAPIServiceDeployment.class);
            try (Transaction t = this.transactionService.beginRead();){
                AuthCtx user = this.authService.getMandatoryUser(req);
                infraBasicInfo = this.getInfrasService().getLightStatusUnsafe_Check((String)parsedDeployment.infraId, (AuthCtx)user).infraBasicInfo;
            }
            if (parsedDeployment.generationsMapping == null) {
                throw ErrorContext.iae((String)"The deployment does not contain any version.");
            }
            ArrayList<String> versionIds = new ArrayList<String>();
            parsedDeployment.generationsMapping.validate();
            for (GenerationsMapping.MappingEntry generationsMapping : parsedDeployment.generationsMapping.getEntries()) {
                versionIds.add(generationsMapping.generation);
            }
            InfoMessage.InfoMessages governanceMessages = this.deploymentsService.getGovernanceMessages_NT(infraBasicInfo, parsedDeployment.publishedServiceId, versionIds);
            APIDeployerController.writeJSON((HttpServletResponse)resp, (Object)governanceMessages);
            this.auditTrailService.generic("apideployer-deployment-governance-status-get").with("deploymentId", parsedDeployment.id).with("publishedServiceId", parsedDeployment.publishedServiceId).with("infraId", parsedDeployment.infraId).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("apideployer-deployment-governance-status-get", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditedCall(value={"msgType", "apideployer-deployment-governance-status-get", "publishedServiceId", "${publishedServiceId}", "infraId", "${infraId}"})
    @RequestMapping(value={"/api/api-deployer/deployments/get-governance-status-new-deployment"})
    public void getGovernanceStatusForNewDeployment(HttpServletRequest req, HttpServletResponse resp, @RequestParam String publishedServiceId, @RequestParam String infraId, @RequestParam String version) throws Exception {
        AbstractInfraBasicInfo infraBasicInfo;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            infraBasicInfo = this.getInfrasService().getLightStatusUnsafe_Check((String)infraId, (AuthCtx)user).infraBasicInfo;
        }
        InfoMessage.InfoMessages governanceMessages = this.deploymentsService.getGovernanceMessages_NT(infraBasicInfo, publishedServiceId, Collections.singletonList(version));
        APIDeployerController.writeJSON((HttpServletResponse)resp, (Object)governanceMessages);
    }

    @Override
    @AuditedCall(value={"msgType", "apideployer-deployment-delete", "deploymentId", "${deploymentId}"})
    @RequestMapping(value={"/api/api-deployer/deployments/delete"})
    public void deleteDeployment(HttpServletRequest req, HttpServletResponse resp, @RequestParam String deploymentId, @RequestParam(required=false, defaultValue="false") boolean ignorePreDeleteErrors) throws Exception {
        super.deleteDeployment(req, resp, deploymentId, ignorePreDeleteErrors);
    }

    @AuditedCall(value={"msgType", "apideployer-deployment-get", "deploymentId", "${deploymentId}"})
    @RequestMapping(value={"/api/api-deployer/deployments/get-heavy-status"})
    public void getHeavyStatus(HttpServletRequest req, HttpServletResponse resp, @RequestParam String deploymentId, @RequestParam boolean withPackageExtraInfo) throws Exception {
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
        }
        APIDeployerController.writeJSONWithNoNaNAndNull((HttpServletResponse)resp, (Object)this.deploymentsService.getHeavyStatus_Unsafe_NT_Check(user, deploymentId, withPackageExtraInfo));
    }

    @AuditedCall(value={"msgType", "apideployer-deployments-list-heavy-status", "infraId", "${infraId}"})
    @RequestMapping(value={"/api/api-deployer/deployments/list-heavy-status"})
    public void listHeavyStatus(HttpServletRequest req, HttpServletResponse resp, @RequestParam String infraId, @RequestParam boolean withPackageExtraInfo) throws Exception {
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
        }
        APIDeployerController.writeJSON((HttpServletResponse)resp, this.deploymentsService.listHeavyStatusUnsafe_NT_Check(user, infraId, withPackageExtraInfo));
    }

    @AuditedCall(value={"msgType", "apideployer-deployment-full-check", "deploymentId", "${deploymentId}"})
    @RequestMapping(value={"/api/api-deployer/deployments/get-full-check-report"})
    public void getFullCheckReport(HttpServletRequest req, HttpServletResponse resp, @RequestParam String deploymentId) throws Exception {
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
        }
        APIDeployerController.writeJSON((HttpServletResponse)resp, (Object)this.deploymentsService.getFullCheckReport_NT_Check(user, deploymentId));
    }

    @AuditedCall(value={"msgType", "apideployer-infra-audit-storage-url", "infraId", "${infraId}"})
    @RequestMapping(value={"/api/api-deployer/infras/get-storage-url"})
    public void getAuditLogStorageUrl(HttpServletRequest req, HttpServletResponse resp, @RequestParam String infraId, @RequestParam(required=false) String connectionName, @RequestParam(required=false) String pathWithinConnection, @RequestParam(required=false) String bucket) throws Exception {
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
        }
        APIDeployerController.writeJSON((HttpServletResponse)resp, (Object)this.deploymentsService.getStorageUrl_NT_Check(user, infraId, connectionName, pathWithinConnection, bucket));
    }

    @AuditedCall(value={"msgType", "apideployer-deployment-audit-storage-url", "infraId", "${infraId}"})
    @RequestMapping(value={"/api/api-deployer/deployments/get-storage-url"})
    public void getAuditLogStorageUrl(HttpServletRequest req, HttpServletResponse resp, @RequestParam String infraId) throws Exception {
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
        }
        APIDeployerController.writeJSON((HttpServletResponse)resp, (Object)this.deploymentsService.getStorageUrl_NT_Check(user, infraId));
    }

    @AuditedCall(value={"msgType", "apideployer-deployment-sync", "deploymentId", "${deploymentId}"})
    @RequestMapping(value={"/api/api-deployer/deployments/execute-sync-static"})
    public void executeSyncStatic(HttpServletRequest req, HttpServletResponse resp, @RequestParam String deploymentId, @RequestParam boolean forceRefresh, @RequestParam(required=false, defaultValue="true") boolean withPrepare) throws Exception {
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
        }
        APIDeployerController.writeJSON((HttpServletResponse)resp, this.deploymentsService.executeSyncStatic_NT_Check(user, deploymentId, forceRefresh, withPrepare));
    }

    @AuditedCall(value={"msgType", "apideployer-deployment-sync", "deploymentId", "${deploymentId}"})
    @RequestMapping(value={"/api/api-deployer/deployments/execute-sync-docker-based"})
    public void executeSyncK8S(HttpServletRequest req, HttpServletResponse resp, @RequestParam String deploymentId, @RequestParam(required=false) boolean rebuildCodeEnv) throws Exception {
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
        }
        APIDeployerController.writeJSON((HttpServletResponse)resp, this.deploymentsService.executeSyncDockerBased_NT_Check(user, deploymentId, rebuildCodeEnv));
    }

    @AuditedCall(value={"msgType", "apideployer-deployment-get", "deploymentId", "${deploymentId}"})
    @RequestMapping(value={"/api/api-deployer/deployments/carbonapi-chart"})
    public void getCarbonAPIChart(HttpServletRequest req, HttpServletResponse resp, @RequestParam String deploymentId, @RequestParam(required=false) String endpointId, @RequestParam String chartType, @RequestParam String timeRange, @RequestParam String format) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUserNoXSRF(req);
        }
        this.getDeploymentsService().streamChartData_NT_Check(resp, authCtx, deploymentId, endpointId, APIServiceDeploymentsService.CarbonAPITimeRange.valueOf(timeRange), APIServiceDeploymentsService.CarbonAPIChartType.valueOf(chartType), format);
    }

    @AuditedCall(value={"msgType", "apideployer-deployment-test", "deploymentId", "${deploymentId}", "endpointId", "${endpointId}"})
    @RequestMapping(value={"/api/api-deployer/deployments/run-test-queries"})
    public void runTestQueries(HttpServletRequest req, HttpServletResponse resp, @RequestParam String deploymentId, @RequestParam String endpointId, @RequestParam String testQueries, @RequestParam(required=false) String unsavedTestQueries) throws Exception {
        AuthCtx authCtx;
        List testQueriesObj;
        try {
            testQueriesObj = (List)JSON.parse((String)testQueries, (TypeToken)new TypeToken<List<ApiEndpointQuery>>(){});
        }
        catch (JsonSyntaxException e) {
            throw new JsonSyntaxException("One or more test queries have an invalid format");
        }
        Map additionalTestQueries = (Map)JSON.parse((String)unsavedTestQueries, (TypeToken)new TypeToken<Map<String, ApiEndpointQuery>>(){});
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        APIDeployerController.writeJSON((HttpServletResponse)resp, (Object)this.deploymentsService.runQueries_NT_Check(deploymentId, endpointId, authCtx, testQueriesObj, additionalTestQueries, true, false));
    }

    @AuditedCall(value={"msgType", "apideployer-get-status"})
    @RequestMapping(value={"/api/api-deployer/global-light-status"})
    public void getGlobalLightStatus(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        List<InfraLightStatus> infraStatusList;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            infraStatusList = this.apiNodeInfrasService.listLightStatusUnsafe_Check(authCtx);
        }
        List<AbstractDeploymentLightStatus> deploymentStatusList = this.deploymentsService.listLightStatusUnsafe_NT_Check(authCtx);
        List<AbstractPublishedItemLightStatus> publishedServiceStatusList = this.publishedAPIServicesService.listLightStatusUnsafe_NT_Check(authCtx);
        APIDeployerController.writeJSON((HttpServletResponse)resp, (Object)new AbstractGlobalLightStatus.APIDeployerGlobalLightStatus(deploymentStatusList, infraStatusList, publishedServiceStatusList));
    }

    @AuditedCall(value={"msgType", "apideployer-deployment-diagnosis", "deploymentId", "${deploymentId}"})
    @RequestMapping(value={"/api/api-deployer/deployments/start-diagnosis"})
    public void startDiagnosis(HttpServletRequest req, HttpServletResponse resp, @RequestParam String deploymentId) throws Exception {
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
        }
        APIDeployerController.writeJSON((HttpServletResponse)resp, this.deploymentsService.startDiagnosis_NT_Check(user, deploymentId));
    }

    @AuditedCall(value={"msgType", "apideployer-deployment-diagnosis", "deploymentId", "${deploymentId}"})
    @RequestMapping(value={"/api/api-deployer/deployments/get-diagnosis"})
    public void getDiagnosis(HttpServletRequest req, HttpServletResponse resp, @RequestParam String deploymentId, @RequestParam String diagnosticName) throws Exception {
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUserNoXSRF(req);
        }
        this.deploymentsService.getDiagnosis_NT_Check(user, resp, deploymentId, diagnosticName);
    }

    @Override
    @AuditedCall(value={"msgType", "apideployer-deployment-list-logs", "projectKey", "${projectKey}", "deploymentId", "${deploymentId}"})
    @RequestMapping(value={"/api/api-deployer/deployments/list-logs"})
    public void getLogsList(HttpServletRequest req, HttpServletResponse resp, @RequestParam String deploymentId) throws Exception {
        super.getLogsList(req, resp, deploymentId);
    }

    @Override
    @AuditedCall(value={"msgType", "apideployer-deployment-get-log", "projectKey", "${projectKey}", "deploymentId", "${deploymentId}", "logName", "${logName}"})
    @RequestMapping(value={"/api/api-deployer/deployments/get-log"})
    public void getLog(HttpServletRequest req, HttpServletResponse resp, @RequestParam String deploymentId, @RequestParam String logName) throws Exception {
        super.getLog(req, resp, deploymentId, logName);
    }

    @Override
    @AuditedCall(value={"msgType", "apideployer-deployment-stream-log", "projectKey", "${projectKey}", "deploymentId", "${deploymentId}", "logName", "${logName}"})
    @RequestMapping(value={"/api/api-deployer/deployments/stream-log"})
    public void streamLog(HttpServletRequest req, HttpServletResponse resp, @RequestParam String deploymentId, @RequestParam String logName) throws Exception {
        super.streamLog(req, resp, deploymentId, logName);
    }

    @Override
    @AuditedCall(value={"msgType", "apideployer-deployment-get-logs-zip", "projectKey", "${projectKey}", "deploymentId", "${deploymentId}"})
    @RequestMapping(value={"/api/api-deployer/deployments/all-logs-zip"})
    public void getAllLogsZip(HttpServletRequest req, HttpServletResponse resp, @RequestParam String deploymentId) throws Exception {
        super.getAllLogsZip(req, resp, deploymentId);
    }

    @Override
    @AuditedCall(value={"msgType", "apideployer-deployment-get-last-action", "deploymentId", "${deploymentId}"})
    @RequestMapping(value={"/api/api-deployer/deployments/get-last-action"})
    public void getLastDeploymentAction(HttpServletRequest req, HttpServletResponse resp, @RequestParam String deploymentId) throws Exception {
        super.getLastDeploymentAction(req, resp, deploymentId);
    }

    @Override
    @AuditedCall(value={"msgType", "apideployer-deployment-peek-action-progress", "deploymentId", "${deploymentId}"})
    @RequestMapping(value={"/api/api-deployer/deployments/peek-action-progress"})
    public void peekDeploymentActionProgress(HttpServletRequest req, HttpServletResponse resp, String deploymentId, @RequestParam(required=false) String jobId) throws Exception {
        super.peekDeploymentActionProgress(req, resp, deploymentId, jobId);
    }

    @AuditedCall(value={"msgType", "apideployer-deployment-abort-action", "deploymentId", "${deploymentId}"})
    @RequestMapping(value={"/api/api-deployer/deployments/abort-action"})
    public void abortDeploymentAction(HttpServletRequest req, HttpServletResponse resp, String deploymentId) throws Exception {
        super.abortDeploymentAction(req, deploymentId);
    }

    @Override
    @AuditedCall(value={"msgType", "apideployer-deployment-get-update", "deploymentId", "${deploymentId}", "startTimestamp", "${startTimestamp}"})
    @RequestMapping(value={"/api/api-deployer/deployments/get-update"})
    public void getDeploymentUpdate(HttpServletRequest req, HttpServletResponse resp, @RequestParam String deploymentId, @RequestParam String startTimestamp) throws Exception {
        super.getDeploymentUpdate(req, resp, deploymentId, startTimestamp);
    }

    @Override
    @AuditedCall(value={"msgType", "apideployer-deployment-list-update-heads", "deploymentId", "${deploymentId}"})
    @RequestMapping(value={"/api/api-deployer/deployments/list-update-heads"})
    public void listDeploymentUpdateHeads(HttpServletRequest req, HttpServletResponse resp, @RequestParam String deploymentId) throws Exception {
        super.listDeploymentUpdateHeads(req, resp, deploymentId);
    }

    @Override
    @AuditedCall(value={"msgType", "apideployer-deployment-get-update-settings-diff", "deploymentId", "${deploymentId}", "startTimestamp", "${startTimestamp}"})
    @RequestMapping(value={"/api/api-deployer/deployments/get-update-settings-diff"})
    public void getUpdateSettingsDiff(HttpServletRequest req, HttpServletResponse resp, @RequestParam String deploymentId, @RequestParam String startTimestamp) throws Exception {
        super.getUpdateSettingsDiff(req, resp, deploymentId, startTimestamp);
    }
}

