/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.badges.ApiServiceTypeBadgesService;
import com.dataiku.dip.badges.ProjectTypeBadgesService;
import com.dataiku.dip.badges.TypeBadge;
import com.dataiku.dip.badges.TypeBadges;
import com.dataiku.dip.dao.ProjectBadgesDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.google.common.annotations.VisibleForTesting;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class TypeBadgesController {
    private final TransactionService transactionService;
    private final IPermissionsService permService;
    private final UIAuthService authService;
    private final ProjectTypeBadgesService projectTypeBadgesService;
    private final ApiServiceTypeBadgesService apiServiceTypeBadgesService;
    private final ProjectBadgesDAO projectBadgesDAO;

    @Autowired
    public TypeBadgesController(TransactionService transactionService, IPermissionsService permService, UIAuthService authService, ProjectTypeBadgesService projectTypeBadgesService, ApiServiceTypeBadgesService apiServiceTypeBadgesService, ProjectBadgesDAO projectBadgesDAO) {
        this.transactionService = transactionService;
        this.permService = permService;
        this.authService = authService;
        this.projectTypeBadgesService = projectTypeBadgesService;
        this.apiServiceTypeBadgesService = apiServiceTypeBadgesService;
        this.projectBadgesDAO = projectBadgesDAO;
    }

    @AuditedCall(value={"msgType", "project-synchronize-type-badges", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/type-badges/projects/sync"}, method={RequestMethod.POST})
    @ResponseBody
    public void synchronizeProjectTypeBadges(HttpServletRequest req, @RequestParam String projectKey) throws IOException, DKUSecurityException {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.permService.checkProjectPrivileges(user, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
        }
        this.projectTypeBadgesService.synchronizeBadges_NT(projectKey);
    }

    @AuditedCall(value={"msgType", "project-list-details-type-badges", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/type-badges/projects/list-details"}, method={RequestMethod.GET})
    @ResponseBody
    @VisibleForTesting
    public TypeBadges listProjectsTypeBadges(HttpServletRequest req, @RequestParam String projectKey) throws IOException, DKUSecurityException {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.permService.checkProjectPrivileges(user, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            TypeBadges typeBadges = this.projectBadgesDAO.getUnsafe((String)projectKey).typeBadges;
            return typeBadges;
        }
    }

    @AuditedCall(value={"msgType", "api-services-synchronize-type-badges", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/type-badges/api-services/sync"}, method={RequestMethod.POST})
    @ResponseBody
    public void synchronizeApiServicesTypeBadges(HttpServletRequest req, @RequestParam String projectKey) throws IOException, DKUSecurityException {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.permService.checkProjectPrivileges(user, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
        }
        this.apiServiceTypeBadgesService.synchronizeBadges_NT(projectKey);
    }

    @AuditedCall(value={"msgType", "api-services-list-type-badges", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/type-badges/api-services/list"}, method={RequestMethod.GET})
    @ResponseBody
    public List<TypeBadge> listApiServicesTypeBadges(HttpServletRequest req, @RequestParam String projectKey) throws IOException, DKUSecurityException {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.permService.checkProjectPrivileges(user, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            List<TypeBadge> list = this.apiServiceTypeBadgesService.listBadges(projectKey);
            return list;
        }
    }
}

