/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.SmartObjectRef;
import com.dataiku.dip.analysis.ml.MLTaskLoc;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.CodeEnvPermissionsService;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.NotAuthenticatedException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.export.ZipUnzipDir;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.plugins.dev.DevPluginsService;
import com.dataiku.dip.remoterun.RemoteRunNetworkingUtils;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.PermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.security.auth.NotLoggedInException;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.security.model.ProjectScopePublicAPIKey;
import com.dataiku.dip.security.model.PublicAPIKey;
import com.dataiku.dip.security.trust.TrustedCodeService;
import com.dataiku.dip.server.TagFilterUtils;
import com.dataiku.dip.server.api.auth.PublicAPIKeysService;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.InterestsService;
import com.dataiku.dip.server.services.NavigatorService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.licensing.LicenseEnforcementService;
import com.dataiku.dip.timelines.TimelinesService;
import com.dataiku.dip.transactions.ifaces.MinimalRWTransaction;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dip.webapps.WebApp;
import com.dataiku.dip.webapps.WebAppHandler;
import com.dataiku.dip.webapps.WebAppMeta;
import com.dataiku.dip.webapps.WebAppRegistry;
import com.dataiku.dip.webapps.WebAppSecurityInfo;
import com.dataiku.dip.webapps.WebAppTemplateDesc;
import com.dataiku.dip.webapps.WebAppsService;
import com.dataiku.dip.webapps.WebAppsTemplatesService;
import com.dataiku.dip.webapps.backend.AbstractWebAppBackendRunner;
import com.dataiku.dip.webapps.backend.WebAppBackend;
import com.dataiku.dip.webapps.backend.WebAppBackendInstance;
import com.dataiku.dip.webapps.backend.WebAppBackendsManager;
import com.dataiku.dip.webapps.bokeh.BokehWebAppMeta;
import com.dataiku.dip.webapps.codestudio.CodeStudioWebAppMeta;
import com.dataiku.dip.webapps.dash.DashWebAppMeta;
import com.dataiku.dip.webapps.plugins.CustomWebAppDesc;
import com.dataiku.dip.webapps.plugins.CustomWebAppMeta;
import com.dataiku.dip.webapps.shiny.ShinyWebAppMeta;
import com.dataiku.dip.webapps.standard.StandardWebAppMeta;
import com.dataiku.dip.webapps.tensorboard.TensorBoardService;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.google.gson.JsonObject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class WebAppsController
extends DIPInternalControllerBase {
    @Autowired
    private WebAppsService webAppsService;
    @Autowired
    private WebAppsTemplatesService templatesService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private MetaAuthService metaAuthService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private InterestsService interestsService;
    @Autowired
    private NavigatorService navigatorService;
    @Autowired
    private TimelinesService timelinesService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private LicenseEnforcementService licenseEnforcementService;
    @Autowired
    private TensorBoardService tensorBoardService;
    @Autowired
    private VariablesService variablesService;
    @Autowired
    private WebAppBackendsManager backendsManager;
    @Autowired
    private PublicAPIKeysService publicAPIKeysService;
    @Autowired
    private PermissionsService permissionsService;
    @Autowired
    private TrustedCodeService trustedCodeService;
    @Autowired
    private CodeEnvPermissionsService codeEnvPermissionsService;
    @Autowired
    private PasswordEncryptionService passwordEncryptionService;
    private static Logger logger = Logger.getLogger((String)"dku.webapps.controller");

    @AuditNotNeeded
    @RequestMapping(value={"/api/webapps/list-templates"})
    public void listTemplates(HttpServletRequest req, HttpServletResponse resp, @RequestParam String type) throws IOException {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
        }
        WebAppsController.writeJSON((HttpServletResponse)resp, this.templatesService.listOfType(type));
    }

    @AuditedCall(value={"msgType", "webapps-list", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/webapps/list"})
    public void list(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            WebAppsController.writeJSON((HttpServletResponse)resp, this.webAppsService.listUnsafe_noCode(projectKey));
        }
    }

    @AuditedCall(value={"msgType", "webapps-list", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/webapps/list-heads"})
    @ResponseBody
    public TaggableObjectsService.FilteredTaggableItems<WebApp.WebAppListItem> listHeads(HttpServletRequest req, @RequestParam String projectKey, @RequestParam(required=false) String tagFilter) throws Exception {
        AuthCtx user;
        TagFilterUtils.TagFilter tf = (TagFilterUtils.TagFilter)JSON.parse((String)tagFilter, TagFilterUtils.TagFilter.class);
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        TaggableObjectsService.FilteredTaggableItems<WebApp.WebAppListItem> heads = new TaggableObjectsService.FilteredTaggableItems<WebApp.WebAppListItem>();
        for (WebApp.WebAppListItem head : this.webAppsService.listHeads_NT(projectKey)) {
            if (!TagFilterUtils.matches(tf, head.tags)) {
                ++heads.filteredOut;
                continue;
            }
            heads.items.add(head);
        }
        this.interestsService.enrichHeads(user.getAssociatedDSSUser(), projectKey, heads.items);
        return heads;
    }

    @AuditedCall(value={"msgType", "webapp-get", "projectKey", "${projectKey}", "webAppId", "${webAppId}"})
    @RequestMapping(value={"/api/webapps/get-full-info"})
    public void getFullInfo(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String webAppId) throws Exception {
        NavigatorService.WebAppFullInfo info;
        AuthCtx u;
        try (Transaction t = this.transactionService.beginRead();){
            u = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(u, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            info = this.navigatorService.getWebAppFullInfo(u, projectKey, webAppId);
        }
        this.navigatorService.addInfo_NT(info, u);
        WebAppsController.writeJSON((HttpServletResponse)resp, (Object)info);
    }

    @AuditedCall(value={"msgType", "webapp-get", "projectKey", "${projectKey}", "webAppId", "${webAppId}"})
    @RequestMapping(value={"/api/webapps/get-public-info"})
    public void getPublicInfo(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String webAppId) throws Exception {
        NavigatorService.WebAppFullInfo info;
        AuthCtx u;
        try (Transaction t = this.transactionService.beginRead();){
            u = this.authService.getMandatoryUser(req);
            this.projectsService.checkReadDashboardPerm(u, projectKey, ITaggingService.TaggableType.WEB_APP, webAppId);
            info = this.navigatorService.getWebAppPublicInfo(u, projectKey, webAppId);
        }
        this.navigatorService.addInfo_NT(info, u);
        WebAppsController.writeJSON((HttpServletResponse)resp, (Object)info);
    }

    @AuditedCall(value={"msgType", "webapp-get", "projectKey", "${projectKey}", "webAppId", "${webAppId}"})
    @RequestMapping(value={"/api/webapps/get-summary"})
    public void getSummary(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String webAppId) throws Exception {
        WebApp webApp;
        AuthCtx authCtx;
        WebApp.WebAppSummary summary = new WebApp.WebAppSummary();
        boolean keepFutureIdInResponse = false;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            if (this.permissionsService.hasProjectPrivilege(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF)) {
                keepFutureIdInResponse = true;
            } else {
                this.projectsService.checkReadDashboardPerm(authCtx, projectKey, ITaggingService.TaggableType.WEB_APP, webAppId);
            }
            webApp = this.webAppsService.getMandatory(projectKey, webAppId);
        }
        if (webApp.apiKey != null) {
            try {
                webApp.apiKey = this.passwordEncryptionService.decryptIfEncrypted(webApp.apiKey);
            }
            catch (IllegalArgumentException e) {
                logger.warn((Object)"Failed to decrypt webapp api key", (Throwable)e);
            }
        }
        summary.object = webApp;
        try {
            WebAppBackendInstance.BackendState backendState;
            summary.backendState = backendState = this.webAppsService.getBackendState(webApp, keepFutureIdInResponse);
        }
        catch (Exception e) {
            logger.info((Object)"Failed to get web app backend state", (Throwable)e);
        }
        summary.timeline = this.timelinesService.getObjectTimeline_NT(summary.object, 0, 100);
        summary.interest = this.interestsService.getObjectAndUserInterest_noFail(authCtx, summary.object);
        summary.trustedCodeReport = this.trustedCodeService.computeWebAppTrustedCodeReport_NT(authCtx, projectKey, webAppId);
        WebAppsController.writeJSON((HttpServletResponse)resp, (Object)summary);
    }

    @AuditInline
    @RequestMapping(value={"/api/webapps/create"})
    public void create(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String name, @RequestParam String type, @RequestParam(required=false) String templateDesc, @RequestParam(required=false, defaultValue="{}") String config, @RequestParam(required=false) String initialParams) throws Exception {
        String precomputedFingerprint;
        WebApp webApp;
        WebAppsService.WebAppCreateResponse creation;
        AuthCtx authCtx;
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPermAndCanCreateWebContent(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            WebAppTemplateDesc desc = (WebAppTemplateDesc)JSON.parse((String)templateDesc, WebAppTemplateDesc.class);
            JsonObject cfg = (JsonObject)JSON.parse((String)config, JsonObject.class);
            JsonObject prm = StringUtils.isNotBlank((String)initialParams) ? (JsonObject)JSON.parse((String)initialParams, JsonObject.class) : null;
            creation = this.webAppsService.create(authCtx, projectKey, name, type, desc, prm, cfg);
            webApp = creation.webapp;
            WebAppHandler wah = WebAppHandler.buildHandler(webApp);
            WebAppMeta meta = WebAppRegistry.getMeta(type);
            if (!meta.isCustomWebApp()) {
                this.licenseEnforcementService.checkWebappsAllowed(authCtx);
            }
            if (meta == ShinyWebAppMeta.META) {
                authCtx.failIfNoSafeCode("Write R code");
            } else if (meta == BokehWebAppMeta.META || meta == DashWebAppMeta.META) {
                authCtx.failIfNoSafeCode("Write Python code");
            } else if (meta instanceof CodeStudioWebAppMeta) {
                authCtx.failIfNoSafeCode("Code Studio");
            } else if (webApp.params.isBackendEnabled()) {
                authCtx.failIfNoSafeCode("Write Python code");
            }
            wah.writeCodeFiles();
            precomputedFingerprint = this.trustedCodeService.precomputeFingerprintIfPossiblyNeeded_T(authCtx, webApp.projectKey, webApp.id);
            t.commitV("Created web app %s (%s.%s)", new Object[]{webApp.name, webApp.projectKey, webApp.id});
            this.auditTrailService.generic("webapp-create").with("projectKey", projectKey).with("webAppId", webApp.id).emit();
        }
        t = this.transactionService.beginRead();
        try {
            webApp = this.webAppsService.getOrNull(webApp.projectKey, webApp.id);
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
        WebAppsService.WebAppSaveResponse ret = creation.resp;
        JsonObject userVariables = this.variablesService.getForProject(webApp.projectKey).getAllVariablesTyped();
        if (webApp.isVirtual) {
            ret.backendState = this.backendsManager.onSave_NT(authCtx, webApp, userVariables, false, true);
        }
        this.trustedCodeService.autoTrustIfNeededWebApp_NT(authCtx, webApp.projectKey, webApp.id, precomputedFingerprint);
        WebAppsController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditedCall(value={"msgType", "webapp-trust", "projectKey", "${projectKey}", "webAppId", "${webAppId}", "trustForEverybody", "${trustForEverybody}"})
    @RequestMapping(value={"/api/webapps/trust"}, method={RequestMethod.POST})
    @ResponseBody
    public TrustedCodeService.TrustedCodeCheckReport trust(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String webAppId, @RequestParam boolean trustForEverybody, @RequestParam String fingerprint) throws Exception {
        DSSAuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = (DSSAuthCtx)this.authService.getMandatoryUser(req);
        }
        this.trustedCodeService.checkCanTrust_NT(authCtx, projectKey, webAppId, trustForEverybody, fingerprint);
        return this.trustedCodeService.trustWebApp_NT(authCtx, projectKey, webAppId, trustForEverybody, fingerprint);
    }

    @AuditInline
    @RequestMapping(value={"/api/webapps/save"})
    public void save(HttpServletRequest req, HttpServletResponse resp, @RequestParam String webAppData, @RequestParam(required=false) String commitMessage, @RequestParam(required=false, defaultValue="false") boolean forceRestartBackend) throws Exception {
        String precomputedFingerprint;
        WebAppsService.WebAppSaveResponse ret;
        AuthCtx authCtx;
        WebApp webApp = (WebApp)JSON.parse((String)webAppData, WebApp.class);
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPermAndCanCreateWebContent(authCtx, webApp.projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            WebAppMeta meta = WebAppRegistry.getMeta(webApp.type);
            if (!meta.isCustomWebApp()) {
                this.licenseEnforcementService.checkWebappsAllowed(authCtx);
            }
            if (meta == ShinyWebAppMeta.META) {
                authCtx.failIfNoSafeCode("Write R code");
            } else if (meta == BokehWebAppMeta.META || meta == DashWebAppMeta.META || webApp.params.isBackendEnabled()) {
                authCtx.failIfNoSafeCode("Write Python code");
            }
            this.webAppsService.getMandatoryUnsafe(webApp.projectKey, webApp.id);
            ret = this.webAppsService.save(webApp, false);
            WebAppHandler wah = WebAppHandler.buildHandler(webApp);
            wah.writeCodeFiles();
            precomputedFingerprint = this.trustedCodeService.precomputeFingerprintIfPossiblyNeeded_T(authCtx, webApp.projectKey, webApp.id);
            webApp = this.webAppsService.getMandatoryUnsafe(webApp.projectKey, webApp.id);
            if (!ret.isVirtual) {
                if (StringUtils.isNotBlank((String)commitMessage)) {
                    t.commit(commitMessage, 0L, MinimalRWTransaction.TransactionGitCommitPolicy.IF_AUTO);
                } else {
                    t.commit(String.format("Saved web app %s (%s.%s)", webApp.name, webApp.projectKey, webApp.id), 0L, MinimalRWTransaction.TransactionGitCommitPolicy.IF_AUTO);
                }
            }
            this.auditTrailService.generic("webapp-save").with("projectKey", webApp.projectKey).with("webAppId", webApp.id).emit();
        }
        JsonObject userVariables = this.variablesService.getForProject(webApp.projectKey).getAllVariablesTyped();
        ret.backendState = this.backendsManager.onSave_NT(authCtx, webApp, userVariables, forceRestartBackend, true);
        ret.trustedCodeReport = this.trustedCodeService.autoTrustIfNeededWebApp_NT(authCtx, webApp.projectKey, webApp.id, precomputedFingerprint);
        WebAppsController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditInline
    @RequestMapping(value={"/api/webapps/save-metadata"})
    public void saveMetadata(HttpServletRequest req, HttpServletResponse resp, @RequestParam String webAppData) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            WebApp webApp = (WebApp)JSON.parse((String)webAppData, WebApp.class);
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPermAndCanCreateWebContent(user, webApp.projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            this.webAppsService.getMandatoryUnsafe(webApp.projectKey, webApp.id);
            this.webAppsService.save(webApp, false);
            t.commit(String.format("Saved web app %s (%s.%s)", webApp.name, webApp.projectKey, webApp.id), 0L, MinimalRWTransaction.TransactionGitCommitPolicy.IF_AUTO);
            this.auditTrailService.generic("webapp-save").with("projectKey", webApp.projectKey).with("webAppId", webApp.id).emit();
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/webapps/copy"})
    public void copy(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String webAppId, @RequestParam String newWebAppName) throws Exception {
        WebApp webApp;
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPermAndCanCreateWebContent(user, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            WebApp originalWebApp = this.webAppsService.getMandatory(projectKey, webAppId);
            webApp = this.webAppsService.copy(projectKey, webAppId, newWebAppName);
            t.commitV("Copied web app %s into %s (%s.%s into %s.%s)", new Object[]{originalWebApp.name, newWebAppName, projectKey, webAppId, projectKey, webApp.id});
            this.auditTrailService.generic("webapp-create").with("projectKey", projectKey).with("webAppId", webApp.id).with("fromProjectKey", projectKey).with("fromWebAppId", webAppId).emit();
        }
        WebAppsController.writeJSON((HttpServletResponse)resp, (Object)webApp);
    }

    @AuditedCall(value={"msgType", "webapp-view", "projectKey", "${projectKey}", "webAppId", "${webAppId}"})
    @RequestMapping(value={"/api/webapps/get-backend-state"})
    public void getBackendState(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String webAppId) throws Exception {
        WebApp webApp;
        boolean keepFutureIdInResponse = false;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx u = this.authService.getMandatoryUser(req);
            if (this.permissionsService.hasProjectPrivilege(u, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF)) {
                keepFutureIdInResponse = true;
            } else {
                this.projectsService.checkPerm(u, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            }
            webApp = this.webAppsService.getMandatoryUnsafe_noCode(projectKey, webAppId);
        }
        WebAppsController.writeJSON((HttpServletResponse)resp, (Object)this.webAppsService.getBackendState(webApp, keepFutureIdInResponse));
    }

    private void checkViewPermission(@Nullable AuthCtx authCtx, SmartObjectRef ref, String contextProjectKey, WebApp webApp) throws IOException, DKUSecurityException {
        WebAppSecurityInfo secInfo = WebAppSecurityInfo.create(webApp);
        if (!secInfo.forceAuthentication) {
            return;
        }
        if (authCtx == null) {
            throw new NotAuthenticatedException("not-authenticated", "This webapp requires authentication on DSS first");
        }
        this.projectsService.failIfNoDashboardReadPermission(authCtx, ref, contextProjectKey);
    }

    @AuditedCall(value={"msgType", "trusted-code-report-get", "projectKey", "${projectKey}", "webAppId", "${webAppId}"})
    @RequestMapping(value={"/api/webapps/get-trusted-code-report"})
    @ResponseBody
    public TrustedCodeService.TrustedCodeCheckReport getTrustedCodeReport(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String webAppId) throws Exception {
        WebApp webApp;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            SmartObjectRef ref = SmartObjectRef.fromSmartName(ITaggingService.TaggableType.WEB_APP, webAppId);
            String resolvedWebAppId = ref.objectId;
            String resolvedProjectKey = ref.getProjectKey(projectKey);
            webApp = this.webAppsService.getMandatoryUnsafe(resolvedProjectKey, resolvedWebAppId);
            this.checkViewPermission(authCtx, ref, projectKey, webApp);
        }
        return this.trustedCodeService.computeWebAppTrustedCodeReport_NT(authCtx, webApp.projectKey, webApp.id);
    }

    @AuditedCall(value={"msgType", "webapp-view", "projectKey", "${projectKey}", "webAppId", "${webAppId}"})
    @RequestMapping(value={"/api/webapps/get-backend-url"})
    public void getBackendUrl(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String webAppId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getUser(req);
            SmartObjectRef ref = SmartObjectRef.fromSmartName(ITaggingService.TaggableType.WEB_APP, webAppId);
            String resolvedWebAppId = ref.objectId;
            String resolvedProjectKey = ref.getProjectKey(projectKey);
            logger.info((Object)("Getting webapp url for " + resolvedProjectKey + "." + resolvedWebAppId));
            WebApp webApp = this.webAppsService.getMandatoryUnsafe(resolvedProjectKey, resolvedWebAppId);
            this.checkViewPermission(authCtx, ref, projectKey, webApp);
            BackendUrl ret = new BackendUrl();
            WebAppBackend backend = this.backendsManager.getBackendOrNull(resolvedProjectKey, resolvedWebAppId);
            if (backend != null) {
                ret.running = true;
                ret.location = backend.getBackendUrl();
            }
            WebAppsController.writeJSON((HttpServletResponse)resp, (Object)ret);
        }
    }

    @AuditedCall(value={"msgType", "webapp-protected-view"})
    @RequestMapping(value={"/api/webapps/check-access/{projectKey}/{webAppId}/"})
    public void checkAccess(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String webAppId) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            resp.setHeader("X-DKU-studioUrl", RemoteRunNetworkingUtils.getStudioExternalURL());
            authCtx = this.authService.getUserNoXSRF(req);
            AnyLoc webAppLoc = AnyLoc.resolveSmart(projectKey, webAppId);
            WebApp webApp = this.webAppsService.getOrNull(webAppLoc.getProjectKey(), webAppLoc.getId());
            if (authCtx == null) {
                WebAppMeta meta = WebAppRegistry.getMeta(webApp.type);
                boolean backendAPIAccessEnabled = false;
                if (meta instanceof CustomWebAppMeta) {
                    CustomWebAppDesc desc = ((CustomWebAppMeta)meta).loaded.desc;
                    if ("STANDARD".equals(desc.baseType)) {
                        backendAPIAccessEnabled = desc.backendAPIAccessEnabled != null && desc.backendAPIAccessEnabled != false;
                    } else if ("DASH".equals(desc.baseType)) {
                        backendAPIAccessEnabled = desc.backendAPIAccessEnabled != null && desc.backendAPIAccessEnabled != false;
                    }
                } else if (webApp.params instanceof StandardWebAppMeta.StandardWebAppParams) {
                    backendAPIAccessEnabled = ((StandardWebAppMeta.StandardWebAppParams)webApp.params).backendAPIAccessEnabled;
                } else if (webApp.params instanceof DashWebAppMeta.DashWebAppParams) {
                    backendAPIAccessEnabled = ((DashWebAppMeta.DashWebAppParams)webApp.params).backendAPIAccessEnabled;
                } else if (webApp.params instanceof CodeStudioWebAppMeta.CodeStudioWebAppParams) {
                    backendAPIAccessEnabled = ((CodeStudioWebAppMeta.CodeStudioWebAppParams)webApp.params).backendAPIAccessEnabled;
                }
                if (backendAPIAccessEnabled) {
                    try {
                        authCtx = this.metaAuthService.getTicketOrKey(req);
                    }
                    catch (NotAuthenticatedException notAuthenticatedException) {
                        // empty catch block
                    }
                }
            }
            WebAppSecurityInfo securityInfo = WebAppSecurityInfo.create(webApp);
            if (securityInfo.forceAuthentication) {
                if (authCtx == null) {
                    resp.setHeader("X-DKU-accessForbiddenReason", "The webapp backend cannot be accessed without being logged into <a href=\"" + RemoteRunNetworkingUtils.getStudioExternalURL() + "\">DSS</a>.");
                    throw new NotLoggedInException("Not logged in DSS");
                }
                if (!this.projectsService.hasDashboardReadPermission(authCtx, SmartObjectRef.fromSmartName(ITaggingService.TaggableType.WEB_APP, webAppId), projectKey)) {
                    resp.setHeader("X-DKU-accessForbiddenReason", "The webapp backend cannot be accessed with the current credentials. Use a different login <a href=\"" + RemoteRunNetworkingUtils.getStudioExternalURL() + "\">DSS</a>");
                    throw new UnauthorizedException("Access to project rejected", "webapp-access-failed");
                }
            }
        }
        TrustedCodeService.TrustedCodeCheckReport trustedCodeReport = this.trustedCodeService.computeWebAppTrustedCodeReport_NT(authCtx, projectKey, webAppId);
        if (!trustedCodeReport.canAccess) {
            resp.setHeader("X-DKU-accessForbiddenReason", "The webapp is not trusted. You need to trust this webapp in <a href=\"" + RemoteRunNetworkingUtils.getStudioExternalURL() + "\">DSS</a> before accessing it.");
            throw new UnauthorizedException("Webapp is not trusted", "webapp-access-failed");
        }
        logger.info((Object)("Accept for " + String.valueOf(authCtx == null ? "unauthenticated user" : authCtx) + " on " + projectKey + "." + webAppId));
        resp.setStatus(200);
    }

    @AuditedCall(value={"msgType", "webapp-backend-restart", "projectKey", "${projectKey}", "webAppId", "${webAppId}"})
    @RequestMapping(value={"/api/webapps/restart-backend"})
    public void restartBackend(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String webAppId) throws Exception {
        WebApp webApp;
        AuthCtx authCtx = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            webApp = this.webAppsService.getMandatoryUnsafe(projectKey, webAppId);
        }
        FutureResponse<WebAppBackendInstance.BackendState> ret = this.webAppsService.restartBackend_NT(authCtx, webApp);
        WebAppsController.writeJSON((HttpServletResponse)resp, ret);
    }

    @AuditedCall(value={"msgType", "webapp-backend-stop", "projectKey", "${projectKey}", "webAppId", "${webAppId}"})
    @RequestMapping(value={"/api/webapps/stop-backend"})
    public void stopBackend(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String webAppId) throws Exception {
        WebApp webApp;
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            webApp = this.webAppsService.getMandatoryUnsafe_noCode(projectKey, webAppId);
        }
        this.webAppsService.stopBackend(webApp);
    }

    /*
     * Unable to fully structure code
     */
    @AuditedCall(value={"msgType", "webapp-view", "projectKey", "${projectKey}", "webAppId", "${webAppId}"})
    @RequestMapping(value={"/api/webapps/view"})
    public void view(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String webAppId) throws Exception {
        try {
            t = this.transactionService.beginRead();
            try {
                authCtx = this.authService.getUserNoXSRF(req);
                ref = SmartObjectRef.fromSmartName(ITaggingService.TaggableType.WEB_APP, webAppId);
                webApp = this.webAppsService.getMandatoryUnsafe(ref.getProjectKey(projectKey), ref.objectId);
                this.checkViewPermission(authCtx, ref, projectKey, webApp);
            }
            finally {
                if (t != null) {
                    t.close();
                }
            }
        }
        catch (NotAuthenticatedException ex) {
            redirectTo = req.getHeader("X-DKU-Redirect-To");
            if (StringUtils.isBlank((String)redirectTo)) {
                redirectTo = "/webapps/" + projectKey + "/" + webAppId + "/";
            }
            resp.sendRedirect("/?redirectTo=" + URLEncoder.encode((String)redirectTo, "UTF-8"));
            return;
        }
        trustedCodeReport = this.trustedCodeService.computeWebAppTrustedCodeReport_NT(authCtx, webApp.projectKey, webApp.id);
        if (trustedCodeReport.canAccess) {
            t = this.transactionService.beginRead();
            try {
                wah = WebAppHandler.buildHandler(webApp);
                html = wah.getHtml(0);
                if (html != null) ** GOTO lbl34
                html = "The web app has not been published yet.";
            }
            finally {
                if (t != null) {
                    t.close();
                }
            }
        } else {
            html = "Webapp is not trusted";
        }
lbl34:
        // 3 sources

        WebAppsController.writeHTML((HttpServletResponse)resp, (String)html);
    }

    @AuditedCall(value={"msgType", "admin-webapps-list-all-states"})
    @RequestMapping(value={"/api/webapps/list-all-backends-states"})
    public void listAllBackendStates(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getUser(req);
            this.authService.failIfNotAdmin(user);
        }
        WebAppsController.writeJSON((HttpServletResponse)resp, this.webAppsService.listAllBackendStates_NT());
    }

    @AuditedCall(value={"msgType", "webapp-start-tensorboard", "projectKey", "${projectKey}", "analysisId", "${analysisId}", "taskId", "${taskId}", "sessionId", "${sessionId}"})
    @RequestMapping(value={"/api/webapps/webapp-start-tensorboard"})
    public void startTensorboardIfNotRunning(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String analysisId, @RequestParam String taskId, @RequestParam String sessionId) throws Exception {
        AuthCtx user;
        MLTaskLoc loc = new MLTaskLoc(projectKey, analysisId, taskId);
        boolean keepFutureIdInResponse = false;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            if (this.permissionsService.hasProjectPrivilege(user, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF)) {
                keepFutureIdInResponse = true;
            } else {
                this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            }
        }
        FutureResponse<WebAppBackendInstance.BackendState> result = this.tensorBoardService.startTensorboardIfNotRunning(loc, sessionId, user, keepFutureIdInResponse);
        if (result != null) {
            WebAppsController.writeJSON((HttpServletResponse)resp, result);
        } else {
            WebAppsController.writeJSON((HttpServletResponse)resp, (Object)new FutureResponse());
        }
    }

    @AuditedCall(value={"msgType", "webapp-convert-to-custom", "${projectKey}", "projectKey", "${webappId}", "webappId", "${targetPluginId}", "targetPluginId", "${newWebAppType}", "newWebAppType"})
    @RequestMapping(value={"/api/webapps/convert-to-custom"})
    public void convertToCustom(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String webappId, @RequestParam String targetPluginId, @RequestParam String newWebAppType, @RequestParam String targetPluginMode) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkDevelopPluginPrivilege(authCtx);
        }
        DevPluginsService.TargetPluginMode mode = DevPluginsService.TargetPluginMode.valueOf(targetPluginMode);
        DevPluginsService.WebAppConversionResult ret = this.webAppsService.convertWebAppToCustom(projectKey, webappId, targetPluginId, mode, newWebAppType, authCtx);
        WebAppsController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditedCall(value={"msgType", "webapp-get-log", "projectKey", "${projectKey}", "webAppId", "${webAppId}"})
    @RequestMapping(value={"/api/webapps/backend-log"})
    public void getBackendLog(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String webAppId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPermNoXSRF(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        File logFolder = AbstractWebAppBackendRunner.getWebAppWorkingDir(projectKey, webAppId);
        File logFile = new File(logFolder, "backend.log");
        this.writeLog(resp, logFolder, logFile, "backend.log");
    }

    @AuditedCall(value={"msgType", "webapp-get-diagnostic", "projectKey", "${projectKey}", "webAppId", "${webAppId}"})
    @RequestMapping(value={"/api/webapps/backend-diagnosis"})
    public void getBackendDiagnostic(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String webAppId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPermNoXSRF(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        File runDir = AbstractWebAppBackendRunner.getWebAppWorkingDir(projectKey, webAppId);
        if (runDir.exists()) {
            resp.setContentType("application/zip");
            resp.setHeader("Content-Disposition", "attachment; filename=\"dss-webapp-diag-" + projectKey + "-" + webAppId + ".zip\"");
            resp.setStatus(200);
            try (BufferedOutputStream bos = new BufferedOutputStream((OutputStream)resp.getOutputStream());){
                ZipUnzipDir.zipDirectoryToStream(runDir, bos);
            }
        } else {
            resp.setStatus(404);
            resp.getWriter().write("run logs dir not found");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeLog(HttpServletResponse resp, File runDir, File logFile, String filename) throws IOException {
        block10: {
            if (DKUFileUtils.isWithin((File)runDir, (File)logFile) && logFile.isFile() && logFile.canRead()) {
                resp.setContentType("text/plain; charset=UTF-8");
                resp.setHeader("Content-Disposition", "inline; filename=\"" + filename + ".log\"");
                resp.setStatus(200);
                try (FileInputStream input = null;
                     BufferedOutputStream bos = new BufferedOutputStream((OutputStream)resp.getOutputStream());){
                    input = new FileInputStream(logFile);
                    IOUtils.copy((InputStream)input, (OutputStream)bos);
                    break block10;
                }
            }
            resp.setStatus(404);
            resp.getWriter().write("run log not found " + logFile.getAbsolutePath());
        }
    }

    @AuditedCall(value={"msgType", "webapp-skin", "projectKey", "${projectKey}", "objectId", "${objectId}", "objectType", "${objectType}"})
    @RequestMapping(value={"/api/webapps/get-or-create-plugin-skin"}, method={RequestMethod.POST})
    public void getOrCreatePluginSkin(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String webAppType, @RequestParam JsonObject webAppConfig, @RequestParam(required=false) String webAppId, @RequestParam(required=false) String contextualCodeEnv) throws Exception {
        WebAppsService.WebAppCreateResponse ret;
        AuthCtx authCtx;
        WebApp wa = null;
        boolean keepFutureIdInResponse = false;
        try (Transaction t = this.transactionService.beginRead();){
            this.checkNotEmpty(new String[]{projectKey});
            authCtx = this.authService.getMandatoryUser(req);
            if (this.permissionsService.hasProjectPrivilege(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF)) {
                keepFutureIdInResponse = true;
            } else {
                this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            }
            if (StringUtils.isNotBlank((String)contextualCodeEnv)) {
                this.codeEnvPermissionsService.failIfCodeEnvNotUsable(CodeEnvModel.EnvLang.PYTHON, contextualCodeEnv, authCtx);
            }
            if (StringUtils.isNotBlank((String)webAppId)) {
                wa = this.webAppsService.getOrNull(projectKey, webAppId);
            }
            if (wa == null) {
                wa = this.webAppsService.getReusableOrNull(authCtx, projectKey, webAppType, webAppConfig);
            }
        }
        webAppConfig.addProperty("$isSkin", Boolean.valueOf(true));
        WebAppBackendInstance.BackendState backendState = wa != null ? this.backendsManager.getState(wa, keepFutureIdInResponse) : null;
        boolean backendDied = wa != null && wa.params.isBackendEnabled() && (backendState == null || backendState.futureInfo != null && !backendState.futureInfo.alive);
        logger.info((Object)("Get or create plugin skin webAppType=" + webAppType + " webAppId=" + webAppId + " webApp=" + (wa != null ? wa.type : "") + " config=" + JSON.pretty((Object)webAppConfig) + " backendDied=" + backendDied));
        if (wa != null && StringUtils.equals((String)wa.type, (String)webAppType) && !backendDied) {
            logger.info((Object)"Webapp is still running, use it");
            ret = new WebAppsService.WebAppCreateResponse();
            ret.resp = new WebAppsService.WebAppSaveResponse();
            ret.resp.webAppId = wa.id;
            if (backendState != null) {
                ret.resp.backendState = new FutureResponse();
                ret.resp.backendState.hasResult = true;
                ret.resp.backendState.result = backendState;
            }
            ret.webapp = wa;
            wa.config = webAppConfig;
        } else {
            try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
                webAppId = SecretKeyGenerator.generateSmall();
                WebAppMeta meta = WebAppRegistry.getMeta(webAppType);
                ret = this.webAppsService.createTimeoutableVirtual(t.getUser(), webAppId, projectKey, "Plugin skin", meta.getType(), null, null, webAppConfig, contextualCodeEnv);
                if (StringUtils.isNotBlank((String)ret.webapp.apiKey)) {
                    PublicAPIKey keyObj = this.publicAPIKeysService.getKey(this.passwordEncryptionService.decryptIfEncrypted(ret.webapp.apiKey));
                    if (!(keyObj instanceof ProjectScopePublicAPIKey)) {
                        throw new IllegalArgumentException("Bad API key");
                    }
                    ProjectScopePublicAPIKey pkeyObj = (ProjectScopePublicAPIKey)keyObj;
                    pkeyObj.projectPrivileges.readProjectContent = true;
                    this.publicAPIKeysService.updateProjectAPIKey(pkeyObj);
                }
                WebAppHandler wah = WebAppHandler.buildHandler(ret.webapp);
                wah.writeCodeFiles();
                t.commit("Create webapp skin " + webAppId);
            }
            WebApp created = (WebApp)JSON.deepCopy((Object)ret.webapp);
            WebAppHandler.buildHandler(created).readCodeFiles();
            JsonObject userVariables = this.variablesService.getForProject(projectKey).getAllVariablesTyped();
            ret.resp.backendState = this.backendsManager.onSave_NT(authCtx, created, userVariables, false, keepFutureIdInResponse);
        }
        WebAppsController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    public static class BackendUrl {
        public boolean running;
        public String location;
    }
}

