/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.recipes;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.MultiEngineRecipeRunner;
import com.dataiku.dip.dataflow.exec.filter.FilterDesc;
import com.dataiku.dip.dataflow.exec.filter.FilterDescUtils;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.DatasetSelection;
import com.dataiku.dip.datasets.DatasetUtils;
import com.dataiku.dip.datasets.SamplingParam;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.recipes.visualsql.VisualSQLRecipeEngineParams;
import com.dataiku.dip.server.recipes.SamplingQueryGenerator;
import com.dataiku.dip.sql.H2SQLDialect;
import com.dataiku.dip.sql.H2V2SQLDialect;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import java.io.IOException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SamplingRecipeService {
    @Autowired
    protected DatasetsDAO datasetsDAO;
    @Autowired
    private VariablesService variablesService;
    static DKULogger logger = DKULogger.getLogger((String)"dku.recipes.sampling");

    public FilterDesc loadParams(String payload, SerializedRecipe sr) {
        FilterDesc params = (FilterDesc)JSON.parse((String)payload, FilterDesc.class);
        params = this.expandParams(params, sr.projectKey);
        return params;
    }

    private FilterDesc expandParams(FilterDesc params, String projectKey) {
        VariablesContext vc = this.variablesService.getForProject(projectKey);
        FilterDescUtils.expand(params, vc);
        return params;
    }

    public String generateSQL(JobActivity activity, SQLDialect dialect, DatasetSelection selection, FilterDesc filter, VisualSQLRecipeEngineParams params) throws IOException {
        Partition part;
        Dataset outputDS;
        List<Partition> parts;
        Dataset source = activity.getSubgraph().getSingleSourceDataset().getMandatory(this.datasetsDAO);
        Partition targetPartition = null;
        List<Partition> sourcePartitions = null;
        PartitioningScheme sourcePartitionScheme = null;
        PartitioningScheme targetPartitionScheme = null;
        if (MultiEngineRecipeRunner.shouldSpecifySourcePartitionInWhereClause(dialect, params) && (parts = activity.getSubgraph().getSourcePartitions(activity.getSubgraph().getSingleSourceDataset())) != null && parts.size() > 0 && !parts.get(0).isAll() && !parts.get(0).isNP() && source.getPartitioningSchema().isPartitioned()) {
            sourcePartitions = parts;
            sourcePartitionScheme = source.getPartitioningSchema();
        }
        if (!DatasetInspector.canHDFS(outputDS = activity.getSubgraph().getSingleTargetDataset().getMandatory(this.datasetsDAO)) && (part = activity.getSubgraph().getTargetPartition(activity.getSubgraph().getSingleTargetDataset())) != null && !part.isNP() && !part.isAll() && outputDS.getPartitioningSchema().isPartitioned()) {
            targetPartition = part;
            targetPartitionScheme = outputDS.getPartitioningSchema();
        }
        return this.generateSQL(dialect, selection, filter, source, outputDS, sourcePartitionScheme, sourcePartitions, targetPartitionScheme, targetPartition, params);
    }

    public String generateSQL(JobActivity activity, SQLDialect dialect, VisualSQLRecipeEngineParams params) throws IOException {
        return this.generateSQL(activity, dialect, null, null, params);
    }

    public String generateSQLIgnorePartitions(SQLDialect dialect, DatasetSelection selection, FilterDesc expandedFilter, Dataset source, VisualSQLRecipeEngineParams params) throws IOException {
        return this.generateSQL(dialect, selection, expandedFilter, source, null, null, null, null, null, params);
    }

    private String generateSQL(SQLDialect dialect, DatasetSelection selection, FilterDesc filter, Dataset source, Dataset outputDataset, PartitioningScheme sourcePartitionScheme, List<Partition> sourcePartitions, PartitioningScheme targetPartitionScheme, Partition targetPartition, VisualSQLRecipeEngineParams params) throws IOException {
        SQLUtils.SQLTable table = dialect instanceof H2SQLDialect && !(dialect instanceof H2V2SQLDialect) ? new SQLUtils.SQLTable(null, null, source.getFullName(), false) : DatasetUtils.getResolvedTableWithSparkSQLFallback(source, dialect, params);
        SamplingQueryGenerator sqlGenerator = new SamplingQueryGenerator(filter, source, outputDataset, table, selection);
        sqlGenerator.setPartitioning(sourcePartitionScheme, sourcePartitions, targetPartitionScheme, targetPartition);
        String generatedQuery = sqlGenerator.generateSQL(dialect);
        if (selection != null) {
            if (selection.samplingMethod == SamplingParam.SamplingMethod.FULL || this.canSampleInDatabase(selection, dialect)) {
                return generatedQuery;
            }
            if (selection.samplingMethod == SamplingParam.SamplingMethod.HEAD_SEQUENTIAL) {
                return dialect.getLimitedQuery(generatedQuery, selection.maxRecords);
            }
            throw ErrorContext.iae((String)"Cannot translate sampling to SQL");
        }
        return generatedQuery;
    }

    public boolean canSampleInDatabase(DatasetSelection selection, SQLDialect dialect) {
        return dialect != null && SamplingQueryGenerator.handlesSamplingMethod(selection, dialect);
    }
}

