/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.security.DefaultRedirectStrategyWithIPBlacklist;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.PerfUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.dataiku.dss.shadelib.org.apache.http.NameValuePair;
import com.dataiku.dss.shadelib.org.apache.http.client.RedirectStrategy;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.CloseableHttpResponse;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpGet;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpUriRequest;
import com.dataiku.dss.shadelib.org.apache.http.client.utils.URLEncodedUtils;
import com.dataiku.dss.shadelib.org.apache.http.impl.client.CloseableHttpClient;
import com.dataiku.dss.shadelib.org.apache.http.impl.client.HttpClientBuilder;
import com.dataiku.dss.shadelib.org.apache.http.message.BasicNameValuePair;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class RandomPhotosService {
    private final int CACHE_REFRESH_PERIOD_IN_HOURS = ApplicationConfigurator.getProperty((String)"dku.randomphotos.refreshPeriodInHours", (int)24);
    private final int CACHE_SIZE = ApplicationConfigurator.getProperty((String)"dku.randomphotos.size", (int)5);
    private final String PEXELS_API_KEY = ApplicationConfigurator.getProperty((String)"dku.randomphotos.pexelsApiKey", (String)"RyqkFBBRzt7x3Qj4LsajTDOta8oB6P61slTCUi8fV4obQpSyWG9PQQNY");
    private final File cacheDirectory = ApplicationConfigurator.getFile((String[])new String[]{"caches", "random-photos"});
    private final Random random = new Random();
    private static final int PHOTOS_PER_PAGE = 50;
    private static final long ONE_HOUR = 3600000L;
    private static final String PREFIX_INDEX = "index-";
    private static final String TYPE_TMP = "tmp";
    private static final String TYPE_IMG = "img";
    private static final String EXT_JSON = ".json";
    private static final String EXT_JPEG = ".jpeg";
    private static final String EXT_PNG = ".png";
    private static final Logger logger = Logger.getLogger((String)"dip.randomphotos");

    public File getRandomPhoto(String query, int width, int height) throws IOException {
        if (!query.matches("\\w+")) {
            throw new IllegalArgumentException("Invalid query. It must only include alphanumeric characters.");
        }
        if (width < 8 || width > 8192) {
            throw new IllegalArgumentException("Width must be between 8 and 8192 pixels");
        }
        if (height < 8 || height > 8192) {
            throw new IllegalArgumentException("Height must be between 8 and 8192 pixels");
        }
        long now = System.currentTimeMillis();
        long maxTimestamp = -1L;
        int lastPosition = -1;
        ArrayList<File> validFiles = new ArrayList<File>();
        File[] imageFiles = this.getDirectory(query).listFiles((dir, name) -> name.endsWith(EXT_PNG) || name.endsWith(EXT_JPEG));
        if (imageFiles != null) {
            for (File imageFile : imageFiles) {
                String name2 = imageFile.getName();
                String[] parts = name2.split("[-.]");
                if (parts.length != 6) continue;
                String type = parts[0];
                int imgWidth = Integer.parseInt(parts[1]);
                int imgHeight = Integer.parseInt(parts[2]);
                long timestamp = Long.parseLong(parts[3]);
                int position = Integer.parseInt(parts[4]);
                if (lastPosition == -1 || timestamp > maxTimestamp) {
                    lastPosition = position;
                    maxTimestamp = timestamp;
                }
                if (now - timestamp > (long)this.CACHE_REFRESH_PERIOD_IN_HOURS * 3600000L) {
                    RandomPhotosService.softDelete(imageFile);
                    continue;
                }
                if (!TYPE_IMG.equals(type) || imageFile.length() <= 0L || imgWidth != width || imgHeight != height) continue;
                validFiles.add(imageFile);
            }
        }
        if (validFiles.size() >= this.CACHE_SIZE) {
            return (File)validFiles.get(this.random.nextInt(validFiles.size()));
        }
        int nextPosition = lastPosition + 1;
        File randomPhoto = null;
        try {
            randomPhoto = this.getPexelsPhoto(query, width, height, nextPosition);
        }
        catch (IOException e) {
            this.createDummyFile(query, width, height, nextPosition);
        }
        if (randomPhoto == null && !validFiles.isEmpty()) {
            randomPhoto = (File)validFiles.get(this.random.nextInt(validFiles.size()));
        }
        return randomPhoto;
    }

    private File getPexelsPhoto(String query, int width, int height, int position) throws IOException {
        String nextPhotoUrl;
        int page = position / 50;
        int index = position % 50;
        ProxySettings proxySettings = ApplicationConfigurator.getProxySettings();
        CloseableHttpClient httpClient = HttpClientBuilder.create().addInterceptorFirst(PerfUtils.MARK_HTTP_REQUEST_INTERCEPTOR).setRedirectStrategy((RedirectStrategy)new DefaultRedirectStrategyWithIPBlacklist(proxySettings)).build();
        try {
            nextPhotoUrl = this.getPexelsPhotoUrl(httpClient, query, width, height, page, index);
            if (nextPhotoUrl == null) {
                if (position == 0) {
                    throw new IllegalArgumentException("No photo found for query " + query);
                }
                position = 0;
                nextPhotoUrl = this.getPexelsPhotoUrl(httpClient, query, width, height, 0, 0);
                if (nextPhotoUrl == null) {
                    throw new IllegalArgumentException("No photo found for query " + query);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"Unable to get next photo URL from Pexels", (Throwable)e);
            return null;
        }
        try (CloseableHttpResponse imageResponse = httpClient.execute((HttpUriRequest)new HttpGet(nextPhotoUrl));){
            int statusCode = imageResponse.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                throw new IOException("Unable to fetch image from Pexels. Error: " + statusCode + ", Reason: " + imageResponse.getStatusLine().getReasonPhrase());
            }
            String contentType = imageResponse.getEntity().getContentType().getValue();
            File file = this.writeFile(imageResponse.getEntity().getContent(), query, width, height, position, contentType);
            return file;
        }
    }

    private String getPexelsPhotoUrl(CloseableHttpClient httpClient, String query, int width, int height, int page, int index) throws IOException {
        PexelsSearchResults searchResults;
        File indexFile = this.getFile(query, PREFIX_INDEX + page + EXT_JSON);
        if (indexFile.exists()) {
            searchResults = (PexelsSearchResults)JSON.parseFile((File)indexFile, PexelsSearchResults.class);
        } else {
            searchResults = this.searchPexelsPhotos(httpClient, query, "landscape", page, 50);
            DKUFileUtils.mkdirsParent((File)indexFile);
            JSON.prettyToFile((Object)searchResults, (File)indexFile);
            File[] files = this.getDirectory(query).listFiles((dir, name) -> name.startsWith(PREFIX_INDEX) && name.endsWith(EXT_JSON) && !name.equals(indexFile.getName()));
            if (files != null) {
                Arrays.stream(files).forEach(RandomPhotosService::softDelete);
            }
        }
        if (index >= searchResults.photos.size()) {
            return null;
        }
        return searchResults.photos.get((int)index).src.original + "?fit=crop&w=" + width + "&h=" + height;
    }

    private File writeFile(InputStream inputStream, String query, int width, int height, int position, String contentType) throws IOException {
        String ext = contentType.startsWith("image/png") ? EXT_PNG : EXT_JPEG;
        String suffix = "-" + width + "-" + height + "-" + System.currentTimeMillis() + "-" + position + ext;
        File tmpFile = this.getFile(query, TYPE_TMP + suffix);
        DKUFileUtils.mkdirsParent((File)tmpFile);
        try (FileOutputStream outputStream = new FileOutputStream(tmpFile);){
            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
        File file = this.getFile(query, TYPE_IMG + suffix);
        if (!tmpFile.renameTo(file)) {
            logger.warn((Object)("Unable to rename file " + tmpFile.getAbsolutePath() + " to " + file.getName()));
            return tmpFile;
        }
        return file;
    }

    private void createDummyFile(String query, int width, int height, int position) {
        try {
            File dummyFile = this.getFile(query, "tmp-" + width + "-" + height + "-" + System.currentTimeMillis() + "-" + position + EXT_JPEG);
            if (!dummyFile.createNewFile()) {
                logger.error((Object)("Unable to create dummy file: " + dummyFile.getAbsolutePath()));
            }
        }
        catch (Exception inner) {
            logger.error((Object)"Unable to create dummy file", (Throwable)inner);
        }
    }

    private File getDirectory(String query) {
        return DKUFileUtils.getWithin((File)this.cacheDirectory, (String[])new String[]{query});
    }

    private File getFile(String query, String filename) {
        return DKUFileUtils.getWithin((File)this.cacheDirectory, (String[])new String[]{query, filename});
    }

    private PexelsSearchResults searchPexelsPhotos(CloseableHttpClient httpClient, String query, String orientation, int page, int per_page) throws IOException {
        List<NameValuePair> parameters = Arrays.asList(new BasicNameValuePair("query", query), new BasicNameValuePair("orientation", orientation), new BasicNameValuePair("locale", "en-US"), new BasicNameValuePair("per_page", String.valueOf(per_page)), new BasicNameValuePair("page", String.valueOf(page)));
        HttpGet request = new HttpGet("https://api.pexels.com/v1/search?" + URLEncodedUtils.format(parameters, (Charset)StandardCharsets.UTF_8));
        request.addHeader("Authorization", this.PEXELS_API_KEY);
        CloseableHttpResponse restResponse = httpClient.execute((HttpUriRequest)request);
        int code = restResponse.getStatusLine().getStatusCode();
        if (code != 200) {
            throw new IOException("Unable to search image via Pexels. Error: " + code + ", Reason: " + restResponse.getStatusLine().getReasonPhrase());
        }
        return (PexelsSearchResults)JSON.parse((InputStream)restResponse.getEntity().getContent(), PexelsSearchResults.class);
    }

    private static void softDelete(File file) {
        if (!file.delete()) {
            logger.info((Object)("Unable to delete " + file.getAbsolutePath()));
        }
    }

    private static class PexelsSearchResults {
        List<PexelsPhoto> photos;
        int page;
        int per_page;
        int total_results;

        private PexelsSearchResults() {
        }

        private static class PexelsPhoto {
            long id;
            int width;
            int height;
            String url;
            String photographer;
            String photographer_url;
            String photographer_id;
            PexelsPhotoSrc src;

            private PexelsPhoto() {
            }

            private static class PexelsPhotoSrc {
                String original;
                String large;
                String medium;
                String small;
                String landscape;

                private PexelsPhotoSrc() {
                }
            }
        }
    }
}

