/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKULogger;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public enum ShortTaskExecutor {
    _INSTANCE;

    private DKULogger logger = DKULogger.getLogger(ShortTaskExecutor.class);
    private boolean loggingEnabled = false;
    private ScheduledExecutorService executor = Executors.newScheduledThreadPool(5, new ThreadFactoryBuilder().setNameFormat("ShortTaskExec-%d").build());

    public static <V> ScheduledFuture<V> schedule(Callable<V> callable, long l, TimeUnit timeUnit) {
        return _INSTANCE.scheduleImpl(callable, l, timeUnit);
    }

    public static <T> Future<T> submit(Callable<T> callable) {
        return _INSTANCE.submitImpl(callable);
    }

    public static <T extends AutoCloseable> CloseableLater<T> closeLater(T closeable) {
        return _INSTANCE.closeLaterImpl(closeable);
    }

    private <V> ScheduledFuture<V> scheduleImpl(Callable<V> callable, long l, TimeUnit timeUnit) {
        String id = this.generateId();
        if (this.loggingEnabled) {
            this.logger.debug((Object)("Scheduled a new task in " + l + " " + timeUnit.name() + " [" + id + "]"));
        }
        return this.executor.schedule(this.wrap(callable, id), l, timeUnit);
    }

    private String generateId() {
        return SecretKeyGenerator.generate((int)5);
    }

    private <T> Callable<T> wrap(final Callable<T> callable, final String id) {
        return new Callable<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T call() throws Exception {
                long start = System.currentTimeMillis();
                try {
                    if (ShortTaskExecutor.this.loggingEnabled) {
                        ShortTaskExecutor.this.logger.debug((Object)("Execute task [" + id + "]"));
                    }
                    Object v = callable.call();
                    return v;
                }
                finally {
                    long end = System.currentTimeMillis();
                    long duration = end - start;
                    if (ShortTaskExecutor.this.loggingEnabled) {
                        ShortTaskExecutor.this.logger.debug((Object)("Executed task in " + duration + "ms [" + id + "]"));
                    }
                }
            }
        };
    }

    private <T> Future<T> submitImpl(Callable<T> callable) {
        String id = this.generateId();
        if (this.loggingEnabled) {
            this.logger.debug((Object)("Submitted a new task [" + id + "]"));
        }
        return this.executor.submit(this.wrap(callable, id));
    }

    private <T extends AutoCloseable> CloseableLater<T> closeLaterImpl(T closeable) {
        return new CloseableLater(this, closeable);
    }

    public static class CloseableLater<T extends AutoCloseable>
    implements AutoCloseable {
        private T closableObject;
        final /* synthetic */ ShortTaskExecutor this$0;

        public CloseableLater(T closeableObject) {
            this.this$0 = this$0;
            this.closableObject = closeableObject;
        }

        public T get() {
            return this.closableObject;
        }

        @Override
        public void close() {
            if (this.closableObject != null) {
                final T closableObjectCopy = this.closableObject;
                this.closableObject = null;
                ShortTaskExecutor.submit(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        try {
                            closableObjectCopy.close();
                        }
                        catch (Throwable t) {
                            CloseableLater.this.this$0.logger.info((Object)("Unable to close resource " + closableObjectCopy.getClass().getName() + " :"), t);
                            throw t;
                        }
                        return null;
                    }
                });
            }
        }
    }
}

