/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.filter;

import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.memimpl.MemRow;
import com.dataiku.dip.shaker.filter.DisplayFilterColumn;
import com.dataiku.dip.shaker.types.AnyTemporal;
import java.util.Objects;

public class DateRangeFilter
extends DisplayFilterColumn {
    private final Double minValue;
    private final Double maxValue;
    private final AnyTemporal anyTemporalType = new AnyTemporal();
    private final Boolean includeEmptyValues;

    public DateRangeFilter(String column, Double minValue, Double maxValue, Boolean includeEmptyValues) {
        this.column = column;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.includeEmptyValues = includeEmptyValues;
    }

    @Override
    protected boolean filterRow(MemRow row, Column cd) {
        String value = row.get(cd);
        long ts = this.anyTemporalType.msSinceEpoch(value);
        if (ts == Long.MAX_VALUE) {
            return Objects.requireNonNullElse(this.includeEmptyValues, false);
        }
        if (this.minValue != null && (double)ts < this.minValue) {
            return false;
        }
        return this.maxValue == null || !((double)ts > this.maxValue);
    }
}

