/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.transform;

import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalineage.DatasetPairLineage;
import com.dataiku.dip.datalineage.RecipeLineage;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.shaker.ProcessorWithRecordedReport;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.processors.Category;
import com.dataiku.dip.shaker.processors.ProcessorCapabilities;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.processors.ProcessorTag;
import com.dataiku.dip.shaker.processors.StaticColumnsCreatorAdapter;
import com.dataiku.dip.shaker.processors.StaticColumnsCreatorProcessor;
import com.dataiku.dip.shaker.server.ProcessorDesc;
import com.dataiku.dip.shaker.sql.ProcessorSQLTranslator;
import com.dataiku.dip.shaker.sql.SQLQueryWithSchema;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.util.ParamDesc;
import com.dataiku.dip.utils.Pair;
import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class ColumnsConcat {
    public static final ProcessorMeta<StaticColumnsCreatorAdapter<StreamImpl>, Parameter> META = new ProcessorMeta<StaticColumnsCreatorAdapter<StreamImpl>, Parameter>(){

        @Override
        public String getName() {
            return "ColumnsConcat";
        }

        @Override
        public String getDocPage() {
            return "columns-concat";
        }

        @Override
        public Category getCategory() {
            return Category.TRANSFORMATION;
        }

        @Override
        public Set<ProcessorTag> getTags() {
            return Sets.newHashSet((Object[])new ProcessorTag[]{ProcessorTag.MISC});
        }

        @Override
        public Class<Parameter> stepParamClass() {
            return Parameter.class;
        }

        @Override
        public String getHelp(String language) {
            return this.translate(language, "SHAKER.PROCESSOR.ColumnsConcat.HELP", "Concatenate values across columns using a delimiter string and produce a single output.\n# Example\nIf `col1=myval`, `col2=myother`, and the delimiter is `.` , the concatenated output is `myval.myother`.\n# Options\n**Columns to concatenate** : List the columns to concatenate.\n**Delimiter to use** : The delimiter separates values from each input column within the output.\n**Output column** : Column containing the concatenated values.");
        }

        @Override
        public ProcessorDesc describe(String language) {
            return ProcessorDesc.withGenericForm(this.getName(), this.translate(language, "SHAKER.PROCESSOR.ColumnsConcat.DESCRIPTION", 1.actionVerb("Concatenate") + " columns")).withParam(new ParamDesc("columns", "columns").withLabel(this.translate(language, "SHAKER.PROCESSOR.ColumnsConcat.DESCRIPTION.COLUMNS_TO_CONCATENATE", "Columns to concatenate")).withDefaultValue(new ArrayList()).withMandatory(true)).withMandSParam("join", this.translate(language, "SHAKER.PROCESSOR.ColumnsConcat.DESCRIPTION.JOIN", "Delimiter to use")).withMNESParam("outputColumn", this.translate(language, "SHAKER.PROCESSORS.DESCRIPTION.OUTPUT_COLUMN", "Output column"));
        }

        @Override
        public Object selfReport(Parameter p) {
            JsonObject out = new JsonObject();
            out.addProperty("join", p.join);
            out.addProperty("nbColumns", (Number)p.columns.size());
            return out;
        }

        @Override
        public ProcessorMeta.ProcessorCapabilitiesSummary getCapabilities(StepParams sp, ProcessorWithRecordedReport.ProcessorRecordedReport report, SQLDialect dialect) {
            return new ProcessorMeta.ProcessorCapabilitiesSummary().withCan(ProcessorCapabilities.SQL_TRANSLATABLE, ProcessorCapabilities.NATIVE_SPARK_IMPL, ProcessorCapabilities.STATIC_COLUMNS_CREATOR, ProcessorCapabilities.KNOWN_INPUTS, ProcessorCapabilities.KNOWN_OUTPUTS, ProcessorCapabilities.TYPE_FIXED_COLUMNS_CREATOR);
        }

        @Override
        public StaticColumnsCreatorAdapter<StreamImpl> build(Parameter parameter) {
            return new StaticColumnsCreatorAdapter<StreamImpl>(new StreamImpl(parameter));
        }

        @Override
        public StaticColumnsCreatorProcessor buildStaticColumnsCreator(StepParams params) {
            return new StreamImpl((Parameter)params);
        }

        @Override
        public ProcessorSQLTranslator getSQLTranslator(StepParams parameter, ProcessorWithRecordedReport.ProcessorRecordedReport report) {
            return new SQLTranslator((Parameter)parameter);
        }

        @Override
        public RecipeLineage getUpdatedRecipeLineage(ProcessorScriptStep pss, RecipeLineage previousRecipeLineage) {
            if (!(pss.params instanceof Parameter)) {
                throw new IllegalArgumentException("Unsupported param type: " + pss.params.getClass().getSimpleName());
            }
            Parameter concatParams = (Parameter)pss.params;
            RecipeLineage updatedRecipeLineage = new RecipeLineage();
            previousRecipeLineage.getDatasetPairLineages().forEach((datasetPair, previousDatasetPairLineage) -> {
                DatasetPairLineage updatedDatasetPairLineage = new DatasetPairLineage((DatasetPairLineage)previousDatasetPairLineage);
                if (!concatParams.columns.contains(concatParams.outputColumn)) {
                    updatedDatasetPairLineage.removeRelationsOnColumn(concatParams.outputColumn);
                }
                concatParams.columns.forEach(inputColumn -> updatedDatasetPairLineage.addFactorizedColumnRelations((String)inputColumn, concatParams.outputColumn));
                updatedRecipeLineage.setDatasetPairLineage((Pair<String, String>)datasetPair, updatedDatasetPairLineage);
            });
            return updatedRecipeLineage;
        }
    };

    static class StreamImpl
    implements StaticColumnsCreatorProcessor {
        private static final long serialVersionUID = 1L;
        private final Parameter parameter;

        StreamImpl(Parameter parameter) {
            this.parameter = parameter;
        }

        @Override
        public List<String> getRequiredInputs() {
            return this.parameter.columns;
        }

        @Override
        public List<SchemaColumn> getProducedOutputs() {
            ArrayList<SchemaColumn> ret = new ArrayList<SchemaColumn>();
            ret.add(new SchemaColumn(this.parameter.outputColumn, Type.STRING));
            return ret;
        }

        @Override
        public StaticColumnsCreatorProcessor.Output produceRow(StaticColumnsCreatorProcessor.Input input) {
            StaticColumnsCreatorProcessor.Output output = new StaticColumnsCreatorProcessor.Output();
            ArrayList<String> data = new ArrayList<String>();
            for (Object ival : input.values) {
                if (ival == null || ival.toString().isEmpty()) continue;
                data.add(ival.toString());
            }
            if (!data.isEmpty()) {
                output.values.add(StringUtils.join(data, (String)this.parameter.join));
            } else {
                output.values.add(null);
            }
            return output;
        }

        @Override
        public void init(Map<String, File> resources) {
        }
    }

    private static class SQLTranslator
    implements ProcessorSQLTranslator {
        private final Parameter parameter;

        private SQLTranslator(Parameter parameter) {
            this.parameter = parameter;
        }

        @Override
        public SQLQueryWithSchema translate(SQLQueryWithSchema chain) {
            boolean needsSubquery;
            boolean bl = needsSubquery = chain.isCreatedOrModifiedByCurrentQuery(this.parameter.outputColumn) || chain.isAnyCreatedOrModifiedByCurrentQuery(this.parameter.columns);
            if (needsSubquery) {
                chain = chain.makeSubquery();
            }
            ExpressionBuilder.ExpressionBuilderFactory ebf = new ExpressionBuilder.ExpressionBuilderFactory();
            String firstCol = this.parameter.columns.get(0);
            ArrayList<ExpressionBuilder> concatArgs = new ArrayList<ExpressionBuilder>();
            int outputColLength = 0;
            for (int i = 1; i < this.parameter.columns.size(); ++i) {
                if (this.parameter.join.length() > 0) {
                    concatArgs.add(ebf.cst(this.parameter.join));
                    outputColLength += this.parameter.join.length();
                }
                String name = this.parameter.columns.get(i);
                ExpressionBuilder col = chain.col(name);
                if (chain.getInputColumn(name).isPresent()) {
                    if (((SchemaColumn)chain.getInputColumn(name).get()).getType() != Type.STRING) {
                        col = col.castToString(100);
                        outputColLength += 100;
                    } else {
                        outputColLength += ((SchemaColumn)chain.getInputColumn((String)name).get()).maxLength;
                    }
                } else {
                    outputColLength += 200;
                }
                concatArgs.add(col);
            }
            outputColLength = Math.min(chain.getDialect().getDefaultVarcharLen(), outputColLength);
            ExpressionBuilder eb = chain.col(firstCol).concat(concatArgs.toArray(new Object[0]));
            chain.addLastOrReplaceColumn(null, eb, Type.STRING, this.parameter.outputColumn, outputColLength);
            return chain;
        }
    }

    public static class Parameter
    implements StepParams {
        private static final long serialVersionUID = -1L;
        public String join = "";
        public List<String> columns = new ArrayList<String>();
        public String outputColumn;

        public void validate() throws IllegalArgumentException {
        }
    }
}

