/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.sql;

import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ImpalaConnection;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.hive.HiveSchemaHandler;
import com.dataiku.dip.shaker.sql.AbstractSqlQueryWithSchemaBuilder;
import com.dataiku.dip.sql.ImpalaSQLDialect;
import com.dataiku.dip.sql.SQLDialect;
import java.io.IOException;
import java.sql.SQLException;

public class ImpalaSqlQueryWithSchemaBuilder
extends AbstractSqlQueryWithSchemaBuilder {
    public ImpalaSqlQueryWithSchemaBuilder(JobActivity activity) {
        super(activity);
    }

    @Override
    public SQLDialect computeDialect() {
        this.dialect = new ImpalaSQLDialect();
        return this.dialect;
    }

    @Override
    public AbstractSQLConnection getDSSConnection() throws IOException, SQLException, DKUSecurityException {
        if (DatasetInspector.isMetastoreAssociatedType(this.inputDataset)) {
            ImpalaConnection connection = new ImpalaConnection();
            connection.params = new ImpalaConnection.Params();
            connection.params.db = HiveSchemaHandler.getResolvedHiveTableRefFromDataset(this.inputDataset).getSchemaNullIfBlank();
            return connection;
        }
        return DatasetInspector.getDSSConnectionForSQLAbleDatasetOrHive(this.authCtxService.getAuthCtx(), this.inputDataset);
    }
}

