/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.types;

import com.dataiku.dip.shaker.types.AbstractGeometryMeaning;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.geotools.geojson.geom.GeometryJSON;
import org.geotools.geometry.jts.WKTReader2;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.io.ParseException;

public class GeometryMeaning
extends AbstractGeometryMeaning {
    private final WKTReader2 wkt4326;

    public GeometryMeaning() {
        GeometryFactory factory4326 = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), 4326);
        this.wkt4326 = new WKTReader2(factory4326);
    }

    private boolean looksGeometry(String val) {
        return this.couldBeWtk(val = val.trim()) || this.couldBeGeometry(val);
    }

    private boolean couldBeGeometry(String trimmedVal) {
        return trimmedVal.startsWith("{") && trimmedVal.contains("Point") || trimmedVal.contains("LineString") || trimmedVal.contains("MultiPoint") || trimmedVal.contains("MultiLineString") || trimmedVal.contains("Polygon") || trimmedVal.contains("MultiPolygon");
    }

    private boolean couldBeWtk(String trimmedVal) {
        return trimmedVal.startsWith("LINESTRING") && trimmedVal.endsWith(")") || trimmedVal.startsWith("POINT") && trimmedVal.endsWith(")") || trimmedVal.startsWith("MULTIPOINT") && trimmedVal.endsWith(")") || trimmedVal.startsWith("MULTILINESTRING") && trimmedVal.endsWith(")") || trimmedVal.startsWith("POLYGON") && trimmedVal.endsWith(")") || trimmedVal.startsWith("MULTIPOLYGON") && trimmedVal.endsWith(")");
    }

    @Override
    public Geometry toGeometry(String val) {
        val = val.trim();
        try {
            if (this.couldBeWtk(val)) {
                return this.wkt4326.read(val);
            }
            if (this.couldBeGeometry(val)) {
                GeometryJSON gj = new GeometryJSON();
                return gj.read((Object)val);
            }
        }
        catch (IOException | ParseException throwable) {
            // empty catch block
        }
        return null;
    }

    public double detects(String val) {
        if (StringUtils.isBlank((String)val)) {
            return 0.0;
        }
        return this.looksGeometry(val) ? 0.7 : 0.0;
    }

    public static Class<?> strToClass(String val) {
        switch (val) {
            case "Point": {
                return Point.class;
            }
            case "MultiPoint": {
                return MultiPoint.class;
            }
            case "LineString": {
                return LineString.class;
            }
            case "MultiLineString": {
                return MultiLineString.class;
            }
            case "Polygon": {
                return Polygon.class;
            }
            case "MultiPolygon": {
                return MultiPolygon.class;
            }
        }
        throw new IllegalArgumentException("No geometry class corresponding to string : " + val);
    }
}

