/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.spark.yarnaware;

import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.SSHConnection;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.exceptions.CodedIOException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.input.remote.SSHRemote;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.spark.SparkCodes;
import com.jcraft.jsch.JSchException;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class YarnClusterSSHTunnel
implements AutoCloseable {
    private final String connectionName;
    private final int portNumber;
    private SSHRemote remote;
    private String remoteHostName;
    int refCount = 0;
    private static Logger logger = Logger.getLogger((String)"dku.spark.tunnel");

    public static SSHConnection getConnection(AuthCtx authCtx, String connectionName) throws IOException, DKUSecurityException {
        DSSConnection connection = ConnectionsDAO.get().getMandatoryConnection(authCtx, connectionName);
        if (connection instanceof SSHConnection) {
            return (SSHConnection)connection;
        }
        throw new CodedIOException((InfoMessage.MessageCode)SparkCodes.ERR_SPARK_YARN_CLUSTER_SETTING_INCOMPLETE, "Connection " + connectionName + " is not a SSH connection, cannot be used to tunnel");
    }

    public YarnClusterSSHTunnel(AuthCtx authCtx, String connectionName, String bindAddress, int portNumber) throws IOException, JSchException, DKUSecurityException {
        this(authCtx, YarnClusterSSHTunnel.getConnection(authCtx, connectionName), bindAddress, portNumber);
    }

    public YarnClusterSSHTunnel(AuthCtx authCtx, SSHConnection connection, String bindAddress, int portNumber) throws IOException, JSchException, DKUSecurityException {
        this.connectionName = connection.name;
        this.portNumber = portNumber;
        SSHConnection.SerializableSSHCredentials creds = connection.getFullyResolvedCredentials_fsLike(new ConnectionWithBasicCredential.CredentialResolutionContext(authCtx, null), SSHConnection.SerializableSSHCredentials.class);
        String host = connection.params.host;
        String user = creds.user;
        int port = connection.params.port;
        String password = creds.password;
        String passphrase = creds.passphrase;
        boolean usePublicKey = creds.usePublicKey;
        int timeout = 60000;
        this.remote = new SSHRemote(host, user, usePublicKey, passphrase, password, port, timeout);
        if (StringUtils.isBlank((String)bindAddress)) {
            bindAddress = "*";
        }
        try {
            this.remote.forwardRemotePort(bindAddress, portNumber);
        }
        catch (JSchException e) {
            if (e.getCause() != null && e.getCause() instanceof ArrayIndexOutOfBoundsException) {
                logger.info((Object)("Convert " + bindAddress + " to IP to workaround buffer size problems"));
                try {
                    this.remote.close();
                }
                catch (Exception e2) {
                    logger.warn((Object)"Error while closing now broken ssh remote");
                }
                this.remote = new SSHRemote(host, user, usePublicKey, passphrase, password, port, timeout);
                try {
                    String hostOutput = this.remote.execAndGet("host " + SSHRemote.shellQuote(bindAddress));
                    if (StringUtils.isNotBlank((String)hostOutput)) {
                        String[] elems = hostOutput.split("\\s+");
                        bindAddress = elems[elems.length - 1];
                    }
                }
                catch (IOException e2) {
                    throw new JSchException("Failed to resolve " + bindAddress + " to ip", (Throwable)e2);
                }
                logger.info((Object)("Converted to " + bindAddress));
                this.remote.forwardRemotePort(bindAddress, portNumber);
            }
            throw e;
        }
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    @Override
    public void close() {
        try {
            if (this.remote != null) {
                this.remote.close();
            }
        }
        finally {
            this.remote = null;
        }
    }

    public int getRemotePort() {
        return this.portNumber;
    }

    public String getHostName() throws IOException {
        if (StringUtils.isBlank((String)this.remoteHostName)) {
            this.remoteHostName = this.remote.execAndGet("hostname").trim();
        }
        return this.remoteHostName;
    }
}

