/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.streaming.crecipes.sync;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.ComputableFromRefService;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.JobAuthCtxService;
import com.dataiku.dip.dataflow.exec.AbortableRecipeRunner;
import com.dataiku.dip.dataflow.exec.FlowRunnable;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowStreamingEndpoint;
import com.dataiku.dip.dataflow.streaming.ContinuousActivity;
import com.dataiku.dip.recipes.FakeJobActivityFromRecipeBuilder;
import com.dataiku.dip.recipes.RecipeRegistry;
import com.dataiku.dip.recipes.common.RecipeEngineStatus;
import com.dataiku.dip.streaming.crecipes.sync.CSyncExecutor;
import com.dataiku.dip.streaming.crecipes.sync.CSyncRecipeParams;
import com.dataiku.dip.streaming.crecipes.sync.CsyncRecipeStatusComputer;
import com.dataiku.dip.streaming.crecipes.sync.SimpleSEToDatasetCSyncRecipeExecutor;
import com.dataiku.dip.streaming.crecipes.sync.SimpleSEToSECSyncRecipeExecutor;
import com.dataiku.dip.streaming.crecipes.sync.SingletThreadKafkaToDatasetCSyncRecipeExecutor;
import com.dataiku.dip.streaming.crecipes.sync.SparkCSyncRecipeExecutor;
import com.dataiku.dip.streaming.endpoints.model.StreamingEndpoint;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class CSyncRecipeRunner
implements FlowRunnable,
AbortableRecipeRunner {
    @Autowired
    private JobAuthCtxService authCtxService;
    @Autowired
    private ComputableFromRefService cfrService;
    @Autowired
    private DatasetsDAO datasetsDAO;
    private final ContinuousActivity activity;
    private CSyncExecutor executor = null;
    private volatile boolean done = false;
    private SerializedRecipe sr;
    private static Logger logger = Logger.getLogger((String)"dku.flow.sync");

    public CSyncRecipeRunner(ContinuousActivity activity, SerializedRecipe sr) {
        this.activity = activity;
        this.sr = sr;
    }

    @Override
    public void run() throws Exception {
        SerializedRecipe.RecipeInput ri = this.sr.getSingleInput("main");
        FlowComputable inputComputable = this.cfrService.get(this.activity.projectKey, ri.ref);
        SerializedRecipe.RecipeOutput ro = this.sr.getSingleOutput("main");
        FlowComputable outputComputable = this.cfrService.get(this.activity.projectKey, ro.ref);
        CSyncRecipeParams params = this.sr.getParamsAs(CSyncRecipeParams.class);
        CsyncRecipeStatusComputer statusComputer = (CsyncRecipeStatusComputer)RecipeRegistry.getMeta(this.sr).buildStatusComputer(this.sr, "");
        RecipeEngineStatus engine = statusComputer.selectEngine(this.authCtxService.getAuthCtx(), params.engineType);
        if (engine.type.equals("SPARK")) {
            JobActivity jobActivity = new FakeJobActivityFromRecipeBuilder().buildFakeJobActivity(this.sr);
            SparkCSyncRecipeExecutor runner = new SparkCSyncRecipeExecutor(jobActivity, params.engineParams.spark, this.sr.projectKey + "_" + this.sr.name);
            this.executor = runner;
            runner.run(this.authCtxService.getAuthCtx());
        } else if (inputComputable.getType() == FlowComputable.FCType.STREAMING_ENDPOINT && outputComputable.getType() == FlowComputable.FCType.DATASET) {
            long checkpointInterval;
            StreamingEndpoint se = ((FlowStreamingEndpoint)inputComputable).getStreamingEndpoint();
            Dataset dataset = ((FlowDataset)outputComputable).getMandatory(this.datasetsDAO);
            if (params.checkpointInterval < 100L) {
                logger.info((Object)("Checkpoint interval too small (" + params.checkpointInterval + "), using 100ms"));
                checkpointInterval = 100L;
            } else {
                checkpointInterval = params.checkpointInterval;
            }
            long checkpointMaxRows = Math.max(10L, params.checkpointMaxRows);
            if (params.checkpointMaxRows < 10L) {
                logger.info((Object)("Checkpoint max rows too small (" + params.checkpointMaxRows + "), using 10 rows"));
                checkpointMaxRows = 10L;
            } else {
                checkpointMaxRows = params.checkpointMaxRows;
            }
            if ("kafka".equals(se.type)) {
                SingletThreadKafkaToDatasetCSyncRecipeExecutor runner = new SingletThreadKafkaToDatasetCSyncRecipeExecutor(this.sr.projectKey + "_" + this.sr.name, se, dataset, checkpointInterval, checkpointMaxRows);
                this.executor = runner;
                runner.run(this.authCtxService.getAuthCtx());
            } else {
                SimpleSEToDatasetCSyncRecipeExecutor runner = new SimpleSEToDatasetCSyncRecipeExecutor(this.sr.projectKey + "_" + this.sr.name, se, dataset, checkpointInterval, checkpointMaxRows);
                this.executor = runner;
                runner.run(this.authCtxService.getAuthCtx());
            }
        } else if (inputComputable.getType() == FlowComputable.FCType.STREAMING_ENDPOINT && outputComputable.getType() == FlowComputable.FCType.STREAMING_ENDPOINT) {
            StreamingEndpoint source = ((FlowStreamingEndpoint)inputComputable).getStreamingEndpoint();
            StreamingEndpoint target = ((FlowStreamingEndpoint)outputComputable).getStreamingEndpoint();
            SimpleSEToSECSyncRecipeExecutor runner = new SimpleSEToSECSyncRecipeExecutor(source, target);
            this.executor = runner;
            runner.run(this.authCtxService.getAuthCtx());
        } else {
            throw new Error("unimplemented");
        }
        this.done = true;
    }

    @Override
    public void notifyBeforeAborting() {
        CSyncExecutor current = this.executor;
        if (current != null) {
            current.abort();
            long start = System.currentTimeMillis();
            while (!this.done && System.currentTimeMillis() - start < 20000L) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    logger.warn((Object)"Waiting for abort interrupted");
                    break;
                }
            }
        }
    }
}

