/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions;

import com.google.refine.expr.EvalError;
import com.google.refine.grel.Documentation;
import com.google.refine.grel.Function;
import com.google.refine.grel.GrelControlFunctionRegistry;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Jsonize
implements Function {
    @Override
    public Object call(Properties bindings, Object[] args) {
        if (args.length == 1) {
            try {
                Object o1 = args[0];
                if (o1 == null) {
                    return "null";
                }
                if (o1 instanceof Number) {
                    return JSONObject.numberToString((Number)((Number)o1));
                }
                if (o1 instanceof Boolean) {
                    return o1.toString();
                }
                if (o1 instanceof JSONObject) {
                    return o1.toString();
                }
                if (o1 instanceof JSONArray) {
                    return o1.toString();
                }
                if (o1 instanceof Map) {
                    return new JSONObject((Map)o1).toString();
                }
                if (o1 instanceof Collection) {
                    return new JSONArray((Collection)o1).toString();
                }
                if (o1.getClass().isArray()) {
                    return new JSONArray(o1).toString();
                }
                return JSONObject.quote((String)o1.toString());
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
        }
        return new EvalError(GrelControlFunctionRegistry.getInstance().getFunctionName(this) + " expects an argument");
    }

    @Override
    public Documentation getDocumentation() {
        return new Documentation("GREL.FUNCTION.Jsonize.DOCUMENTATION", "Quotes a value as a JSON literal value.").withParams("value").withReturns("JSON literal value").withCategory("GREL.FUNCTIONS.CATEGORY.OBJECT", "Object functions");
    }
}

