/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions.dataiku;

import com.dataiku.dip.io.ColumnBlock;
import com.google.refine.expr.CellTuple;
import com.google.refine.expr.EvalError;
import com.google.refine.expr.WrappedCell;
import com.google.refine.expr.functions.dataiku.Val;
import com.google.refine.grel.Documentation;
import com.google.refine.grel.Function;
import com.google.refine.grel.GrelControlFunctionRegistry;
import com.google.refine.udaf.UdafUtils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class Numval
implements Function {
    @Override
    public Object call(Properties bindings, Object[] args) {
        WrappedCell wc;
        CellTuple tuple;
        if (args.length == 0 || args[0] == null) {
            return new EvalError(GrelControlFunctionRegistry.getInstance().getFunctionName(this) + " expects one argument");
        }
        if (args.length > 2) {
            return new EvalError(GrelControlFunctionRegistry.getInstance().getFunctionName(this) + " does not expect more than two arguments");
        }
        String columnName = args[0].toString().trim();
        if (args.length == 2) {
            int offset = Val.extractOffset(args[1]);
            if (offset > 0) {
                Object fieldValue;
                int index;
                List previousRows = (List)bindings.get("previousRows");
                if (previousRows != null && (index = previousRows.size() - offset) >= 0 && (fieldValue = ((Map)previousRows.get(index)).get(columnName)) != null) {
                    try {
                        return Double.parseDouble(fieldValue.toString());
                    }
                    catch (Exception e) {
                        return new EvalError("Cannot parse to number: " + e.getMessage());
                    }
                }
                return null;
            }
            if (offset < 0) {
                throw new IllegalArgumentException("The offset argument must be a greater than or equal to zero");
            }
        }
        if ((tuple = (CellTuple)bindings.get("cells")) != null && (wc = (WrappedCell)tuple.getField(columnName, bindings)) != null) {
            try {
                Object fieldValue = wc.getField("value", bindings);
                return fieldValue != null ? Double.valueOf(Double.parseDouble(fieldValue.toString())) : null;
            }
            catch (Exception e) {
                return new EvalError("Cannot parse to number: " + e.getMessage());
            }
        }
        ColumnBlock columnBlock = UdafUtils.getColumnBlock(bindings, columnName);
        if (columnBlock != null) {
            return UdafUtils.getNumericColumnValue(bindings, columnBlock, 0.0);
        }
        return null;
    }

    @Override
    public boolean treatFirstArgumentAsColumnName() {
        return true;
    }

    @Override
    public Documentation getDocumentation() {
        return new Documentation("GREL.FUNCTION.Numval.DOCUMENTATION", "Returns the numerical value of a column. If the value is not numerical, an empty value is returned. Specify an optional <code>offset</code> to retrieve the value of the column on a previous row.").withParams("string columnName", "[number offset]").withReturns("number").withCategory("GREL.FUNCTIONS.CATEGORY.VALUE_ACCESS", "Value access functions");
    }

    @Override
    public boolean requirePreviousRows() {
        return true;
    }

    @Override
    public Map<String, Integer> getNumberOfPreviousRowsRequiredByColumns(Object[] args) {
        if (args != null && args.length == 2) {
            String columnName = args[0] != null ? args[0].toString().trim() : "";
            return Map.of(columnName, Val.extractOffset(args[1]));
        }
        return Collections.emptyMap();
    }
}

