/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.snapshot;

import io.delta.kernel.Snapshot;
import io.delta.kernel.engine.Engine;
import io.delta.kernel.exceptions.CheckpointAlreadyExistsException;
import io.delta.kernel.exceptions.InvalidTableException;
import io.delta.kernel.exceptions.TableNotFoundException;
import io.delta.kernel.internal.DeltaErrors;
import io.delta.kernel.internal.DeltaHistoryManager;
import io.delta.kernel.internal.SnapshotImpl;
import io.delta.kernel.internal.TableConfig;
import io.delta.kernel.internal.TableFeatures;
import io.delta.kernel.internal.actions.Metadata;
import io.delta.kernel.internal.checkpoints.CheckpointInstance;
import io.delta.kernel.internal.checkpoints.CheckpointMetaData;
import io.delta.kernel.internal.checkpoints.Checkpointer;
import io.delta.kernel.internal.coordinatedcommits.Commit;
import io.delta.kernel.internal.fs.Path;
import io.delta.kernel.internal.lang.ListUtils;
import io.delta.kernel.internal.replay.CreateCheckpointIterator;
import io.delta.kernel.internal.replay.LogReplay;
import io.delta.kernel.internal.replay.LogReplayUtils;
import io.delta.kernel.internal.snapshot.LogSegment;
import io.delta.kernel.internal.snapshot.MetadataCleanup;
import io.delta.kernel.internal.snapshot.SnapshotHint;
import io.delta.kernel.internal.snapshot.TableCommitCoordinatorClientHandler;
import io.delta.kernel.internal.util.Clock;
import io.delta.kernel.internal.util.FileNames;
import io.delta.kernel.internal.util.Preconditions;
import io.delta.kernel.internal.util.Tuple2;
import io.delta.kernel.utils.CloseableIterator;
import io.delta.kernel.utils.FileStatus;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileAlreadyExistsException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotManager {
    private AtomicReference<SnapshotHint> latestSnapshotHint = new AtomicReference();
    private final Path logPath;
    private final Path tablePath;
    private static final Logger logger = LoggerFactory.getLogger(SnapshotManager.class);

    public SnapshotManager(Path path, Path path2) {
        this.logPath = path;
        this.tablePath = path2;
    }

    public static void verifyDeltaVersions(List<Long> list, Optional<Long> optional, Optional<Long> optional2, Path path) {
        List list2;
        if (!list.isEmpty() && !(list2 = LongStream.rangeClosed(list.get(0), list.get(list.size() - 1)).boxed().collect(Collectors.toList())).equals(list)) {
            throw new InvalidTableException(path.toString(), String.format("Missing delta files: versions are not continuous: (%s)", list));
        }
        optional.ifPresent(l -> Preconditions.checkArgument(!list.isEmpty() && Objects.equals(list.get(0), l), "Did not get the first delta file version %s to compute Snapshot", l));
        optional2.ifPresent(l -> Preconditions.checkArgument(!list.isEmpty() && Objects.equals(list.get(list.size() - 1), l), "Did not get the last delta file version %s to compute Snapshot", l));
    }

    public Snapshot buildLatestSnapshot(Engine engine) throws TableNotFoundException {
        return this.getSnapshotAtInit(engine);
    }

    public Snapshot getSnapshotAt(Engine engine, long l) throws TableNotFoundException {
        Optional<LogSegment> optional = this.getLogSegmentAtOrBeforeVersion(engine, Optional.empty(), Optional.of(l), Optional.empty());
        SnapshotImpl snapshotImpl = optional.map(logSegment -> this.getCoordinatedCommitsAwareSnapshot(engine, (LogSegment)logSegment, Optional.of(l))).orElseThrow(() -> new TableNotFoundException(this.tablePath.toString()));
        long l2 = snapshotImpl.getVersion(engine);
        if (l2 != l) {
            throw DeltaErrors.versionAfterLatestCommit(this.tablePath.toString(), l, l2);
        }
        return snapshotImpl;
    }

    public Snapshot getSnapshotForTimestamp(Engine engine, long l) throws TableNotFoundException {
        long l2 = System.currentTimeMillis();
        long l3 = DeltaHistoryManager.getActiveCommitAtTimestamp(engine, this.logPath, l, true, false, false).getVersion();
        logger.info("{}: Took {}ms to fetch version at timestamp {}", new Object[]{this.tablePath, System.currentTimeMillis() - l2, l});
        return this.getSnapshotAt(engine, l3);
    }

    public void checkpoint(Engine engine, Clock clock, long l) throws TableNotFoundException, IOException {
        Object object;
        Object object2;
        logger.info("{}: Starting checkpoint for version: {}", (Object)this.tablePath, (Object)l);
        SnapshotImpl snapshotImpl = (SnapshotImpl)this.getSnapshotAt(engine, l);
        TableFeatures.validateWriteSupportedTable(snapshotImpl.getProtocol(), snapshotImpl.getMetadata(), snapshotImpl.getSchema(engine), this.tablePath.toString());
        Path path = FileNames.checkpointFileSingular(this.logPath, l);
        long l2 = 0L;
        try {
            object2 = snapshotImpl.getCreateCheckpointIterator(engine);
            object = null;
            try {
                DeltaErrors.wrapEngineExceptionThrowsIO(() -> SnapshotManager.lambda$checkpoint$4(engine, path, (CreateCheckpointIterator)object2), "Writing checkpoint file %s", path.toString());
                logger.info("{}: Checkpoint file is written for version: {}", (Object)this.tablePath, (Object)l);
                l2 = ((CreateCheckpointIterator)object2).getNumberOfAddActions();
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (object2 != null) {
                    if (object != null) {
                        try {
                            ((CreateCheckpointIterator)object2).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        ((CreateCheckpointIterator)object2).close();
                    }
                }
            }
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            throw new CheckpointAlreadyExistsException(l);
        }
        object2 = new CheckpointMetaData(l, l2, Optional.empty());
        object = new Checkpointer(this.logPath);
        ((Checkpointer)object).writeLastCheckpointFile(engine, (CheckpointMetaData)object2);
        logger.info("{}: Last checkpoint metadata file is written for version: {}", (Object)this.tablePath, (Object)l);
        logger.info("{}: Finished checkpoint for version: {}", (Object)this.tablePath, (Object)l);
        Metadata metadata = snapshotImpl.getMetadata();
        if (TableConfig.EXPIRED_LOG_CLEANUP_ENABLED.fromMetadata(metadata).booleanValue()) {
            MetadataCleanup.cleanupExpiredLogs(engine, clock, this.tablePath, TableConfig.LOG_RETENTION.fromMetadata(metadata));
        } else {
            logger.info("{}: Log cleanup is disabled. Skipping the deletion of expired log files", (Object)this.tablePath);
        }
    }

    private void registerHint(SnapshotHint snapshotHint) {
        this.latestSnapshotHint.updateAndGet(snapshotHint2 -> {
            if (snapshotHint2 == null) {
                return snapshotHint;
            }
            if (snapshotHint.getVersion() > snapshotHint2.getVersion()) {
                return snapshotHint;
            }
            return snapshotHint2;
        });
    }

    private CloseableIterator<FileStatus> listFrom(Engine engine, long l) throws IOException {
        logger.debug("{}: startVersion: {}", (Object)this.tablePath, (Object)l);
        return DeltaErrors.wrapEngineExceptionThrowsIO(() -> engine.getFileSystemClient().listFrom(FileNames.listingPrefix(this.logPath, l)), "Listing from %s", FileNames.listingPrefix(this.logPath, l));
    }

    private boolean isDeltaCommitOrCheckpointFile(String string) {
        return FileNames.isCheckpointFile(string) || FileNames.isCommitFile(string);
    }

    private Optional<CloseableIterator<FileStatus>> listFromOrNone(Engine engine, long l) {
        try {
            CloseableIterator<FileStatus> closeableIterator = this.listFrom(engine, l);
            if (closeableIterator.hasNext()) {
                return Optional.of(closeableIterator);
            }
            return Optional.empty();
        }
        catch (FileNotFoundException fileNotFoundException) {
            return Optional.empty();
        }
        catch (IOException iOException) {
            throw new UncheckedIOException("Failed to list the files in delta log", iOException);
        }
    }

    protected final Optional<List<FileStatus>> listDeltaAndCheckpointFiles(Engine engine, long l, Optional<Long> optional, Optional<TableCommitCoordinatorClientHandler> optional2) {
        optional.ifPresent(l2 -> Preconditions.checkArgument(l2 >= l, "versionToLoad=%s provided is less than startVersion=%s", l2, l));
        logger.debug("startVersion: {}, versionToLoad: {}, coordinated commits enabled: {}", new Object[]{l, optional, optional2.isPresent()});
        List<Commit> list = this.getUnbackfilledCommits(optional2, l, optional);
        AtomicLong atomicLong = new AtomicLong(l - 1L);
        Optional<CloseableIterator<FileStatus>> optional3 = this.listFromOrNone(engine, l);
        Optional<List<FileStatus>> optional4 = optional3.map(closeableIterator -> {
            ArrayList<FileStatus> arrayList = new ArrayList<FileStatus>();
            while (closeableIterator.hasNext()) {
                FileStatus fileStatus = (FileStatus)closeableIterator.next();
                String string = Path.getName(fileStatus.getPath());
                if (!this.isDeltaCommitOrCheckpointFile(string) || FileNames.isCheckpointFile(string) && fileStatus.getSize() == 0L) continue;
                boolean bl = optional.map(l -> FileNames.getFileVersion(new Path(fileStatus.getPath())) <= l).orElse(true);
                if (!bl) {
                    if (!arrayList.isEmpty()) break;
                    long l2 = DeltaHistoryManager.getEarliestRecreatableCommit(engine, this.logPath);
                    throw DeltaErrors.versionBeforeFirstAvailableCommit(this.tablePath.toString(), (Long)optional.get(), l2);
                }
                if (FileNames.isCommitFile(string)) {
                    atomicLong.set(Math.max(atomicLong.get(), FileNames.deltaVersion(fileStatus.getPath())));
                }
                arrayList.add(fileStatus);
            }
            return arrayList;
        });
        if (!optional2.isPresent()) {
            return optional4;
        }
        List list3 = list.stream().filter(commit -> commit.getVersion() > atomicLong.get()).filter(commit -> !optional.isPresent() || commit.getVersion() <= (Long)optional.get()).map(Commit::getFileStatus).collect(Collectors.toList());
        return optional4.map(list2 -> {
            list2.addAll(list3);
            return list2;
        });
    }

    private List<Commit> getUnbackfilledCommits(Optional<TableCommitCoordinatorClientHandler> optional, long l, Optional<Long> optional2) {
        try {
            return optional.map(tableCommitCoordinatorClientHandler -> {
                logger.info("Getting un-backfilled commits from commit coordinator for table: {}", (Object)this.tablePath);
                return tableCommitCoordinatorClientHandler.getCommits(l, optional2.orElse(null)).getCommits();
            }).orElse(Collections.emptyList());
        }
        catch (Exception exception) {
            logger.error("Failed to get unbackfilled commits of table {} with commit coordinator: {}", (Object)this.tablePath, (Object)exception);
            throw exception;
        }
    }

    private SnapshotImpl getSnapshotAtInit(Engine engine) throws TableNotFoundException {
        Checkpointer checkpointer = new Checkpointer(this.logPath);
        Optional<CheckpointMetaData> optional = checkpointer.readLastCheckpointFile(engine);
        if (!optional.isPresent()) {
            logger.warn("{}: Last checkpoint file is missing or corrupted. Will search for the checkpoint files directly.", (Object)this.tablePath);
        }
        Optional<LogSegment> optional2 = this.getLogSegmentFrom(engine, optional);
        return optional2.map(logSegment -> this.getCoordinatedCommitsAwareSnapshot(engine, (LogSegment)logSegment, Optional.empty())).orElseThrow(() -> new TableNotFoundException(this.tablePath.toString()));
    }

    private SnapshotImpl getCoordinatedCommitsAwareSnapshot(Engine engine, LogSegment logSegment2, Optional<Long> optional) {
        SnapshotImpl snapshotImpl = this.createSnapshot(logSegment2, engine);
        if (optional.isPresent() && snapshotImpl.getVersion(engine) == optional.get().longValue()) {
            return snapshotImpl;
        }
        Optional<TableCommitCoordinatorClientHandler> optional2 = snapshotImpl.getTableCommitCoordinatorClientHandlerOpt(engine);
        if (optional2.isPresent()) {
            Optional<LogSegment> optional3 = this.getLogSegmentAtOrBeforeVersion(engine, snapshotImpl.getLogSegment().checkpointVersionOpt, optional, optional2);
            snapshotImpl = optional3.map(logSegment -> this.createSnapshot((LogSegment)logSegment, engine)).orElseThrow(() -> new TableNotFoundException(this.tablePath.toString()));
        }
        return snapshotImpl;
    }

    private SnapshotImpl createSnapshot(LogSegment logSegment, Engine engine) {
        String string = logSegment.checkpointVersionOpt.map(l -> String.format("starting from checkpoint version %s.", l)).orElse(".");
        logger.info("{}: Loading version {} {}", new Object[]{this.tablePath, logSegment.version, string});
        LogReplay logReplay = new LogReplay(this.logPath, this.tablePath, logSegment.version, engine, logSegment, Optional.ofNullable(this.latestSnapshotHint.get()));
        long l2 = System.currentTimeMillis();
        LogReplayUtils.assertLogFilesBelongToTable(this.logPath, logSegment.allLogFilesUnsorted());
        SnapshotImpl snapshotImpl = new SnapshotImpl(this.tablePath, logSegment, logReplay, logReplay.getProtocol(), logReplay.getMetadata());
        logger.info("{}: Took {}ms to construct the snapshot (loading protocol and metadata) for {} {}", new Object[]{this.tablePath, System.currentTimeMillis() - l2, logSegment.version, string});
        SnapshotHint snapshotHint = new SnapshotHint(snapshotImpl.getVersion(engine), snapshotImpl.getProtocol(), snapshotImpl.getMetadata());
        this.registerHint(snapshotHint);
        return snapshotImpl;
    }

    private Optional<LogSegment> getLogSegmentFrom(Engine engine, Optional<CheckpointMetaData> optional) {
        return this.getLogSegmentAtOrBeforeVersion(engine, optional.map(checkpointMetaData -> checkpointMetaData.version), Optional.empty(), Optional.empty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Optional<LogSegment> getLogSegmentAtOrBeforeVersion(Engine engine, Optional<Long> optional, Optional<Long> optional2, Optional<TableCommitCoordinatorClientHandler> optional3) {
        long l2;
        long l3;
        Optional<Long> optional4 = optional.filter(l -> !optional2.isPresent() || l <= (Long)optional2.get());
        if (!optional4.isPresent() && optional2.isPresent()) {
            l3 = optional2.get() + 1L;
            l2 = System.currentTimeMillis();
            optional4 = Checkpointer.findLastCompleteCheckpointBefore(engine, this.logPath, l3).map(checkpointInstance -> checkpointInstance.version);
            logger.info("{}: Took {}ms to load last checkpoint before version {}", new Object[]{this.tablePath, System.currentTimeMillis() - l2, l3});
        }
        l3 = optional4.orElseGet(() -> {
            logger.warn("{}: Starting checkpoint is missing. Listing from version as 0", (Object)this.tablePath);
            return 0L;
        });
        l2 = System.currentTimeMillis();
        Optional<List<FileStatus>> optional5 = this.listDeltaAndCheckpointFiles(engine, l3, optional2, optional3);
        logger.info("{}: Took {}ms to list the files after starting checkpoint", (Object)this.tablePath, (Object)(System.currentTimeMillis() - l2));
        l2 = System.currentTimeMillis();
        try {
            Optional<LogSegment> optional6 = this.getLogSegmentAtOrBeforeVersion(engine, optional4, optional2, optional5, optional3);
            return optional6;
        }
        finally {
            logger.info("{}: Took {}ms to construct a log segment", (Object)this.tablePath, (Object)(System.currentTimeMillis() - l2));
        }
    }

    protected Optional<LogSegment> getLogSegmentAtOrBeforeVersion(Engine engine, Optional<Long> optional, Optional<Long> optional2, Optional<List<FileStatus>> optional3, Optional<TableCommitCoordinatorClientHandler> optional4) {
        long l;
        List<FileStatus> list;
        if (optional3.isPresent()) {
            list = optional3.get();
        } else {
            if (!optional.isPresent()) {
                return Optional.empty();
            }
            list = Collections.emptyList();
        }
        this.logDebug(() -> String.format("newFiles: %s", Arrays.toString(list.stream().map(fileStatus -> new Path(fileStatus.getPath()).getName()).toArray())));
        if (list.isEmpty() && !optional.isPresent()) {
            throw new RuntimeException(String.format("No delta files found in the directory: %s", this.logPath));
        }
        if (list.isEmpty()) {
            return this.getLogSegmentAtOrBeforeVersion(engine, Optional.empty(), optional2, optional4);
        }
        Tuple2<List<FileStatus>, List<FileStatus>> tuple2 = ListUtils.partition(list, fileStatus -> FileNames.isCheckpointFile(new Path(fileStatus.getPath()).getName()));
        List list2 = (List)tuple2._1;
        List list3 = (List)tuple2._2;
        this.logDebug(() -> String.format("\ncheckpoints: %s\ndeltas: %s", Arrays.toString(list2.stream().map(fileStatus -> new Path(fileStatus.getPath()).getName()).toArray()), Arrays.toString(list3.stream().map(fileStatus -> new Path(fileStatus.getPath()).getName()).toArray())));
        CheckpointInstance checkpointInstance2 = optional2.map(CheckpointInstance::new).orElse(CheckpointInstance.MAX_VALUE);
        logger.debug("lastCheckpoint: {}", (Object)checkpointInstance2);
        List<CheckpointInstance> list4 = list2.stream().map(fileStatus -> new CheckpointInstance(fileStatus.getPath())).collect(Collectors.toList());
        this.logDebug(() -> String.format("checkpointFiles: %s", Arrays.toString(list4.toArray())));
        Optional<CheckpointInstance> optional5 = Checkpointer.getLatestCompleteCheckpointFromList(list4, checkpointInstance2);
        logger.debug("newCheckpointOpt: {}", optional5);
        long l3 = optional5.map(checkpointInstance -> checkpointInstance.version).orElseGet(() -> {
            optional.map(l -> {
                long l2 = optional2.orElseGet(() -> {
                    FileStatus fileStatus = (FileStatus)list3.get(list3.size() - 1);
                    return FileNames.deltaVersion(new Path(fileStatus.getPath()));
                });
                return this.getLogSegmentWithMaxExclusiveCheckpointVersion(l2, (long)l).orElseThrow(() -> new RuntimeException(String.format("Checkpoint file to load version: %s is missing.", l)));
            });
            return -1L;
        });
        logger.debug("newCheckpointVersion: {}", (Object)l3);
        List<FileStatus> list5 = list3.stream().filter(fileStatus -> FileNames.deltaVersion(new Path(fileStatus.getPath())) > l3).collect(Collectors.toList());
        this.logDebug(() -> String.format("deltasAfterCheckpoint: %s", Arrays.toString(list5.stream().map(fileStatus -> new Path(fileStatus.getPath()).getName()).toArray())));
        LinkedList linkedList = list5.stream().map(fileStatus -> FileNames.deltaVersion(new Path(fileStatus.getPath()))).collect(Collectors.toCollection(LinkedList::new));
        this.logDebug(() -> String.format("deltaVersions: %s", Arrays.toString(linkedList.toArray())));
        long l4 = l = linkedList.isEmpty() ? optional5.get().version : (Long)linkedList.getLast();
        if (list3.isEmpty() || FileNames.deltaVersion(((FileStatus)list3.get(list3.size() - 1)).getPath()) < l) {
            throw new InvalidTableException(this.tablePath.toString(), String.format("Missing delta file for version %s", l));
        }
        optional2.filter(l2 -> l2 < l).ifPresent(l2 -> {
            throw DeltaErrors.versionAfterLatestCommit(this.tablePath.toString(), l2, l);
        });
        if (!linkedList.isEmpty()) {
            if ((Long)linkedList.getFirst() != l3 + 1L) {
                throw new InvalidTableException(this.tablePath.toString(), String.format("Unable to reconstruct table state: missing log file for version %s", l3 + 1L));
            }
            logger.info("Verified delta files are contiguous from version {} to {}", (Object)(l3 + 1L), (Object)l);
            SnapshotManager.verifyDeltaVersions(linkedList, Optional.of(l3 + 1L), Optional.of(l), this.tablePath);
        }
        long l5 = ((FileStatus)list3.get(list3.size() - 1)).getModificationTime();
        List<FileStatus> list6 = optional5.map(checkpointInstance -> {
            HashSet<Path> hashSet = new HashSet<Path>(checkpointInstance.getCorrespondingFiles(this.logPath));
            List list2 = list2.stream().filter(fileStatus -> hashSet.contains(new Path(fileStatus.getPath()))).collect(Collectors.toList());
            if (list2.size() != hashSet.size()) {
                String string = String.format("Seems like the checkpoint is corrupted. Failed in getting the file information for:\n%s\namong\n%s", hashSet.stream().map(Path::toString).collect(Collectors.toList()), list2.stream().map(FileStatus::getPath).collect(Collectors.joining("\n - ")));
                throw new IllegalStateException(string);
            }
            return list2;
        }).orElse(Collections.emptyList());
        return Optional.of(new LogSegment(this.logPath, l, list5, list6, optional5.map(checkpointInstance -> checkpointInstance.version), l5));
    }

    private Optional<LogSegment> getLogSegmentWithMaxExclusiveCheckpointVersion(long l, long l2) {
        return Optional.empty();
    }

    private void logDebug(Supplier<String> supplier) {
        if (logger.isDebugEnabled()) {
            logger.debug(supplier.get());
        }
    }

    private static /* synthetic */ Object lambda$checkpoint$4(Engine engine, Path path, CreateCheckpointIterator createCheckpointIterator) throws IOException {
        engine.getParquetHandler().writeParquetFileAtomically(path.toString(), createCheckpointIterator);
        return null;
    }
}

