/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api.eda;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.eda.compute.ComputeService;
import com.dataiku.dip.eda.compute.computations.Computation;
import com.dataiku.dip.eda.compute.computations.ComputationResult;
import com.dataiku.dip.eda.compute.engine.ComputationRunner;
import com.dataiku.dip.eda.compute.sampling.Sample;
import com.dataiku.dip.eda.compute.sampling.SamplesService;
import com.dataiku.dip.eda.worksheets.CardComputeService;
import com.dataiku.dip.eda.worksheets.WorksheetsService;
import com.dataiku.dip.eda.worksheets.cards.Card;
import com.dataiku.dip.eda.worksheets.cards.CardResult;
import com.dataiku.dip.eda.worksheets.models.Worksheet;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.FutureThreadBase;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.PermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.api.PublicAPICodes;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.DatasetLocUtils;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/publicapi"})
public class PublicAPIStatisticsController
extends PublicAPIControllerBase {
    @Autowired
    WorksheetsService worksheetService;
    @Autowired
    TransactionService transactionService;
    @Autowired
    PermissionsService permissionsService;
    @Autowired
    MetaAuthService authService;
    @Autowired
    ProjectsService projectsService;
    @Autowired
    SamplesService samplesService;
    @Autowired
    CardComputeService cardComputeService;
    @Autowired
    FutureService futureService;
    @Autowired
    ComputeService computeService;

    @AuditedCall(value={"msgType", "statistics-card-compile"})
    @RequestMapping(value={"/statistics/cards/compile"}, method={RequestMethod.POST})
    @ResponseBody
    public Computation compileCard(HttpServletRequest req, @RequestBody Card card) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getTicketOrKey(req);
            Computation computation = this.cardComputeService.humanFriendlyComputationPlan(card);
            return computation;
        }
    }

    @AuditedCall(value={"msgType", "statistics-worksheets-list", "projectKey", "${projectKey}", "datasetName", "${datasetSmartName}"})
    @RequestMapping(value={"/projects/{projectKey}/datasets/{datasetSmartName}/statistics/worksheets/"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Worksheet> list(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String datasetSmartName) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            AnyLoc datasetLoc = DatasetLocUtils.DatasetLoc.resolveSmart((String)projectKey, (String)datasetSmartName);
            this.checkDatasetAccess(authCtx, projectKey, datasetLoc);
            List list = this.worksheetService.listWorksheets(projectKey, datasetSmartName);
            return list;
        }
    }

    @AuditedCall(value={"msgType", "statistics-worksheets-create", "projectKey", "${projectKey}", "datasetName", "${datasetSmartName}"})
    @RequestMapping(value={"/projects/{projectKey}/datasets/{datasetSmartName}/statistics/worksheets/"}, method={RequestMethod.POST})
    @ResponseBody
    public Worksheet create(HttpServletRequest req, @PathVariable String projectKey, @RequestBody Worksheet worksheet, @PathVariable String datasetSmartName) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            AnyLoc datasetLoc = DatasetLocUtils.DatasetLoc.resolveSmart((String)projectKey, (String)datasetSmartName);
            this.checkDatasetAccess(authCtx, projectKey, datasetLoc);
            worksheet.projectKey = projectKey;
            worksheet.id = null;
            worksheet.dataSpec.inputDatasetSmartName = datasetLoc.getSmartName(projectKey);
            Worksheet savedWorksheet = this.worksheetService.saveWorksheet(authCtx, worksheet);
            t.commit("Create worksheet " + savedWorksheet.getFullId());
            Worksheet worksheet2 = savedWorksheet;
            return worksheet2;
        }
    }

    @AuditedCall(value={"msgType", "statistics-worksheets-update", "projectKey", "${projectKey}", "worksheetId", "${worksheetId}", "datasetName", "${datasetSmartName}"})
    @RequestMapping(value={"/projects/{projectKey}/datasets/{datasetSmartName}/statistics/worksheets/{worksheetId:.+}"}, method={RequestMethod.PUT})
    @ResponseBody
    public Worksheet update(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String worksheetId, @RequestBody Worksheet worksheet, @PathVariable String datasetSmartName) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            AnyLoc datasetLoc = DatasetLocUtils.DatasetLoc.resolveSmart((String)projectKey, (String)datasetSmartName);
            this.checkDatasetAndWorksheetAccess(authCtx, projectKey, datasetLoc, worksheetId);
            worksheet.projectKey = projectKey;
            worksheet.id = worksheetId;
            worksheet.dataSpec.inputDatasetSmartName = datasetLoc.getSmartName(projectKey);
            Worksheet savedWorksheet = this.worksheetService.saveWorksheet(authCtx, worksheet);
            t.commit("Update worksheet " + savedWorksheet.getFullId());
            Worksheet worksheet2 = savedWorksheet;
            return worksheet2;
        }
    }

    @AuditedCall(value={"msgType", "statistics-worksheets-get", "projectKey", "${projectKey}", "worksheetId", "${worksheetId}", "datasetName", "${datasetSmartName}"})
    @RequestMapping(value={"/projects/{projectKey}/datasets/{datasetSmartName}/statistics/worksheets/{worksheetId:.+}"}, method={RequestMethod.GET})
    @ResponseBody
    public Worksheet get(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String worksheetId, @PathVariable String datasetSmartName) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            AnyLoc datasetLoc = DatasetLocUtils.DatasetLoc.resolveSmart((String)projectKey, (String)datasetSmartName);
            this.checkDatasetAndWorksheetAccess(authCtx, projectKey, datasetLoc, worksheetId);
            Worksheet worksheet = this.worksheetService.getWorksheet(projectKey, worksheetId);
            this.checkArgument(worksheet.getDatasetLoc().equals((Object)datasetLoc), (InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_EMPTY_PARAMETER, "Worksheet " + worksheetId + " does not belong to dataset " + datasetSmartName, new Object[0]);
            Worksheet worksheet2 = worksheet;
            return worksheet2;
        }
    }

    @AuditedCall(value={"msgType", "statistics-worksheets-delete", "projectKey", "${projectKey}", "worksheetId", "${worksheetId}", "datasetName", "${datasetSmartName}"})
    @RequestMapping(value={"/projects/{projectKey}/datasets/{datasetSmartName}/statistics/worksheets/{worksheetId:.+}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void delete(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String worksheetId, @PathVariable String datasetSmartName) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            AnyLoc datasetLoc = DatasetLocUtils.DatasetLoc.resolveSmart((String)projectKey, (String)datasetSmartName);
            this.checkDatasetAndWorksheetAccess(authCtx, projectKey, datasetLoc, worksheetId);
            TaggableObjectsService.TaggableObjectRef worksheetRef = new TaggableObjectsService.TaggableObjectRef(projectKey, ITaggingService.TaggableType.STATISTICS_WORKSHEET, worksheetId);
            this.worksheetService.delete(worksheetRef);
            t.commit("Delete worksheet " + worksheetId);
        }
    }

    @AuditedCall(value={"msgType", "statistics-worksheets-run", "projectKey", "${projectKey}", "worksheetId", "${worksheetId}", "datasetName", "${datasetSmartName}"})
    @RequestMapping(value={"/projects/{projectKey}/datasets/{datasetSmartName}/statistics/worksheets/{worksheetId:.+}/actions/run-card"}, method={RequestMethod.POST})
    @ResponseBody
    public FutureResponse<CardResult> runCardOnWorksheet(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String worksheetId, @PathVariable String datasetSmartName, final @RequestBody Card card) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            final DSSAuthCtx authCtx = (DSSAuthCtx)this.authService.getTicketOrKey(req);
            AnyLoc datasetLoc = DatasetLocUtils.DatasetLoc.resolveSmart((String)projectKey, (String)datasetSmartName);
            this.checkDatasetAndWorksheetAccess((AuthCtx)authCtx, projectKey, datasetLoc, worksheetId);
            final Worksheet worksheet = this.worksheetService.getWorksheet(projectKey, worksheetId);
            FutureResponse futureResponse = this.futureService.runFuture((FutureThreadBase)new SimpleFutureThread<CardResult>((AuthCtx)authCtx){

                public FuturePayload getPayload() {
                    FuturePayload fp = FuturePayload.newSimple((String)"eda_run_card", (String)"Run card on statistics worksheet");
                    fp.targets.add(new FuturePayload.FuturePayloadTarget(worksheet.projectKey, worksheet.id, "Worksheet " + worksheet.name, ITaggingService.TaggableType.STATISTICS_WORKSHEET.name()));
                    return fp;
                }

                protected CardResult compute() throws Exception {
                    Sample sample = PublicAPIStatisticsController.this.samplesService.getOrRebuildCurrentSample_NT(authCtx, worksheet.getRef(), worksheet.dataSpec);
                    return PublicAPIStatisticsController.this.cardComputeService.computeResults_NT((AuthCtx)authCtx, card, false, sample);
                }
            }, 0L, (TypeToken)new TypeToken<FutureResponse<CardResult>>(){});
            return futureResponse;
        }
    }

    @AuditedCall(value={"msgType", "statistics-worksheets-run", "projectKey", "${projectKey}", "worksheetId", "${worksheetId}", "datasetName", "${datasetSmartName}"})
    @RequestMapping(value={"/projects/{projectKey}/datasets/{datasetSmartName}/statistics/worksheets/{worksheetId:.+}/actions/run-computation"}, method={RequestMethod.POST})
    @ResponseBody
    public FutureResponse<ComputationResult> runComputationOnWorksheet(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String worksheetId, @PathVariable String datasetSmartName, final @RequestBody Computation computation) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            final DSSAuthCtx authCtx = (DSSAuthCtx)this.authService.getTicketOrKey(req);
            AnyLoc datasetLoc = DatasetLocUtils.DatasetLoc.resolveSmart((String)projectKey, (String)datasetSmartName);
            this.checkDatasetAndWorksheetAccess((AuthCtx)authCtx, projectKey, datasetLoc, worksheetId);
            final Worksheet worksheet = this.worksheetService.getWorksheet(projectKey, worksheetId);
            FutureResponse futureResponse = this.futureService.runFuture((FutureThreadBase)new SimpleFutureThread<ComputationResult>((AuthCtx)authCtx){

                public FuturePayload getPayload() {
                    FuturePayload fp = FuturePayload.newSimple((String)"eda_run_computation", (String)"Run computation on statistics worksheet");
                    fp.targets.add(new FuturePayload.FuturePayloadTarget(worksheet.projectKey, worksheet.id, "Worksheet " + worksheet.name, ITaggingService.TaggableType.STATISTICS_WORKSHEET.name()));
                    return fp;
                }

                protected ComputationResult compute() throws Exception {
                    Sample sample = PublicAPIStatisticsController.this.samplesService.getOrRebuildCurrentSample_NT(authCtx, worksheet.getRef(), worksheet.dataSpec);
                    try (ComputationRunner runner = PublicAPIStatisticsController.this.computeService.getCachedSampleRunner((AuthCtx)authCtx, sample);){
                        ComputationResult computationResult = runner.compute(computation);
                        return computationResult;
                    }
                }
            }, 0L, (TypeToken)new TypeToken<FutureResponse<ComputationResult>>(){});
            return futureResponse;
        }
    }

    private void checkDatasetAccess(AuthCtx authCtx, String projectKey, AnyLoc datasetLoc) throws DKUSecurityException, IOException {
        this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
        this.projectsService.failIfNoDatasetReadUseAccess(authCtx, datasetLoc, projectKey);
    }

    private void checkDatasetAndWorksheetAccess(AuthCtx authCtx, String projectKey, AnyLoc datasetLoc, String worksheetId) throws DKUSecurityException, IOException {
        this.checkDatasetAccess(authCtx, projectKey, datasetLoc);
        Worksheet worksheet = this.worksheetService.getWorksheet(projectKey, worksheetId);
        this.checkArgument(worksheet.getDatasetLoc().equals((Object)datasetLoc), (InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_EMPTY_PARAMETER, "Worksheet " + worksheetId + " not found for dataset " + datasetLoc.getFullName(), new Object[0]);
    }
}

