/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.lambda;

import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.lambda.mgmt.devserver.LambdaDevServerKernel;
import com.dataiku.dip.lambda.mgmt.devserver.LambdaDevServerService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class LambdaDevServerController
extends DIPInternalControllerBase {
    @Autowired
    private UIAuthService authService;
    @Autowired
    private LambdaDevServerService lambdaDevServerService;
    @Autowired
    private TransactionService transactionService;

    @AuditNotNeeded
    @RequestMapping(value={"/api/lambda-devserver"}, method={RequestMethod.GET})
    public void getDevServerStatus(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
        }
        this.writeServerState(resp, projectKey, user);
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/lambda-devserver"}, method={RequestMethod.POST})
    public void startDevServer(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
        }
        this.lambdaDevServerService.getOrCreateKernel(user, projectKey);
        this.writeServerState(resp, projectKey, user);
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/lambda-devserver"}, method={RequestMethod.DELETE})
    public void stopDevServer(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
        }
        this.lambdaDevServerService.removeKernel(user, projectKey);
        LambdaDevServerController.writeEmptyJSONObj((HttpServletResponse)resp);
    }

    private void writeServerState(HttpServletResponse resp, @RequestParam String projectKey, AuthCtx user) throws DKUSecurityException, IOException {
        LambdaDevServerService.DevServerState serverState = this.lambdaDevServerService.getState(user, projectKey);
        JSONObject res = new JSONObject().put("status", (Object)serverState.status.name());
        if (serverState.status.equals((Object)LambdaDevServerKernel.KernelState.RUNNING)) {
            res.put("port", (Object)serverState.port);
        }
        LambdaDevServerController.writeJSONString((HttpServletResponse)resp, (String)res.toString());
    }
}

