/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibpoi.org.apache.poi.extractor;

import com.dataiku.dss.shadelibpoi.org.apache.poi.extractor.ExtractorFactory;
import com.dataiku.dss.shadelibpoi.org.apache.poi.extractor.ExtractorProvider;
import com.dataiku.dss.shadelibpoi.org.apache.poi.extractor.POITextExtractor;
import com.dataiku.dss.shadelibpoi.org.apache.poi.hssf.extractor.EventBasedExcelExtractor;
import com.dataiku.dss.shadelibpoi.org.apache.poi.hssf.extractor.OldExcelExtractor;
import com.dataiku.dss.shadelibpoi.org.apache.poi.hssf.model.InternalWorkbook;
import com.dataiku.dss.shadelibpoi.org.apache.poi.hssf.record.crypto.Biff8EncryptionKey;
import com.dataiku.dss.shadelibpoi.org.apache.poi.poifs.filesystem.DirectoryNode;
import com.dataiku.dss.shadelibpoi.org.apache.poi.poifs.filesystem.FileMagic;
import com.dataiku.dss.shadelibpoi.org.apache.poi.poifs.filesystem.POIFSFileSystem;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.extractor.ExcelExtractor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class MainExtractorFactory
implements ExtractorProvider {
    @Override
    public boolean accepts(FileMagic fm) {
        return FileMagic.OLE2 == fm;
    }

    @Override
    public POITextExtractor create(File file, String password) throws IOException {
        return this.create(new POIFSFileSystem(file, true).getRoot(), password);
    }

    @Override
    public POITextExtractor create(InputStream inputStream, String password) throws IOException {
        return this.create(new POIFSFileSystem(inputStream).getRoot(), password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public POITextExtractor create(DirectoryNode poifsDir, String password) throws IOException {
        String oldPW = Biff8EncryptionKey.getCurrentUserPassword();
        try {
            Biff8EncryptionKey.setCurrentUserPassword(password);
            if (poifsDir.hasEntry("Book")) {
                OldExcelExtractor oldExcelExtractor = new OldExcelExtractor(poifsDir);
                return oldExcelExtractor;
            }
            for (String workbookName : InternalWorkbook.WORKBOOK_DIR_ENTRY_NAMES_CASE_INSENSITIVE) {
                if (!poifsDir.hasEntryCaseInsensitive(workbookName)) continue;
                ExcelExtractor excelExtractor = ExtractorFactory.getPreferEventExtractor() ? new EventBasedExcelExtractor(poifsDir) : new com.dataiku.dss.shadelibpoi.org.apache.poi.hssf.extractor.ExcelExtractor(poifsDir);
                return excelExtractor;
            }
        }
        finally {
            Biff8EncryptionKey.setCurrentUserPassword(oldPW);
        }
        return null;
    }
}

