/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibpoi.org.apache.poi.hssf.usermodel;

import com.dataiku.dss.shadelibpoi.org.apache.poi.hssf.record.CFRuleBase;
import com.dataiku.dss.shadelibpoi.org.apache.poi.hssf.record.cf.Threshold;
import com.dataiku.dss.shadelibpoi.org.apache.poi.hssf.usermodel.HSSFConditionalFormattingRule;
import com.dataiku.dss.shadelibpoi.org.apache.poi.hssf.usermodel.HSSFSheet;
import com.dataiku.dss.shadelibpoi.org.apache.poi.hssf.usermodel.HSSFWorkbook;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.usermodel.ConditionalFormattingThreshold;

public final class HSSFConditionalFormattingThreshold
implements ConditionalFormattingThreshold {
    private final Threshold threshold;
    private final HSSFSheet sheet;
    private final HSSFWorkbook workbook;

    HSSFConditionalFormattingThreshold(Threshold threshold, HSSFSheet sheet) {
        this.threshold = threshold;
        this.sheet = sheet;
        this.workbook = sheet.getWorkbook();
    }

    Threshold getThreshold() {
        return this.threshold;
    }

    @Override
    public ConditionalFormattingThreshold.RangeType getRangeType() {
        return ConditionalFormattingThreshold.RangeType.byId(this.threshold.getType());
    }

    @Override
    public void setRangeType(ConditionalFormattingThreshold.RangeType type) {
        this.threshold.setType((byte)type.id);
    }

    @Override
    public String getFormula() {
        return HSSFConditionalFormattingRule.toFormulaString(this.threshold.getParsedExpression(), this.workbook);
    }

    @Override
    public void setFormula(String formula) {
        this.threshold.setParsedExpression(CFRuleBase.parseFormula(formula, this.sheet));
    }

    @Override
    public Double getValue() {
        return this.threshold.getValue();
    }

    @Override
    public void setValue(Double value) {
        this.threshold.setValue(value);
    }
}

