/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.crs;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.operation.projection.AzimuthalEquidistant;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.renderer.crs.ProjectionHandler;
import org.geotools.renderer.crs.ProjectionHandlerFactory;
import org.geotools.renderer.crs.ProjectionHandlerFinder;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.densify.Densifier;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.util.PolygonExtracter;
import org.locationtech.jts.simplify.DouglasPeuckerSimplifier;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class AzimulthalEquidistantProjectionHandlerFactory
implements ProjectionHandlerFactory {
    static final Logger LOGGER = Logging.getLogger(AzimulthalEquidistantProjectionHandlerFactory.class);
    static final ReferencedEnvelope AZEQ_VALID_AREA = new ReferencedEnvelope(-2.147483648E9, 2.147483647E9, -90.0, 90.0, DefaultGeographicCRS.WGS84);
    static final double EPS = 0.001;
    static GeometryFactory GF = new GeometryFactory();

    @Override
    public ProjectionHandler getHandler(ReferencedEnvelope renderingEnvelope, CoordinateReferenceSystem sourceCRS, boolean wrap, int wrapLimit) throws FactoryException {
        MapProjection mapProjection = CRS.getMapProjection(renderingEnvelope.getCoordinateReferenceSystem());
        if (renderingEnvelope != null && mapProjection instanceof AzimuthalEquidistant.Abstract) {
            try {
                AzimuthalEquidistantProjectionHandler ph = new AzimuthalEquidistantProjectionHandler(sourceCRS, AZEQ_VALID_AREA, renderingEnvelope);
                return ph;
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Could not create an azimuthal equidistant projection handler, rendering without it", e);
                return null;
            }
        }
        return null;
    }

    private static class AzimuthalEquidistantProjectionHandler
    extends ProjectionHandler {
        Geometry simplifiedDateline;
        Geometry bufferedDateline;
        GeometryFactory gf = new GeometryFactory();
        Polygon renderingGeometry;
        boolean renderingGeometryReduced;
        final Point north;
        final Point south;

        public AzimuthalEquidistantProjectionHandler(CoordinateReferenceSystem sourceCRS, Envelope validAreaBounds, ReferencedEnvelope renderingEnvelope) throws FactoryException, MismatchedDimensionException, TransformException {
            super(sourceCRS, validAreaBounds, renderingEnvelope);
            CoordinateReferenceSystem crs = renderingEnvelope.getCoordinateReferenceSystem();
            Point2D.Double center = this.getCenter(crs);
            this.initializeDatelineCutter(crs, center);
            double radius = this.getRadius(crs, center);
            this.renderingGeometry = JTS.toGeometry(renderingEnvelope);
            if (!this.checkRenderingWithinRadius(center, radius)) {
                this.renderingGeometryReduced = true;
                Polygon azeqProjectedExtents = this.getAzeqProjectedExtents(radius);
                Geometry intersection = this.renderingGeometry.intersection((Geometry)azeqProjectedExtents);
                if (intersection.isEmpty()) {
                    this.renderingGeometry = null;
                } else {
                    List polygons = PolygonExtracter.getPolygons((Geometry)intersection);
                    this.renderingGeometry = (Polygon)polygons.get(0);
                }
            }
            if (this.renderingGeometry != null) {
                Envelope envelope = this.renderingGeometry.getEnvelopeInternal();
                double tolerance = Math.max(envelope.getWidth(), envelope.getHeight()) / 20.0;
                this.renderingGeometry = (Polygon)Densifier.densify((Geometry)this.renderingGeometry, (double)tolerance);
            }
            MathTransform mt = CRS.findMathTransform(DefaultGeographicCRS.WGS84, crs);
            this.north = this.getAzeqPosition(mt, 0.0, 90.0);
            this.south = this.getAzeqPosition(mt, 0.0, -90.0);
        }

        private Point getAzeqPosition(MathTransform mt, double lon, double lat) throws TransformException {
            double[] source = new double[]{lon, lat};
            double[] target = new double[2];
            try {
                mt.transform(source, 0, target, 0, 1);
                return GF.createPoint(new Coordinate(target[0], target[1]));
            }
            catch (TransformException e) {
                LOGGER.log(Level.FINE, "Could not transform lon/lat: " + lon + ", " + lat, e);
                return null;
            }
        }

        private double getRadius(CoordinateReferenceSystem crs, Point2D.Double center) throws TransformException, FactoryException {
            double eps = 0.001;
            double x = center.x > 0.0 ? -180.0 + center.x : 180.0 + center.x;
            double y = -center.y;
            double[] line = new double[]{center.x, center.y, x, y, this.rollLongitude(x - eps), this.validLat(y - eps), this.rollLongitude(x - eps), this.validLat(y + eps), this.rollLongitude(x + eps), this.validLat(y - eps), this.rollLongitude(x + eps), this.validLat(y + eps)};
            CRS.findMathTransform(DefaultGeographicCRS.WGS84, crs).transform(line, 0, line, 0, 6);
            double radius = 0.0;
            for (int i = 1; i <= 5; ++i) {
                double dx = line[i * 2] - line[0];
                double dy = line[i * 2 + 1] - line[1];
                double r = Math.sqrt(dx * dx + dy * dy);
                if (!(r > radius)) continue;
                radius = r;
            }
            return radius;
        }

        private double validLat(double lat) {
            if (lat < -90.0) {
                return -90.0;
            }
            if (lat > 90.0) {
                return 90.0;
            }
            return lat;
        }

        private double rollLongitude(double x) {
            return x - (double)((int)(x + Math.signum(x) * 180.0) / 360) * 360.0;
        }

        private void initializeDatelineCutter(CoordinateReferenceSystem crs, Point2D.Double center) throws TransformException, FactoryException {
            Geometry dateLine = this.getDateLine(center);
            Geometry datelineAzeq = JTS.transform(dateLine, CRS.findMathTransform(DefaultGeographicCRS.WGS84, crs));
            this.simplifiedDateline = DouglasPeuckerSimplifier.simplify((Geometry)datelineAzeq, (double)100.0);
            this.bufferedDateline = this.simplifiedDateline.buffer(100.0, 1, 3);
        }

        @Override
        public List<ReferencedEnvelope> getQueryEnvelopes() throws TransformException, FactoryException {
            if (this.renderingGeometry == null) {
                return Collections.emptyList();
            }
            List<Object> results = new ArrayList();
            if (this.simplifiedDateline.intersects((Geometry)this.renderingGeometry)) {
                Geometry difference = this.renderingGeometry.difference(this.bufferedDateline);
                List polygons = PolygonExtracter.getPolygons((Geometry)difference);
                for (Polygon p : polygons) {
                    Geometry transformed = this.transformGeometry((Geometry)p, this.renderingEnvelope.getCoordinateReferenceSystem(), this.sourceCRS);
                    Envelope envelope = this.getFullEnvelope(transformed);
                    results.add((Object)new ReferencedEnvelope(envelope, this.sourceCRS));
                }
            } else if (this.renderingGeometryReduced) {
                MathTransform mt = CRS.findMathTransform(this.renderingEnvelope.getCoordinateReferenceSystem(), this.sourceCRS);
                Geometry transformed = JTS.transform((Geometry)this.renderingGeometry, mt);
                Envelope envelope = this.getFullEnvelope(transformed);
                ReferencedEnvelope re = new ReferencedEnvelope(envelope, this.sourceCRS);
                results.add((Object)re);
            } else {
                results = super.getQueryEnvelopes();
            }
            results.forEach(e -> {
                this.expandIfIncluded((ReferencedEnvelope)((Object)e), this.north, 0.0, 90.0);
                this.expandIfIncluded((ReferencedEnvelope)((Object)e), this.south, 0.0, -90.0);
            });
            this.mergeEnvelopes(results);
            return results;
        }

        public void expandIfIncluded(ReferencedEnvelope e, Point point, double lon, double lat) {
            if (this.renderingGeometry.contains((Geometry)point)) {
                this.expandToIncludeGeographic(e, lon, lat);
            }
        }

        private Geometry transformGeometry(Geometry g, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS) throws FactoryException, TransformException {
            Geometry transformed = null;
            try {
                transformed = JTS.transform(g, CRS.findMathTransform(sourceCRS, targetCRS));
            }
            catch (TransformException e) {
                Geometry polygonWGS84 = JTS.transform(g, CRS.findMathTransform(this.renderingEnvelope.getCoordinateReferenceSystem(), DefaultGeographicCRS.WGS84));
                ProjectionHandler handler = ProjectionHandlerFinder.getHandler(new ReferencedEnvelope(sourceCRS), DefaultGeographicCRS.WGS84, false);
                if (handler == null) {
                    throw e;
                }
                Geometry preProcessed = handler.preProcess(polygonWGS84);
                transformed = JTS.transform(preProcessed, CRS.findMathTransform(this.renderingEnvelope.getCoordinateReferenceSystem(), sourceCRS));
            }
            return transformed;
        }

        private void expandToIncludeGeographic(ReferencedEnvelope env, double lon, double lat) {
            Point sourcepoint = GF.createPoint(new Coordinate(lon, lat));
            try {
                Point transformed = (Point)this.transformGeometry((Geometry)sourcepoint, DefaultGeographicCRS.WGS84, env.getCoordinateReferenceSystem());
                env.expandToInclude(transformed.getX(), transformed.getY());
            }
            catch (Exception e) {
                LOGGER.log(Level.FINE, "Failed to transform lon/lat point " + lon + ", " + lat + ", might not be a problem per se", e);
            }
        }

        private Envelope getFullEnvelope(Geometry transformed) {
            Envelope envelope = transformed.getEnvelopeInternal();
            transformed.apply(geom -> envelope.expandToInclude(geom.getEnvelopeInternal()));
            return envelope;
        }

        public boolean checkRenderingWithinRadius(Point2D.Double center, double radius) {
            boolean renderingWithinRadius = true;
            double radiusSquared = radius * radius;
            for (int i = 0; i < 4; ++i) {
                double y;
                double x;
                switch (i) {
                    case 0: {
                        x = this.renderingEnvelope.getMinX();
                        y = this.renderingEnvelope.getMinY();
                        break;
                    }
                    case 1: {
                        x = this.renderingEnvelope.getMinX();
                        y = this.renderingEnvelope.getMaxY();
                        break;
                    }
                    case 2: {
                        x = this.renderingEnvelope.getMaxX();
                        y = this.renderingEnvelope.getMinY();
                        break;
                    }
                    case 3: {
                        x = this.renderingEnvelope.getMaxX();
                        y = this.renderingEnvelope.getMaxY();
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                double dx = x - center.x;
                double dy = y - center.y;
                double distanceSquared = dx * dx + dy * dy;
                renderingWithinRadius &= distanceSquared < radiusSquared;
            }
            return renderingWithinRadius;
        }

        private Point2D.Double getCenter(CoordinateReferenceSystem crs) {
            MapProjection mapProjection = CRS.getMapProjection(this.renderingEnvelope.getCoordinateReferenceSystem());
            ParameterValue<?> centralMeridian = this.getParameter(mapProjection, MapProjection.AbstractProvider.CENTRAL_MERIDIAN);
            ParameterValue<?> latitudeOfOrigin = this.getParameter(mapProjection, MapProjection.AbstractProvider.LATITUDE_OF_ORIGIN);
            double centerLon = centralMeridian != null ? centralMeridian.doubleValue() : 0.0;
            double centerLat = latitudeOfOrigin != null ? latitudeOfOrigin.doubleValue() : 0.0;
            return new Point2D.Double(centerLon, centerLat);
        }

        private Geometry getDateLine(Point2D.Double center) {
            if (Math.abs(center.x) < 1.0E-6) {
                LineString ls1 = this.sampleDateLineBetweenLatitudes(this.gf, -90.0, center.y - 1.0E-6);
                LineString ls2 = this.sampleDateLineBetweenLatitudes(this.gf, center.y + 1.0E-6, 90.0);
                MultiLineString mls = this.gf.createMultiLineString(new LineString[]{ls1, ls2});
                return mls;
            }
            LineString ls = this.sampleDateLineBetweenLatitudes(this.gf, -90.0, 90.0);
            return ls;
        }

        private ParameterValue<?> getParameter(MapProjection mapProjection, ParameterDescriptor<?> pd) {
            ParameterValue centralMeridian = null;
            try {
                centralMeridian = mapProjection.getParameterValues().parameter(pd.getName().getCode());
            }
            catch (ParameterNotFoundException parameterNotFoundException) {
                // empty catch block
            }
            return centralMeridian;
        }

        private LineString sampleDateLineBetweenLatitudes(GeometryFactory gf, double start, double end) {
            ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
            for (double lat = start; lat < end; lat += 1.0) {
                coordinates.add(new Coordinate(180.0, lat));
                if (!(lat + 1.0 > end)) continue;
                coordinates.add(new Coordinate(180.0, end));
            }
            Coordinate[] array = coordinates.toArray(new Coordinate[coordinates.size()]);
            LineString ls = gf.createLineString(array);
            return ls;
        }

        public Polygon getAzeqProjectedExtents(double radius) {
            MapProjection mapProjection = CRS.getMapProjection(this.renderingEnvelope.getCoordinateReferenceSystem());
            ParameterValue<?> falseEasting = this.getParameter(mapProjection, MapProjection.AbstractProvider.FALSE_EASTING);
            ParameterValue<?> falseNorthing = this.getParameter(mapProjection, MapProjection.AbstractProvider.FALSE_NORTHING);
            double centerX = falseEasting != null ? falseEasting.doubleValue() : 0.0;
            double centerY = falseNorthing != null ? falseNorthing.doubleValue() : 0.0;
            int POINTS = 180;
            Coordinate[] coordinates = new Coordinate[181];
            double distance = radius - 100.0;
            for (int i = 0; i < 180; ++i) {
                Coordinate c = new Coordinate();
                c.x = centerX + Math.cos(Math.toRadians(2.0 * (double)i)) * distance;
                c.y = centerY + Math.sin(Math.toRadians(2.0 * (double)i)) * distance;
                coordinates[i] = new Coordinate(c.x, c.y);
            }
            coordinates[180] = coordinates[0];
            LinearRing ring = this.gf.createLinearRing(coordinates);
            return this.gf.createPolygon(ring);
        }
    }
}

