/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.sqlengine.aeprocessor.aeoptimizer;

import com.databricks.client.dsi.exceptions.IncorrectTypeException;
import com.databricks.client.dsi.exceptions.NumericOverflowException;
import com.databricks.client.sqlengine.aeprocessor.aemanipulator.AEDeMorgansProcessor;
import com.databricks.client.sqlengine.aeprocessor.aeoptimizer.AEFilterOptimizer;
import com.databricks.client.sqlengine.aeprocessor.aeoptimizer.IAEOptimizer;
import com.databricks.client.sqlengine.aeprocessor.aetree.statement.IAEStatement;
import com.databricks.client.sqlengine.dsiext.dataengine.SqlDataEngine;
import com.databricks.client.sqlengine.dsiext.dataengine.SqlDataEngineContext;
import com.databricks.client.sqlengine.dsiext.dataengine.SqlQueryExecutorContext;
import com.databricks.client.sqlengine.utilities.AEStringLogger;
import com.databricks.client.support.SettingReader;
import com.databricks.client.support.exceptions.ErrorException;
import java.io.File;
import java.io.IOException;
import java.sql.Timestamp;

public class AETreeOptimizer
implements IAEOptimizer {
    private SqlQueryExecutorContext m_executorContext;
    private SqlDataEngineContext m_dataEngineContext;
    private SqlDataEngine m_dataEngine;

    public AETreeOptimizer(SqlQueryExecutorContext sqlQueryExecutorContext) {
        this.m_executorContext = sqlQueryExecutorContext;
        this.m_dataEngineContext = sqlQueryExecutorContext.getDataEngineContext();
        this.m_dataEngine = this.m_dataEngineContext.getDataEngine();
    }

    @Override
    public void optimize(IAEStatement iAEStatement) throws ErrorException {
        if (null == iAEStatement) {
            throw new NullPointerException("statement cannot be null");
        }
        if (this.m_dataEngine.getProperty(3).getString().equals("Y")) {
            String string;
            try {
                if (0L != (this.m_dataEngine.getProperty(4).getLong() & 2L)) {
                    string = SettingReader.readSetting("LogPath");
                    AEStringLogger.logAETree(iAEStatement, new File(string, "AETree.log").getPath(), new Timestamp(System.currentTimeMillis()).toString() + " :: Post-ReOrder ==========================================================");
                }
            }
            catch (IOException iOException) {
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw new AssertionError((Object)incorrectTypeException);
            }
            catch (NumericOverflowException numericOverflowException) {
                throw new AssertionError((Object)numericOverflowException);
            }
            AEDeMorgansProcessor.apply(this.m_dataEngineContext, iAEStatement);
            try {
                if (0L != (this.m_dataEngine.getProperty(4).getLong() & 0x10L)) {
                    string = SettingReader.readSetting("LogPath");
                    AEStringLogger.logAETree(iAEStatement, new File(string, "AETree.log").getPath(), new Timestamp(System.currentTimeMillis()).toString() + " :: Post-DeMorgan's ==========================================================");
                }
            }
            catch (IOException iOException) {
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw new AssertionError((Object)incorrectTypeException);
            }
            catch (NumericOverflowException numericOverflowException) {
                throw new AssertionError((Object)numericOverflowException);
            }
            new AEFilterOptimizer(this.m_dataEngineContext, this.m_executorContext.getPassdownInformation()).optimize(iAEStatement);
            try {
                if (0L != (this.m_dataEngine.getProperty(4).getLong() & 4L)) {
                    string = SettingReader.readSetting("LogPath");
                    AEStringLogger.logAETree(iAEStatement, new File(string, "AETree.log").getPath(), new Timestamp(System.currentTimeMillis()).toString() + " :: Post-Optimize ==========================================================");
                }
            }
            catch (IOException iOException) {
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw new AssertionError((Object)incorrectTypeException);
            }
            catch (NumericOverflowException numericOverflowException) {
                throw new AssertionError((Object)numericOverflowException);
            }
        }
    }
}

