/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.airlift.compress.zstd;

import io.trino.jdbc.$internal.airlift.compress.zstd.UnsafeUtil;
import java.util.Arrays;
import sun.misc.Unsafe;

class Histogram {
    private Histogram() {
    }

    private static void count(Object inputBase, long inputAddress, int inputSize, int[] counts) {
        long input = inputAddress;
        Arrays.fill(counts, 0);
        for (int i = 0; i < inputSize; ++i) {
            int symbol = UnsafeUtil.UNSAFE.getByte(inputBase, input) & 0xFF;
            ++input;
            int n = symbol;
            counts[n] = counts[n] + 1;
        }
    }

    public static int findLargestCount(int[] counts, int maxSymbol) {
        int max = 0;
        for (int i = 0; i <= maxSymbol; ++i) {
            if (counts[i] <= max) continue;
            max = counts[i];
        }
        return max;
    }

    public static int findMaxSymbol(int[] counts, int maxSymbol) {
        while (counts[maxSymbol] == 0) {
            --maxSymbol;
        }
        return maxSymbol;
    }

    public static void count(byte[] input, int length, int[] counts) {
        Histogram.count(input, Unsafe.ARRAY_BYTE_BASE_OFFSET, length, counts);
    }
}

