/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.dynamodbv2.document;

import com.dataiku.dss.legacy.aws.com.amazonaws.services.dynamodbv2.document.KeyAttribute;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.dynamodbv2.document.internal.InternalUtils;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class PrimaryKey {
    private final Map<String, KeyAttribute> components = new LinkedHashMap<String, KeyAttribute>();

    public PrimaryKey() {
    }

    public PrimaryKey(KeyAttribute ... components) {
        this.addComponents(components);
    }

    public PrimaryKey(String hashKeyName, Object hashKeyValue) {
        this.addComponent(hashKeyName, hashKeyValue);
    }

    public PrimaryKey(String hashKeyName, Object hashKeyValue, String rangeKeyName, Object rangeKeyValue) {
        if (hashKeyName.equals(rangeKeyName)) {
            throw new IllegalArgumentException("hashKeyName must not be the same as the rangeKeyName");
        }
        this.addComponent(hashKeyName, hashKeyValue);
        this.addComponent(rangeKeyName, rangeKeyValue);
    }

    public Collection<KeyAttribute> getComponents() {
        return this.components.values();
    }

    public Set<String> getComponentNameSet() {
        return this.components.keySet();
    }

    public boolean hasComponent(String attrName) {
        return this.components.containsKey(attrName);
    }

    public PrimaryKey addComponents(KeyAttribute ... components) {
        if (components != null) {
            for (KeyAttribute ka : components) {
                InternalUtils.rejectNullInput(ka);
                this.components.put(ka.getName(), ka);
            }
        }
        return this;
    }

    public PrimaryKey addComponent(String keyAttributeName, Object keyAttributeValue) {
        this.components.put(keyAttributeName, new KeyAttribute(keyAttributeName, keyAttributeValue));
        return this;
    }

    public String toString() {
        return String.valueOf(this.components);
    }

    public int hashCode() {
        return this.components.hashCode();
    }

    public boolean equals(Object in) {
        if (in instanceof PrimaryKey) {
            PrimaryKey that = (PrimaryKey)in;
            return this.components.equals(that.components);
        }
        return false;
    }
}

