/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.DefaultRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.Request;
import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.http.HttpMethodName;
import com.dataiku.dss.legacy.aws.com.amazonaws.internal.SdkInternalList;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.PurchaseHostReservationRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.Tag;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.TagSpecification;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.Marshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.StringUtils;

public class PurchaseHostReservationRequestMarshaller
implements Marshaller<Request<PurchaseHostReservationRequest>, PurchaseHostReservationRequest> {
    @Override
    public Request<PurchaseHostReservationRequest> marshall(PurchaseHostReservationRequest purchaseHostReservationRequest) {
        SdkInternalList purchaseHostReservationRequestTagSpecificationsList;
        SdkInternalList purchaseHostReservationRequestHostIdSetList;
        if (purchaseHostReservationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<PurchaseHostReservationRequest> request = new DefaultRequest<PurchaseHostReservationRequest>(purchaseHostReservationRequest, "AmazonEC2");
        request.addParameter("Action", "PurchaseHostReservation");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (purchaseHostReservationRequest.getClientToken() != null) {
            request.addParameter("ClientToken", StringUtils.fromString(purchaseHostReservationRequest.getClientToken()));
        }
        if (purchaseHostReservationRequest.getCurrencyCode() != null) {
            request.addParameter("CurrencyCode", StringUtils.fromString(purchaseHostReservationRequest.getCurrencyCode()));
        }
        if (!(purchaseHostReservationRequestHostIdSetList = (SdkInternalList)purchaseHostReservationRequest.getHostIdSet()).isEmpty() || !purchaseHostReservationRequestHostIdSetList.isAutoConstruct()) {
            int hostIdSetListIndex = 1;
            for (String purchaseHostReservationRequestHostIdSetListValue : purchaseHostReservationRequestHostIdSetList) {
                if (purchaseHostReservationRequestHostIdSetListValue != null) {
                    request.addParameter("HostIdSet." + hostIdSetListIndex, StringUtils.fromString(purchaseHostReservationRequestHostIdSetListValue));
                }
                ++hostIdSetListIndex;
            }
        }
        if (purchaseHostReservationRequest.getLimitPrice() != null) {
            request.addParameter("LimitPrice", StringUtils.fromString(purchaseHostReservationRequest.getLimitPrice()));
        }
        if (purchaseHostReservationRequest.getOfferingId() != null) {
            request.addParameter("OfferingId", StringUtils.fromString(purchaseHostReservationRequest.getOfferingId()));
        }
        if (!(purchaseHostReservationRequestTagSpecificationsList = (SdkInternalList)purchaseHostReservationRequest.getTagSpecifications()).isEmpty() || !purchaseHostReservationRequestTagSpecificationsList.isAutoConstruct()) {
            int tagSpecificationsListIndex = 1;
            for (TagSpecification purchaseHostReservationRequestTagSpecificationsListValue : purchaseHostReservationRequestTagSpecificationsList) {
                SdkInternalList tagSpecificationTagsList;
                if (purchaseHostReservationRequestTagSpecificationsListValue.getResourceType() != null) {
                    request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".ResourceType", StringUtils.fromString(purchaseHostReservationRequestTagSpecificationsListValue.getResourceType()));
                }
                if (!(tagSpecificationTagsList = (SdkInternalList)purchaseHostReservationRequestTagSpecificationsListValue.getTags()).isEmpty() || !tagSpecificationTagsList.isAutoConstruct()) {
                    int tagsListIndex = 1;
                    for (Tag tagSpecificationTagsListValue : tagSpecificationTagsList) {
                        if (tagSpecificationTagsListValue.getKey() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Key", StringUtils.fromString(tagSpecificationTagsListValue.getKey()));
                        }
                        if (tagSpecificationTagsListValue.getValue() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Value", StringUtils.fromString(tagSpecificationTagsListValue.getValue()));
                        }
                        ++tagsListIndex;
                    }
                }
                ++tagSpecificationsListIndex;
            }
        }
        return request;
    }
}

