(function() {
    'use strict';
    const app = angular.module('dataiku.recipes');

    app.controller("EmbedDocumentsRecipeCreationController", function($scope, Fn, $stateParams, DataikuAPI, $q,Dialogs, WT1, $controller, RecipeComputablesService, Logger, SmartId, RetrievableKnowledgeUtils, $rootScope) {

        $controller("_RecipeCreationControllerBase", {$scope:$scope});
        $controller("_RecipeOutputNewManagedBehavior", {$scope:$scope});

        $scope.recipeType = "embed_documents";

        $scope.recipeName = {};
        $scope.creationSettings = {
            VLMId : null,
            embeddingLLMId : null,
            vectorStoreType: 'CHROMA',
            connection: null,
            indexName: null,
            pineconeIndexName: null,
            zone: null,
            outputRetrievableKnowledgeName: null
        
        };
        $scope.recipe = {
            type: $scope.recipeType,
            projectKey: $stateParams.projectKey,
            inputs: {
                main: {
                    items: []
                },
                metadata_dataset: {
                    items: []
                }
            },
            
            name: "compute_" + $scope.creationSettings.outputRetrievableKnowledgeName,
        };


        function makeMainRole(refs) {
            return {
                main: {
                    items: refs.filter(function(ref) {return !!ref;}).map(function(ref) { return {ref}; }),
                }
            };
        }
        // Creates the recipe object and sends it to the backend
        $scope.doCreateRecipe = function() {
            // make sure recipe is up to date with latest names:
            $scope.recipe.inputs = $scope.recipe && $scope.recipe.inputs ? $scope.recipe.inputs : makeMainRole([$scope.io.inputFolder]);
            $scope.recipe.name = "compute_" + $scope.creationSettings.outputRetrievableKnowledgeName;
            
            const recipe = angular.copy($scope.recipe);
            const settings = angular.copy($scope.creationSettings);
            if ($scope.zone) {
                settings.zone = $scope.zone;
            }
            return DataikuAPI.flow.recipes.generic.create(recipe, settings);
        };

        $scope.$watchCollection('recipe.inputs.main.items', function (inputs) {
            // when creating the recipe without a preselected folder (+recipe from flow) $scope.io.inputFolder is not set. 
            if (inputs && inputs.length && $scope.computablesMap) {
                const folderId = inputs[0].ref;
                $scope.io.inputFolder = {smartName: folderId, name: $scope.computablesMap[folderId] && $scope.computablesMap[folderId].label};

                DataikuAPI.flow.zones.getZoneId($stateParams.projectKey, {id: folderId, type: "MANAGED_FOLDER", projectKey: $stateParams.projectKey}).success(function(zone) {
                    $scope.zone = zone.id;
                }).error(setErrorInScope.bind($scope));
            }
        })

        $scope.showOutputPane = function() {
            return !!$scope.io.inputFolder;
        };

        $scope.formIsValid = function() { // todo @claire: return formInvalidreason instead?
            const creationSettings = $scope.creationSettings;
            if(!creationSettings.outputRetrievableKnowledgeName){
                return false;
            }

            if(!creationSettings.embeddingLLMId){
                return false;
            }

            if(!creationSettings.vectorStoreType){
                return false;
            }

            if(RetrievableKnowledgeUtils.hasConnection(creationSettings) && !creationSettings.connection){
                return false;
            }

            return !(creationSettings.vectorStoreType === 'PINECONE' && !creationSettings.pineconeIndexName);


        };

        DataikuAPI.pretrainedModels.listAvailableLLMs($stateParams.projectKey, "TEXT_EMBEDDING_EXTRACTION").success(function(data){
            $scope.availableEmbeddingLLMs = data.identifiers;
            if ($scope.availableEmbeddingLLMs.length > 0) {
                $scope.creationSettings.embeddingLLMId = data.identifiers[0].id;
            }
        }).error(setErrorInScope.bind($scope));

        $scope.$on("preselectInputFolder", function(scope, preselectedInputFolder) {
            $scope.io.inputFolder = preselectedInputFolder;
            $scope.preselectedInputFolder = preselectedInputFolder;
        });

        $scope.$watch("io.inputFolder", function(nv) {
            if (!nv) return;

            if (nv.name && !$scope.creationSettings.outputRetrievableKnowledgeName) {
                const niceInputName = nv.name.replace(/[A-Z]*\./, "").replace(/[^\w-_]+/g, "").replaceAll(" ", "_");
                $scope.creationSettings.outputRetrievableKnowledgeName = niceInputName + "_embedded";
                $scope.recipe.name = "compute_" + $scope.creationSettings.outputRetrievableKnowledgeName;
            }
            if ($scope.preselectedInputFolder && $scope.io.inputFolder.smartName != $scope.preselectedInputFolder.smartName){
                $scope.zone = null;
            }
        });

        RecipeComputablesService.getComputablesMap($scope.recipe, $scope).then(function(map) {
            $scope.setComputablesMap(map);
        });
    });

    app.controller("EmbedDocumentsRecipeController", function($scope, $state, $rootScope, $q, $controller, $stateParams, DataikuAPI, RequestCenterService, EmbeddingUtils, 
    DOCUMENT_SPLITTING_METHOD_MAP, EMBED_DOCS_VECTOR_STORE_UPDATE_METHOD_MAP, VECTOR_STORE_TYPE_MAP, DatasetUtils, RecipesUtils, SmartId, WT1, ATSurveyService) {


        $controller("_DocExtractionRecipeControllerBase", {$scope: $scope, UPDATE_METHOD_MAP: EMBED_DOCS_VECTOR_STORE_UPDATE_METHOD_MAP});

        $scope.hasMetadataStep = true;

        DatasetUtils.listDatasetsUsabilityForAny($stateParams.projectKey).success(data => {
            $scope.availableInputDatasets = data;
        }).error(setErrorInScope.bind($scope));

        $scope.shouldClearKnowledgeBank = function() { // not needed but just in case
            return false;
        }

        const recipePayloadSave = $scope.hooks.save;
        $scope.hooks.save = function () {
            return recipePayloadSave().then(() => {
                WT1.event("embed-documents-save");
                ATSurveyService.updateCounter('EmbedDocumentsSave');
            })
        }

        $scope.recipe.inputs["metadata_dataset"] = $scope.recipe.inputs["metadata_dataset"] || {items: []}; // shouldn't be needed?
        $scope.metadataDatasetColumns = undefined; // initialisation is done after loading the input dataset

        $scope.getAllColumnsNames = function() {
            if (!$scope.metadataDatasetColumns) return [];
            return $scope.metadataDatasetColumns.map(column => column.name);
        }

        $scope.getAvailableSecurityColumnsWithEmpty = function() {

            let availableOptions = $scope.getAllColumnsNames(); // todo : should we prevent selecting the path column?
            availableOptions.unshift($scope.RESET_VALUE);
            return availableOptions;
        }

        $scope.removeMetadataDataset = function() {
            $scope.recipe.inputs["metadata_dataset"].items = [];
            $scope.metadataDatasetColumns = [];
            $scope.desc.filePathMetadataColumn = undefined;
            $scope.desc.securityTokensColumn = undefined;
        }

        $scope.getRemainingMetadataColumns = function() {
            if(!$scope.metadataDatasetColumns || $scope.metadataDatasetColumns.length === 0) return [];
            return $scope.metadataDatasetColumns.filter(column => column.name !== $scope.desc.filePathMetadataColumn && column.name !== $scope.desc.securityTokensColumn);
        }

        $scope.updateAllMetadataSelection = function(shouldToggleAllMetadataBoolean) {
            if (shouldToggleAllMetadataBoolean){ // when clicking on the label : we need to update the input value
                $scope.uiState.selectAllMetadataColumns = !$scope.uiState.selectAllMetadataColumns
            }
            $scope.metadataDatasetColumns.forEach(function(col) {
                col.selected = $scope.uiState.selectAllMetadataColumns;
            });
        }

        $scope.onSingleColumnSelectionChange = function() { // update 'all column' boolean if needed.
            let areAllColumnSelected = true;
            $scope.getRemainingMetadataColumns().forEach(function(col) {
                areAllColumnSelected = areAllColumnSelected && col.selected;
            });

            $scope.uiState.selectAllMetadataColumns = areAllColumnSelected;
        }

        $scope.clickedOnColumnName = function(colName) {
            const selectedColumn = $scope.metadataDatasetColumns.filter(col => col.name == colName)[0];
            selectedColumn.selected = !selectedColumn.selected;

            $scope.onSingleColumnSelectionChange();
        }

        $scope.updateRulesSchema = function() {
            let ruleSchema = angular.copy($scope.baseRuleSchema);
            if ($scope.hasMetadataStep && $scope.metadataDatasetColumns && $scope.metadataDatasetColumns.length > 0) {
                $scope.metadataDatasetColumns.forEach(function(col) {
                    ruleSchema.columns.push({
                        "name": col.name,
                        "type": col.type,
                        "$$groupKey": 'Metadata dataset columns'
                    });
                });
            }

            $scope.ruleSchema = ruleSchema;
        }

        $scope.loadDatasetColumnsIfNeeded = function(resetSelection){
            if (!$scope.metadataDatasetRef) {
                $scope.metadataDatasetColumns = [];
                $scope.updateRulesSchema(); 
                return;
            }

            const resolvedRef = SmartId.resolve($scope.metadataDatasetRef, $stateParams.projectKey);
            DataikuAPI.datasets.get(resolvedRef.projectKey, resolvedRef.id, $stateParams.projectKey).then(response => {
                const schema = response.data.schema;

                if (resetSelection){
                    schema.columns.forEach(function(col) {
                        col.selected = true;
                    });
                    $scope.uiState.selectAllMetadataColumns = true;

                    $scope.desc.filePathMetadataColumn = schema.columns.map(col => col.name).indexOf("path") >= 0 ? "path": undefined; // if a column is named "path", select it by default
                    $scope.desc.securityTokensColumn = undefined;
                } else {
                    $scope.desc.filePathMetadataColumn = $scope.desc.filePathMetadataColumn || (schema.columns.map(col => col.name).indexOf("path") >= 0 ? "path": undefined);
                    schema.columns.forEach(function(col) {
                        col.selected = $scope.desc.userDefinedMetadataColumns.map(meta => meta.column).indexOf(col.name) >= 0;
                    });
                }
                $scope.metadataDatasetColumns = schema.columns;
                $scope.updateRulesSchema();
                $scope.onSingleColumnSelectionChange();
            });
        }

        $scope.$watch('recipe.inputs.metadata_dataset.items', function(nv, ov) {
            if (!nv) return;
            $scope.metadataDatasetRef = nv.length? nv[0].ref: undefined;
            let resetSelection;
            if (!$scope.metadataDatasetRef || !ov || ov.length != 1 || $scope.metadataDatasetRef !== ov[0].ref){
                resetSelection = true; // actual dataset change: reset the selection
            }
            else {
                resetSelection = false; // just reloading the page or opening the recipe, retrieve selection from desc
            }
            $scope.loadDatasetColumnsIfNeeded(resetSelection);
        }, true);


        $scope.$watch('metadataDatasetColumns', function(nv, ov) {
            if (!nv) return;
            $scope.desc.userDefinedMetadataColumns = $scope.getRemainingMetadataColumns().filter(column => column.selected).map(column => ({column: column.name}));

        }, true);

        $scope.isMetadataDatasetFilled = function(){
            return $scope.recipe.inputs['metadata_dataset'].items.length > 0;
        }

        $scope.makeDefaultSplittingSettings = function() {
                return {
                "chunkSizeCharacters": $scope.defaultChunkSize,
                "chunkOverlapCharacters": $scope.defaultOverlapSize
            };
        }

    });
 

})();
