(function() {
    'use strict';

    angular.module('dataiku.charts').component('discreteColorMenu', {
        templateUrl: 'static/dataiku/js/simple_report/components/discrete-color-menu/discrete-color-menu.component.html',
        bindings: {
            geoLayer: '<?',
            geoIndex: '<?',
            chartDef: '<',
            legends: '<',
            usableColumns: '<'
        },
        controller: function($scope, $timeout, ChartCustomColors, ChartColorSelection, CHART_TYPES, DKU_PALETTE_NAMES) {
            let subscription;

            const ctrl = this;

            ctrl.getColorOptions = () => {
                return angular.copy(ChartColorSelection.getOptions(ctrl.chartDef, ctrl.geoLayer));
            };

            ctrl.setColorOptions = () => {
                return ChartColorSelection.setOptions(angular.copy(ctrl.colorOptions), ctrl.chartDef, ctrl.geoLayer);
            };

            ctrl.isMeaningPalette = () => {
                return ctrl.colorOptions.colorPalette === DKU_PALETTE_NAMES.MEANING;
            };

            ctrl.isCustomPalette = () => {
                return ctrl.colorOptions.colorPalette === DKU_PALETTE_NAMES.CUSTOM;
            };

            ctrl.$onInit = () => {
                ctrl.colorOptions = ctrl.getColorOptions();
                let geoLayerId;
                if (!_.isNil($scope.geoIndex)) {
                    geoLayerId = `geo-${$scope.geoIndex}`;
                }
                const { id, colorOptions$ } = ChartColorSelection.getOrCreateCustomColorsOptions(geoLayerId);
                ctrl.id = id;

                subscription = colorOptions$.subscribe((newColorOptions) => {
                    ctrl.colorOptions = angular.copy(newColorOptions);
                    ctrl.setColorOptions();
                    $timeout(() => $scope.$apply());
                });

                ChartCustomColors.updateInputColorOptions(id, angular.copy(ctrl.colorOptions));
            };

            ctrl.$onDestroy = () => {
                if (subscription) {
                    subscription.unsubscribe();
                }
                ChartColorSelection.removeCustomColorsOptions([ctrl.id]);
            };

            ctrl.getColorDimensionOrMeasure = () => {
                return ChartColorSelection.getColorDimensionOrMeasure(ctrl.chartDef, ctrl.geoLayer);
            };

            ctrl.onColorOptionsChange = (value) => {
                ChartCustomColors.updateInputColorOptions(ctrl.id, angular.copy(value));
            };

            ctrl.getLegend = (legends, geometryIndex) => {
                const chartDef = ctrl.chartDef;
                if (!legends) {
                    return;
                }
                if (chartDef.type !== CHART_TYPES.GEOMETRY_MAP || (chartDef.geoLayers.length < 3 && geometryIndex === undefined)) {
                    return legends[0];
                } else {
                    return legends[geometryIndex];
                }
            };
        }
    });
})();
