(function() {
    'use strict';

    const app = angular.module('dataiku.charts');

    // (!) This service previously was in static/dataiku/js/simple_report/config_ui.js
    app.factory('ChartColorSelection', function(ChartCustomColors, ChartColorUtils, CHART_TYPES) {
        const customColorsOptions = {
            id: null,
            colorOptions$: null,
            listeners: 0
        };

        const geoLayerCustomColorsOptions = {};

        //TODO: outdated - not needed
        function getGeomMapUaColor(chartDef, geoLayer) {
            if (chartDef.geoLayers.length < 3 && geoLayer === undefined) {
                // if the user selects the color from the left section, retrieve the ua color of the first geo
                return chartDef.geoLayers[0].uaColor;
            } else {
                return geoLayer.uaColor;
            }
        }

        return {
            getOptions: function(chartDef, geoLayer) {
                if (chartDef.type !== CHART_TYPES.GEOMETRY_MAP) {
                    return chartDef.colorOptions;
                } else if (chartDef.geoLayers.length < 3 && geoLayer === undefined) {
                    // if the user selects the color from the left section, retrieve the color options of the first geo
                    return chartDef.geoLayers[0].colorOptions;
                } else {
                    return geoLayer.colorOptions;
                }
            },

            setOptions: function(colorOptions, chartDef, geoLayer) {
                if (chartDef.type !== CHART_TYPES.GEOMETRY_MAP) {
                    chartDef.colorOptions = colorOptions;
                } else if (chartDef.geoLayers.length < 3 && geoLayer === undefined) {
                    // if the user selects the color from the left section, retrieve the color options of the first geo
                    chartDef.geoLayers[0].colorOptions = colorOptions;
                } else {
                    geoLayer.colorOptions = colorOptions;
                }
            },

            getUaColor: function(chartDef, geoLayer) {
                if (chartDef.type !== CHART_TYPES.GEOMETRY_MAP) {
                    return chartDef.uaColor;
                } else {
                    return getGeomMapUaColor(chartDef, geoLayer);
                }
            },

            getColorMeasure: function(chartDef) {
                return chartDef.colorMeasure;
            },

            getColorDimensionOrMeasure: function(chartDef, geoLayer) {
                if (chartDef.type !== CHART_TYPES.GEOMETRY_MAP) {
                    return ChartColorUtils.getColorDimensionOrMeasure(chartDef);
                } else {
                    return getGeomMapUaColor(chartDef, geoLayer)[0];
                }
            },

            getOrCreateCustomColorsOptions(geoLayerId) {
                if (geoLayerId) {
                    if (_.isNil(geoLayerCustomColorsOptions[geoLayerId])) {
                        const { colorOptions$ } = ChartCustomColors.createColorOptions();
                        geoLayerCustomColorsOptions[geoLayerId] = colorOptions$;
                    }

                    return { id: geoLayerId, colorOptions$: geoLayerCustomColorsOptions[geoLayerId] };
                } else {
                    if (_.isNil(customColorsOptions.id)) {
                        const { id, colorOptions$ } = ChartCustomColors.createColorOptions();
                        customColorsOptions.id = id;
                        customColorsOptions.colorOptions$ = colorOptions$;
                    }

                    customColorsOptions.listeners++;

                    return customColorsOptions;
                }
            },

            removeCustomColorsOptions(ids) {
                (ids || []).forEach(id => {
                    if (id.startsWith('geo')) {
                        delete customColorsOptions[id]; // this is prolly wrong, it should be geoLayerCustomColorsOptions[id]
                        ChartCustomColors.removeColorOptions([id]);
                    } else if (customColorsOptions.id === id) {
                        customColorsOptions.listeners--;
                        if (customColorsOptions.listeners === 0) {
                            customColorsOptions.id = null;
                            customColorsOptions.colorOptions$ = null;
                            ChartCustomColors.removeColorOptions([id]);
                        }
                    } else {
                        throw new Error('Ids not found');
                    }
                });
            }
        };
    });
})();
