(function(){
'use strict';

    angular.module("dataiku.nestedFilters").filter("filterNiceRepr", function(Expressions, $sce, translate){

        function reprNestedFilter(input) {
            let mode = translate("JOIN_RECIPE.PRE_FILTER.AND", "AND");
            if (input.uiData.mode === "||") {
                mode = translate("JOIN_RECIPE.PRE_FILTER.OR", "OR");
            }
            let output_str = "";
            for (let i=0; i<input.uiData.conditions.length; i++) {
                let cond = input.uiData.conditions[i];
                let op = Expressions.getOperatorByName(cond["operator"]);
                if ("subCondition" in cond) {
                    if(i>0) {
                        output_str += " " + mode + " "
                    }
                    output_str += "(" + reprNestedFilter(cond["subCondition"]) + ")";
                } else if (!op) {
                    if(i>0) {
                        output_str += " " + mode + " "
                    }
                    output_str += "(unknown OP)";
                } else if (op && op.repr){
                    if(i>0) {
                        output_str += " " + mode + " "
                    }
                    output_str += " (" + op.repr(cond) + ") " ;
                }
            }
            return output_str
        }

        return function(input) {
            function anumLiteral(value) {
                return "<div class='alphanum-literal flex'>" + sanitize(value) + "</div>";
            }
            if (!input || !input.enabled || !input.uiData) return "No filter";

            if (input.uiData.mode === "&&") {
                return $sce.trustAsHtml('<div style="display: inline;">' + reprNestedFilter(input) + "</div>");
            } else if( input.uiData.mode === "||") {
                return $sce.trustAsHtml('<div style="display: inline;">' + reprNestedFilter(input) + "</div>");
            } else if (input.uiData.mode === 'CUSTOM' || input.uiData.$filterOptions === "CUSTOM") {
                return "<div class='noflex'>" + translate("JOIN_RECIPE.PRE_FILTER.FORMULA", "Formula: ") + "</div>" + anumLiteral(input.expression);
            } else if (input.uiData.mode === 'SQL' || input.uiData.$filterOptions === "SQL") {
                return "<div class='noflex'>" + translate("JOIN_RECIPE.PRE_FILTER.SQL", "SQL: ") + "</div>" + anumLiteral(input.expression);
            }
        }
    });
})();
