from dataiku.eda.types import Literal

from dataiku.eda.computations.computation import Computation
from dataiku.eda.computations.context import Context
from dataiku.eda.computations.immutable_data_frame import ImmutableDataFrame
from dataiku.eda.types import DummyComputationModel, DummyComputationResultModel


class DummyComputation(Computation):
    @staticmethod
    def get_type() -> Literal["dummy"]:
        return "dummy"

    @staticmethod
    def build(params: DummyComputationModel) -> 'DummyComputation':
        return DummyComputation()

    def describe(self) -> str:
        return "Dummy"

    def apply(self, idf: ImmutableDataFrame, ctx: Context) -> DummyComputationResultModel:
        return {"type": DummyComputation.get_type()}
