from dataiku.eda.types import Literal

import scipy.stats as sps

from dataiku.eda.computations.computation import UnivariateComputation
from dataiku.eda.computations.context import Context
from dataiku.eda.computations.immutable_data_frame import ImmutableDataFrame
from dataiku.eda.exceptions import NoDataError
from dataiku.eda.types import SemModel, SemResultModel


class Sem(UnivariateComputation):
    @staticmethod
    def get_type() -> Literal["sem"]:
        return "sem"

    @staticmethod
    def build(params: SemModel) -> 'Sem':
        return Sem(params['column'])

    def apply(self, idf: ImmutableDataFrame, ctx: Context) -> SemResultModel:
        series = idf.float_col_no_missing(self.column)

        if len(series) == 0:
            raise NoDataError()

        return {"type": self.get_type(), "value": sps.sem(series)}
