"""
Python implementation of statistical tests for time series analysis in EDA:
Augmented Dickey-Fuller test, Zivot-Andrews test, KPSS test.

Copied for version compatibility & backport of fixes.

Derived from arch==4.8.1 https://github.com/bashtage/arch/tree/4.8.1
- Rewritten imports from arch.* to dataiku.vendor.arch.*
- Removed unused submodules/files (bootstrap, data, tests unitroot, egg-info)
- Included original license from
  https://github.com/bashtage/arch/blob/4.8.1/LICENSE.md

Example import usage:
from dataiku.vendor.arch.unitroot import ADF, ZivotAndrews, KPSS
"""

from dataiku.vendor.arch._version import get_versions
from dataiku.vendor.arch.utility import test

__version__ = get_versions()['version']
del get_versions


def doc():
    import webbrowser
    webbrowser.open('http://arch.readthedocs.org/en/latest/')


__all__ = ['__version__', 'doc', 'test']
