$BINDIR=$env:BINDIR

$env:DIP_HOME=Split-Path -Path $BINDIR -Parent
$env:DKU_LAMBDA_HOME=$DIP_HOME

# Load basic environment
. $BINDIR\env-default.ps1
if ([string]::IsNullOrWhiteSpace($env:DKUINSTALLDIR))
{
	Write-Host "FATAL: DKUINSTALLDIR is not defined. Please check $BINDIR/env-default.ps1"
	exit 1
}
. "$env:DKUINSTALLDIR/scripts/_startup.inc.ps1"

bkdl_set_py_env
bkdl_load_env_files
bkdl_env_sanity_check

# Final environment setup
$env:DKUBIN="$BINDIR/dku"
$env:PYTHONPATH="$env:DIP_HOME/lib/python;$env:DKUINSTALLDIR/python"

Invoke-Expression "$env:DKUPYTHONBIN -m dataiku.dsscli $args"