/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.datalake.store;

import java.util.LinkedList;
import java.util.Queue;

class ProcessingQueue<T> {
    private Queue<T> internalQueue = new LinkedList<T>();
    private int processorCount = 0;

    ProcessingQueue() {
    }

    public synchronized void add(T item) {
        if (item == null) {
            throw new IllegalArgumentException("Cannot put null into queue");
        }
        this.internalQueue.add(item);
        this.notifyAll();
    }

    public synchronized T poll() {
        try {
            while (this.isQueueEmpty() && !this.done()) {
                this.wait();
            }
            if (!this.isQueueEmpty()) {
                ++this.processorCount;
                return this.internalQueue.poll();
            }
            if (this.done()) {
                return null;
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        return null;
    }

    public synchronized void unregister() {
        --this.processorCount;
        if (this.processorCount < 0) {
            throw new IllegalStateException("too many unregister()'s. processorCount is now " + this.processorCount);
        }
        if (this.done()) {
            this.notifyAll();
        }
    }

    private boolean done() {
        return this.processorCount == 0 && this.isQueueEmpty();
    }

    private boolean isQueueEmpty() {
        return this.internalQueue.peek() == null;
    }
}

