/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.auth.oauth2;

import com.google.cloud.hadoop.repackaged.gcs.com.google.auth.oauth2.AccessToken;
import com.google.cloud.hadoop.repackaged.gcs.com.google.auth.oauth2.ExecutableHandler;
import com.google.cloud.hadoop.repackaged.gcs.com.google.auth.oauth2.ExternalAccountCredentials;
import com.google.cloud.hadoop.repackaged.gcs.com.google.auth.oauth2.PluggableAuthCredentialSource;
import com.google.cloud.hadoop.repackaged.gcs.com.google.auth.oauth2.PluggableAuthHandler;
import com.google.cloud.hadoop.repackaged.gcs.com.google.auth.oauth2.StsTokenExchangeRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.annotations.VisibleForTesting;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public class PluggableAuthCredentials
extends ExternalAccountCredentials {
    private final PluggableAuthCredentialSource config;
    private final ExecutableHandler handler;

    PluggableAuthCredentials(Builder builder) {
        super(builder);
        this.config = (PluggableAuthCredentialSource)builder.credentialSource;
        this.handler = builder.handler != null ? builder.handler : new PluggableAuthHandler(this.getEnvironmentProvider());
        this.overrideImpersonatedCredentials(this.buildImpersonatedCredentials());
    }

    @Override
    public AccessToken refreshAccessToken() throws IOException {
        String credential = this.retrieveSubjectToken();
        StsTokenExchangeRequest.Builder stsTokenExchangeRequest = StsTokenExchangeRequest.newBuilder(credential, this.getSubjectTokenType()).setAudience(this.getAudience());
        Collection<String> scopes = this.getScopes();
        if (scopes != null && !scopes.isEmpty()) {
            stsTokenExchangeRequest.setScopes(new ArrayList<String>(scopes));
        }
        return this.exchangeExternalCredentialForAccessToken(stsTokenExchangeRequest.build());
    }

    @Override
    public String retrieveSubjectToken() throws IOException {
        final String executableCommand = this.config.getCommand();
        final String outputFilePath = this.config.getOutputFilePath();
        final int executableTimeoutMs = this.config.getTimeoutMs();
        final HashMap<String, String> envMap = new HashMap<String, String>();
        envMap.put("GOOGLE_EXTERNAL_ACCOUNT_AUDIENCE", this.getAudience());
        envMap.put("GOOGLE_EXTERNAL_ACCOUNT_TOKEN_TYPE", this.getSubjectTokenType());
        envMap.put("GOOGLE_EXTERNAL_ACCOUNT_INTERACTIVE", "0");
        if (this.getServiceAccountEmail() != null) {
            envMap.put("GOOGLE_EXTERNAL_ACCOUNT_IMPERSONATED_EMAIL", this.getServiceAccountEmail());
        }
        if (outputFilePath != null && !outputFilePath.isEmpty()) {
            envMap.put("GOOGLE_EXTERNAL_ACCOUNT_OUTPUT_FILE", outputFilePath);
        }
        ExecutableHandler.ExecutableOptions options = new ExecutableHandler.ExecutableOptions(){

            @Override
            public String getExecutableCommand() {
                return executableCommand;
            }

            @Override
            public Map<String, String> getEnvironmentMap() {
                return envMap;
            }

            @Override
            public int getExecutableTimeoutMs() {
                return executableTimeoutMs;
            }

            @Override
            @Nullable
            public String getOutputFilePath() {
                return outputFilePath;
            }
        };
        return this.handler.retrieveTokenFromExecutable(options);
    }

    @Override
    public PluggableAuthCredentials createScoped(Collection<String> newScopes) {
        return new PluggableAuthCredentials((Builder)PluggableAuthCredentials.newBuilder(this).setScopes(newScopes));
    }

    @Override
    String getCredentialSourceType() {
        return "executable";
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(PluggableAuthCredentials pluggableAuthCredentials) {
        return new Builder(pluggableAuthCredentials);
    }

    @Nullable
    @VisibleForTesting
    ExecutableHandler getExecutableHandler() {
        return this.handler;
    }

    public static class Builder
    extends ExternalAccountCredentials.Builder {
        private ExecutableHandler handler;

        Builder() {
        }

        Builder(PluggableAuthCredentials credentials) {
            super(credentials);
            this.handler = credentials.handler;
        }

        @CanIgnoreReturnValue
        public Builder setExecutableHandler(ExecutableHandler handler) {
            this.handler = handler;
            return this;
        }

        @Override
        public PluggableAuthCredentials build() {
            return new PluggableAuthCredentials(this);
        }
    }
}

