/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage;

import com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.grpc.GrpcStatusCode;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.retrying.ResultRetryAlgorithm;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.rpc.ApiExceptionFactory;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.rpc.StatusCode;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.StorageException;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableList;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableMap;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Status;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

final class GrpcToHttpStatusCodeTranslation {
    private static final ImmutableList<StatusCodeMapping> STATUS_CODE_MAPPINGS = ImmutableList.of(StatusCodeMapping.of(200, Status.Code.OK), StatusCodeMapping.of(400, Status.Code.DATA_LOSS), StatusCodeMapping.of(400, Status.Code.INVALID_ARGUMENT), StatusCodeMapping.of(400, Status.Code.OUT_OF_RANGE), StatusCodeMapping.of(401, Status.Code.UNAUTHENTICATED), StatusCodeMapping.of(403, Status.Code.PERMISSION_DENIED), StatusCodeMapping.of(404, Status.Code.NOT_FOUND), StatusCodeMapping.of(409, Status.Code.ALREADY_EXISTS), StatusCodeMapping.of(412, Status.Code.FAILED_PRECONDITION), StatusCodeMapping.of(429, Status.Code.RESOURCE_EXHAUSTED), StatusCodeMapping.of(500, Status.Code.INTERNAL), StatusCodeMapping.of(501, Status.Code.UNIMPLEMENTED), new StatusCodeMapping[]{StatusCodeMapping.of(503, Status.Code.UNAVAILABLE), StatusCodeMapping.of(504, Status.Code.DEADLINE_EXCEEDED), StatusCodeMapping.of(409, Status.Code.ABORTED), StatusCodeMapping.of(0, Status.Code.CANCELLED), StatusCodeMapping.of(0, Status.Code.UNKNOWN)});
    private static final Map<Status.Code, StatusCodeMapping> GRPC_CODE_INDEX = STATUS_CODE_MAPPINGS.stream().collect(ImmutableMap.toImmutableMap(StatusCodeMapping::getGrpcCode, Function.identity()));
    private static final Set<StorageException> CODE_API_EXCEPTIONS = STATUS_CODE_MAPPINGS.stream().map(StatusCodeMapping::getGrpcStatusCode).map(c -> ApiExceptionFactory.createException(null, c, false)).map(StorageException::asStorageException).collect(Collectors.toSet());

    GrpcToHttpStatusCodeTranslation() {
    }

    static int grpcCodeToHttpStatusCode(Status.Code code) {
        StatusCodeMapping found = GRPC_CODE_INDEX.get((Object)code);
        if (found != null) {
            return found.getHttpStatus();
        }
        return 0;
    }

    static Set<StatusCode.Code> resultRetryAlgorithmToCodes(ResultRetryAlgorithm<?> alg) {
        return CODE_API_EXCEPTIONS.stream().filter(e -> alg.shouldRetry((Throwable)e, null)).map(e -> e.apiExceptionCause.getStatusCode().getCode()).collect(Collectors.toSet());
    }

    private static final class StatusCodeMapping {
        private final int httpStatus;
        private final Status.Code grpcCode;
        private final GrpcStatusCode grpcStatusCode;

        private StatusCodeMapping(int httpStatus, Status.Code grpcCode, GrpcStatusCode grpcStatusCode) {
            this.httpStatus = httpStatus;
            this.grpcCode = grpcCode;
            this.grpcStatusCode = grpcStatusCode;
        }

        public int getHttpStatus() {
            return this.httpStatus;
        }

        public Status.Code getGrpcCode() {
            return this.grpcCode;
        }

        public GrpcStatusCode getGrpcStatusCode() {
            return this.grpcStatusCode;
        }

        static StatusCodeMapping of(int httpStatus, Status.Code grpcCode) {
            return new StatusCodeMapping(httpStatus, grpcCode, GrpcStatusCode.of(grpcCode));
        }
    }
}

