/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.io.grpc.census;

import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Stopwatch;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Supplier;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ClientInterceptor;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Internal;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ServerStreamTracer;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.census.CensusStatsModule;
import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.stats.StatsRecorder;
import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.tags.Tagger;
import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.tags.propagation.TagContextBinarySerializer;

@Internal
public final class InternalCensusStatsAccessor {
    private static final Supplier<Stopwatch> STOPWATCH_SUPPLIER = new Supplier<Stopwatch>(){

        @Override
        public Stopwatch get() {
            return Stopwatch.createUnstarted();
        }
    };

    private InternalCensusStatsAccessor() {
    }

    public static ClientInterceptor getClientInterceptor(boolean recordStartedRpcs, boolean recordFinishedRpcs, boolean recordRealTimeMetrics, boolean recordRetryMetrics) {
        CensusStatsModule censusStats = new CensusStatsModule(STOPWATCH_SUPPLIER, true, recordStartedRpcs, recordFinishedRpcs, recordRealTimeMetrics, recordRetryMetrics);
        return censusStats.getClientInterceptor();
    }

    public static ClientInterceptor getClientInterceptor(Tagger tagger, TagContextBinarySerializer tagCtxSerializer, StatsRecorder statsRecorder, Supplier<Stopwatch> stopwatchSupplier, boolean propagateTags, boolean recordStartedRpcs, boolean recordFinishedRpcs, boolean recordRealTimeMetrics, boolean recordRetryMetrics) {
        CensusStatsModule censusStats = new CensusStatsModule(tagger, tagCtxSerializer, statsRecorder, stopwatchSupplier, propagateTags, recordStartedRpcs, recordFinishedRpcs, recordRealTimeMetrics, recordRetryMetrics);
        return censusStats.getClientInterceptor();
    }

    public static ServerStreamTracer.Factory getServerStreamTracerFactory(boolean recordStartedRpcs, boolean recordFinishedRpcs, boolean recordRealTimeMetrics) {
        CensusStatsModule censusStats = new CensusStatsModule(STOPWATCH_SUPPLIER, true, recordStartedRpcs, recordFinishedRpcs, recordRealTimeMetrics, false);
        return censusStats.getServerTracerFactory();
    }

    public static ServerStreamTracer.Factory getServerStreamTracerFactory(Tagger tagger, TagContextBinarySerializer tagCtxSerializer, StatsRecorder statsRecorder, Supplier<Stopwatch> stopwatchSupplier, boolean propagateTags, boolean recordStartedRpcs, boolean recordFinishedRpcs, boolean recordRealTimeMetrics) {
        CensusStatsModule censusStats = new CensusStatsModule(tagger, tagCtxSerializer, statsRecorder, stopwatchSupplier, propagateTags, recordStartedRpcs, recordFinishedRpcs, recordRealTimeMetrics, false);
        return censusStats.getServerTracerFactory();
    }
}

