/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.io.grpc.rls;

import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.MoreObjects;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.HashMultiset;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.Multiset;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ConnectivityState;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.rls.SubchannelStateManager;
import java.util.HashMap;
import javax.annotation.Nullable;

final class SubchannelStateManagerImpl
implements SubchannelStateManager {
    private final HashMap<String, ConnectivityState> stateMap = new HashMap();
    private final Multiset<ConnectivityState> stateMultiset = HashMultiset.create();
    private ConnectivityState currentState;

    SubchannelStateManagerImpl() {
    }

    @Override
    public void updateState(String name, ConnectivityState newState) {
        ConnectivityState existing;
        Preconditions.checkNotNull(name, "name");
        Preconditions.checkNotNull(newState, "newState");
        if (newState == ConnectivityState.SHUTDOWN) {
            existing = this.stateMap.remove(name);
        } else {
            existing = this.stateMap.put(name, newState);
            this.stateMultiset.add(newState);
        }
        if (existing != null) {
            this.stateMultiset.remove((Object)existing);
        }
    }

    @Override
    @Nullable
    public ConnectivityState getState(String name) {
        return this.stateMap.get(Preconditions.checkNotNull(name, "name"));
    }

    @Override
    public ConnectivityState getAggregatedState() {
        if (this.stateMultiset.contains((Object)ConnectivityState.READY)) {
            this.currentState = ConnectivityState.READY;
        } else if (this.stateMultiset.contains((Object)ConnectivityState.CONNECTING)) {
            if (this.currentState != ConnectivityState.TRANSIENT_FAILURE) {
                this.currentState = ConnectivityState.CONNECTING;
            }
        } else {
            this.currentState = this.stateMultiset.contains((Object)ConnectivityState.IDLE) ? ConnectivityState.IDLE : (this.stateMultiset.contains((Object)ConnectivityState.TRANSIENT_FAILURE) ? ConnectivityState.TRANSIENT_FAILURE : ConnectivityState.IDLE);
        }
        return this.currentState;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("stateMap", this.stateMap).toString();
    }
}

