/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds;

import com.google.auto.value.AutoValue;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableList;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.EquivalentAddressGroup;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.AutoValue_Endpoints_DropOverload;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.AutoValue_Endpoints_LbEndpoint;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.AutoValue_Endpoints_LocalityLbEndpoints;
import java.net.InetSocketAddress;
import java.util.List;

final class Endpoints {
    private Endpoints() {
    }

    @AutoValue
    static abstract class DropOverload {
        DropOverload() {
        }

        abstract String category();

        abstract int dropsPerMillion();

        static DropOverload create(String category, int dropsPerMillion) {
            return new AutoValue_Endpoints_DropOverload(category, dropsPerMillion);
        }
    }

    @AutoValue
    static abstract class LbEndpoint {
        LbEndpoint() {
        }

        abstract EquivalentAddressGroup eag();

        abstract int loadBalancingWeight();

        abstract boolean isHealthy();

        static LbEndpoint create(EquivalentAddressGroup eag, int loadBalancingWeight, boolean isHealthy) {
            return new AutoValue_Endpoints_LbEndpoint(eag, loadBalancingWeight, isHealthy);
        }

        @VisibleForTesting
        static LbEndpoint create(String address, int port, int loadBalancingWeight, boolean isHealthy) {
            return LbEndpoint.create(new EquivalentAddressGroup(new InetSocketAddress(address, port)), loadBalancingWeight, isHealthy);
        }
    }

    @AutoValue
    static abstract class LocalityLbEndpoints {
        LocalityLbEndpoints() {
        }

        abstract ImmutableList<LbEndpoint> endpoints();

        abstract int localityWeight();

        abstract int priority();

        static LocalityLbEndpoints create(List<LbEndpoint> endpoints, int localityWeight, int priority) {
            Preconditions.checkArgument(localityWeight > 0, "localityWeight must be greater than 0");
            return new AutoValue_Endpoints_LocalityLbEndpoints(ImmutableList.copyOf(endpoints), localityWeight, priority);
        }
    }
}

