/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.io.opencensus.implcore.tags;

import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.common.Scope;
import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.implcore.internal.CurrentState;
import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.implcore.internal.NoopScope;
import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.implcore.tags.CurrentTagMapUtils;
import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.implcore.tags.NoopTagMapBuilder;
import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.implcore.tags.TagContextUtils;
import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.implcore.tags.TagMapBuilderImpl;
import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.implcore.tags.TagMapImpl;
import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.tags.InternalUtils;
import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.tags.Tag;
import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.tags.TagContext;
import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.tags.TagContextBuilder;
import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.tags.Tagger;
import java.util.Iterator;

public final class TaggerImpl
extends Tagger {
    private final CurrentState state;

    TaggerImpl(CurrentState state) {
        this.state = state;
    }

    @Override
    public TagMapImpl empty() {
        return TagMapImpl.EMPTY;
    }

    @Override
    public TagMapImpl getCurrentTagContext() {
        return this.state.getInternal() == CurrentState.State.DISABLED ? TagMapImpl.EMPTY : TaggerImpl.toTagMapImpl(CurrentTagMapUtils.getCurrentTagMap());
    }

    @Override
    public TagContextBuilder emptyBuilder() {
        return this.state.getInternal() == CurrentState.State.DISABLED ? NoopTagMapBuilder.INSTANCE : new TagMapBuilderImpl();
    }

    @Override
    public TagContextBuilder currentBuilder() {
        return this.state.getInternal() == CurrentState.State.DISABLED ? NoopTagMapBuilder.INSTANCE : this.toBuilder(CurrentTagMapUtils.getCurrentTagMap());
    }

    @Override
    public TagContextBuilder toBuilder(TagContext tags) {
        return this.state.getInternal() == CurrentState.State.DISABLED ? NoopTagMapBuilder.INSTANCE : TaggerImpl.toTagMapBuilderImpl(tags);
    }

    @Override
    public Scope withTagContext(TagContext tags) {
        return this.state.getInternal() == CurrentState.State.DISABLED ? NoopScope.getInstance() : CurrentTagMapUtils.withTagMap(TaggerImpl.toTagMapImpl(tags));
    }

    private static TagMapImpl toTagMapImpl(TagContext tags) {
        if (tags instanceof TagMapImpl) {
            return (TagMapImpl)tags;
        }
        Iterator<Tag> i = InternalUtils.getTags(tags);
        if (!i.hasNext()) {
            return TagMapImpl.EMPTY;
        }
        TagMapBuilderImpl builder = new TagMapBuilderImpl();
        while (i.hasNext()) {
            Tag tag = i.next();
            if (tag == null) continue;
            TagContextUtils.addTagToBuilder(tag, builder);
        }
        return builder.build();
    }

    private static TagMapBuilderImpl toTagMapBuilderImpl(TagContext tags) {
        if (tags instanceof TagMapImpl) {
            return new TagMapBuilderImpl(((TagMapImpl)tags).getTags());
        }
        TagMapBuilderImpl builder = new TagMapBuilderImpl();
        Iterator<Tag> i = InternalUtils.getTags(tags);
        while (i.hasNext()) {
            Tag tag = i.next();
            if (tag == null) continue;
            TagContextUtils.addTagToBuilder(tag, builder);
        }
        return builder;
    }
}

