/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.spark;

import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.SamplingParam;
import com.dataiku.dip.datasets.fs.HDFSableDatasetHandler;
import com.dataiku.dip.datasets.fs.UploadedFilesDatasetHandler;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.datasets.sql.AbstractSQLTableDatasetHandler;
import com.dataiku.dip.expressions.Expression;
import com.dataiku.dip.expressions.GrelToQueryMapping;
import com.dataiku.dip.expressions.GrelToQueryTranslator;
import com.dataiku.dip.expressions.GrelTranslator;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.input.formats.csv.CSVFormatConfig;
import com.dataiku.dip.partitioning.PartitionFactory;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.spark.FastPathHandler$;
import com.dataiku.dip.spark.FlowDatasetRef;
import com.dataiku.dip.spark.HDFSDatasetRDD$;
import com.dataiku.dip.spark.HadoopFormatsSupport$;
import com.dataiku.dip.spark.SnowflakeFastpathSupport$;
import com.dataiku.dip.spark.StdDataikuSparkContext$;
import com.dataiku.dip.spark.StorageBackendsSupport$;
import com.dataiku.dip.spark.package$;
import com.dataiku.dip.sql.OracleSQLDialect;
import com.dataiku.dip.sql.RedshiftSQLDialect;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SnowflakeSQLDialect;
import com.dataiku.dip.sql.TeradataSQLDialect;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.ExpressionUtils;
import com.dataiku.dip.sql.queries.SimpleSelectQueryBuilder;
import java.io.Serializable;
import org.apache.log4j.Logger;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Set$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\r\rg!\u0002\u001e<\u0003\u0003#\u0005\u0002\u0003*\u0001\u0005+\u0007I\u0011A*\t\u0011}\u0003!\u0011#Q\u0001\nQCQ\u0001\u0019\u0001\u0005\u0002\u0005DQ\u0001\u001d\u0001\u0005\u0002ED\u0011\"!\u0019\u0001#\u0003%\t!a\u0019\t\u0013\u0005e\u0004!%A\u0005\u0002\u0005m\u0004\"CA@\u0001E\u0005I\u0011AA>\u0011%\t\t\tAI\u0001\n\u0003\t\u0019\tC\u0004\u0002\b\u0002!\t!!#\t\u0013\u0005M\u0006!%A\u0005\u0002\u0005\r\u0004\"CA[\u0001E\u0005I\u0011AA>\u0011%\t9\fAI\u0001\n\u0003\tY\bC\u0005\u0002:\u0002\t\n\u0011\"\u0001\u0002\u0004\"9\u00111\u0018\u0001\u0005\u0002\u0005u\u0006\"CAf\u0001E\u0005I\u0011AA2\u0011%\ti\rAI\u0001\n\u0003\tY\bC\u0005\u0002P\u0002\t\n\u0011\"\u0001\u0002|!I\u0011\u0011\u001b\u0001\u0012\u0002\u0013\u0005\u00111\u0011\u0005\b\u0003'\u0004A\u0011AAk\u0011%\t\u0019\u000fAI\u0001\n\u0003\t\u0019\u0007C\u0005\u0002f\u0002\t\n\u0011\"\u0001\u0002|!I\u0011q\u001d\u0001\u0012\u0002\u0013\u0005\u00111\u0010\u0005\n\u0003S\u0004\u0011\u0013!C\u0001\u0003\u0007Cq!a;\u0001\t\u0003\ti\u000fC\u0005\u0003\f\u0001\t\n\u0011\"\u0001\u0002|!I!Q\u0002\u0001\u0012\u0002\u0013\u0005\u00111\u0010\u0005\n\u0005\u001f\u0001\u0011\u0013!C\u0001\u0003\u0007CqA!\u0005\u0001\t\u0003\u0011\u0019\u0002C\u0004\u0003\u0012\u0001!\tAa\t\t\u000f\t\u0015\u0003\u0001\"\u0001\u0003H!9!Q\u000b\u0001\u0005\u0002\t]\u0003b\u0002B#\u0001\u0011\u0005!q\f\u0005\b\u0005c\u0002A\u0011\u0001B:\u0011\u001d\u0011\t\b\u0001C\u0001\u0005\u0003CqA!&\u0001\t\u0003\u00119\nC\u0004\u0003\u0016\u0002!\tA!*\t\u000f\t]\u0006\u0001\"\u0001\u0003:\"9!q\u0019\u0001\u0005\u0002\t%\u0007b\u0002Bn\u0001\u0011\u0005!Q\u001c\u0005\b\u00057\u0004A\u0011\u0001B}\u0011\u001d\u0019y\u0001\u0001C\u0001\u0007#Aqaa\u0004\u0001\t\u0003\u0019\t\u0003C\u0005\u0004B\u0001\t\t\u0011\"\u0011\u0004D!I11\u000b\u0001\u0002\u0002\u0013\u00051Q\u000b\u0005\n\u0007;\u0002\u0011\u0011!C\u0001\u0007?B\u0011b!\u001a\u0001\u0003\u0003%\tea\u001a\t\u0013\rU\u0004!!A\u0005\u0002\r]\u0004\"CB>\u0001\u0005\u0005I\u0011IB?\u0011%\u0019y\bAA\u0001\n\u0003\u001a\t\tC\u0005\u0004\u0004\u0002\t\t\u0011\"\u0011\u0004\u0006\u001e91\u0011R\u001e\t\u0002\r-eA\u0002\u001e<\u0011\u0003\u0019i\t\u0003\u0004ai\u0011\u00051q\u0012\u0005\n\u0007##$\u0019!C\u0001\u0007'C\u0001b!)5A\u0003%1Q\u0013\u0005\n\u0007G#\u0014\u0011!CA\u0007KC\u0011b!/5\u0003\u0003%Iaa/\u0003\u001f\u0019\u000b7\u000f\u001e)bi\"D\u0015M\u001c3mKJT!\u0001P\u001f\u0002\u000bM\u0004\u0018M]6\u000b\u0005yz\u0014a\u00013ja*\u0011\u0001)Q\u0001\bI\u0006$\u0018-[6v\u0015\u0005\u0011\u0015aA2p[\u000e\u0001QCA#g'\u0011\u0001a\tT(\u0011\u0005\u001dSU\"\u0001%\u000b\u0003%\u000bQa]2bY\u0006L!a\u0013%\u0003\r\u0005s\u0017PU3g!\t9U*\u0003\u0002O\u0011\n9\u0001K]8ek\u000e$\bCA$Q\u0013\t\t\u0006J\u0001\u0007TKJL\u0017\r\\5{C\ndW-A\bta\u0006\u00148n\u00142kK\u000e$H+\u001f9f+\u0005!\u0006CA+]\u001d\t1&\f\u0005\u0002X\u00116\t\u0001L\u0003\u0002Z\u0007\u00061AH]8pizJ!a\u0017%\u0002\rA\u0013X\rZ3g\u0013\tifL\u0001\u0004TiJLgn\u001a\u0006\u00037\"\u000b\u0001c\u001d9be.|%M[3diRK\b/\u001a\u0011\u0002\rqJg.\u001b;?)\t\u0011w\u000eE\u0002d\u0001\u0011l\u0011a\u000f\t\u0003K\u001ad\u0001\u0001B\u0003h\u0001\t\u0007\u0001NA\u0001U#\tIG\u000e\u0005\u0002HU&\u00111\u000e\u0013\u0002\b\u001d>$\b.\u001b8h!\t9U.\u0003\u0002o\u0011\n\u0019\u0011I\\=\t\u000bI\u001b\u0001\u0019\u0001+\u0002\u0007\u001d,G\u000fF\u0007s\u0003\u0013\t\u0019#a\r\u0002D\u0005e\u0013Q\f\t\u0005\u000fN$W/\u0003\u0002u\u0011\n1A+\u001e9mKJ\u00022A^A\u0002\u001d\t9xP\u0004\u0002y}:\u0011\u00110 \b\u0003urt!aV>\n\u0003\tK!\u0001Q!\n\u0005yz\u0014B\u0001\u001f>\u0013\r\t\taO\u0001\u000f\r2|w\u000fR1uCN,GOU3g\u0013\u0011\t)!a\u0002\u0003;%s\u0007/\u001e;ECR\f7/\u001a;ECR\fgM]1nKJ+\u0017\rZ'pI\u0016T1!!\u0001<\u0011\u001d\tY\u0001\u0002a\u0001\u0003\u001b\t!b]9m\u0007>tG/\u001a=u!\u0011\ty!a\b\u000e\u0005\u0005E!\u0002BA\n\u0003+\t1a]9m\u0015\ra\u0014q\u0003\u0006\u0005\u00033\tY\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003;\t1a\u001c:h\u0013\u0011\t\t#!\u0005\u0003\u0015M\u000bFjQ8oi\u0016DH\u000fC\u0004\u0002&\u0011\u0001\r!a\n\u0002\u000f\u0011\fG/Y:fiB!\u0011\u0011FA\u0018\u001b\t\tYCC\u0002\u0002.u\n\u0011bY8sK6|G-\u001a7\n\t\u0005E\u00121\u0006\u0002\b\t\u0006$\u0018m]3u\u0011%\t)\u0004\u0002I\u0001\u0002\u0004\t9$\u0001\u0005tC6\u0004H.\u001b8h!\u0011\tI$a\u0010\u000e\u0005\u0005m\"bAA\u001f{\u0005AA-\u0019;bg\u0016$8/\u0003\u0003\u0002B\u0005m\"!D*b[Bd\u0017N\\4QCJ\fW\u000eC\u0005\u0002F\u0011\u0001\n\u00111\u0001\u0002H\u0005Q\u0001/\u0019:uSRLwN\\:\u0011\u000b\u0005%\u00131\u000b+\u000f\t\u0005-\u0013q\n\b\u0004/\u00065\u0013\"A%\n\u0007\u0005E\u0003*A\u0004qC\u000e\\\u0017mZ3\n\t\u0005U\u0013q\u000b\u0002\u0005\u0019&\u001cHOC\u0002\u0002R!C\u0011\"a\u0017\u0005!\u0003\u0005\r!a\u0012\u0002\u0017\r|G.^7o\u001d\u0006lWm\u001d\u0005\t\u0003?\"\u0001\u0013!a\u0001)\u0006\u0001b-\u001b7uKJ,\u0005\u0010\u001d:fgNLwN\\\u0001\u000eO\u0016$H\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005\u0015$\u0006BA\u001c\u0003OZ#!!\u001b\u0011\t\u0005-\u0014QO\u0007\u0003\u0003[RA!a\u001c\u0002r\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003gB\u0015AC1o]>$\u0018\r^5p]&!\u0011qOA7\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000eO\u0016$H\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\u0005u$\u0006BA$\u0003O\nQbZ3uI\u0011,g-Y;mi\u0012*\u0014!D4fi\u0012\"WMZ1vYR$c'\u0006\u0002\u0002\u0006*\u001aA+a\u001a\u0002]\u001d,G\u000fR1uC\u001a\u0013\u0018-\\3Ge>l\u0007\n\u0012$TC\ndWmV5uQ\u001a\u000b7\u000f\u001e)bi\"Le\rU8tg&\u0014G.\u001a\u000b\u0012e\u0006-\u0015QRAH\u0003#\u000b\u0019*!&\u0002\u0018\u0006\u001d\u0006bBA\u0006\u0013\u0001\u0007\u0011Q\u0002\u0005\b\u0003KI\u0001\u0019AA\u0014\u0011%\t)$\u0003I\u0001\u0002\u0004\t9\u0004C\u0005\u0002F%\u0001\n\u00111\u0001\u0002H!I\u00111L\u0005\u0011\u0002\u0003\u0007\u0011q\t\u0005\t\u0003?J\u0001\u0013!a\u0001)\"9\u0011\u0011T\u0005A\u0002\u0005m\u0015AB:dQ\u0016l\u0017\r\u0005\u0003\u0002\u001e\u0006\rVBAAP\u0015\u0011\t\t+!\u0005\u0002\u000bQL\b/Z:\n\t\u0005\u0015\u0016q\u0014\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007bBAU\u0013\u0001\u0007\u00111V\u0001\u000eg\u000eDW-\\1D_2,XN\\:\u0011\r\u0005%\u00131KAW!\u0011\tI#a,\n\t\u0005E\u00161\u0006\u0002\r'\u000eDW-\\1D_2,XN\\\u00019O\u0016$H)\u0019;b\rJ\fW.\u001a$s_6DEIR*bE2,w+\u001b;i\r\u0006\u001cH\u000fU1uQ&3\u0007k\\:tS\ndW\r\n3fM\u0006,H\u000e\u001e\u00134\u0003a:W\r\u001e#bi\u00064%/Y7f\rJ|W\u000e\u0013#G'\u0006\u0014G.Z,ji\"4\u0015m\u001d;QCRD\u0017J\u001a)pgNL'\r\\3%I\u00164\u0017-\u001e7uIQ\n\u0001hZ3u\t\u0006$\u0018M\u0012:b[\u00164%o\\7I\t\u001a\u001b\u0016M\u00197f/&$\bNR1tiB\u000bG\u000f[%g!>\u001c8/\u001b2mK\u0012\"WMZ1vYR$S'\u0001\u001dhKR$\u0015\r^1Ge\u0006lWM\u0012:p[\"#eiU1cY\u0016<\u0016\u000e\u001e5GCN$\b+\u0019;i\u0013\u001a\u0004vn]:jE2,G\u0005Z3gCVdG\u000f\n\u001c\u0002\u0017\u001d,G/Q:SK6|G/\u001a\u000b\u000ee\u0006}\u0016\u0011YAb\u0003\u000b\f9-!3\t\u000f\u0005-a\u00021\u0001\u0002\u000e!9\u0011Q\u0005\bA\u0002\u0005\u001d\u0002\"CA\u001b\u001dA\u0005\t\u0019AA\u001c\u0011%\t)E\u0004I\u0001\u0002\u0004\t9\u0005C\u0005\u0002\\9\u0001\n\u00111\u0001\u0002H!A\u0011q\f\b\u0011\u0002\u0003\u0007A+A\u000bhKR\f5OU3n_R,G\u0005Z3gCVdG\u000fJ\u001a\u0002+\u001d,G/Q:SK6|G/\u001a\u0013eK\u001a\fW\u000f\u001c;%i\u0005)r-\u001a;BgJ+Wn\u001c;fI\u0011,g-Y;mi\u0012*\u0014!F4fi\u0006\u001b(+Z7pi\u0016$C-\u001a4bk2$HEN\u0001\u0011O\u0016$\u0018i\u001d%jm\u0016\u001cXM\u001d<feJ\"RB]Al\u00033\fY.!8\u0002`\u0006\u0005\bbBA\u0006'\u0001\u0007\u0011Q\u0002\u0005\b\u0003K\u0019\u0002\u0019AA\u0014\u0011%\t)d\u0005I\u0001\u0002\u0004\t9\u0004C\u0005\u0002FM\u0001\n\u00111\u0001\u0002H!I\u00111L\n\u0011\u0002\u0003\u0007\u0011q\t\u0005\t\u0003?\u001a\u0002\u0013!a\u0001)\u0006Qr-\u001a;Bg\"Kg/Z:feZ,'O\r\u0013eK\u001a\fW\u000f\u001c;%g\u0005Qr-\u001a;Bg\"Kg/Z:feZ,'O\r\u0013eK\u001a\fW\u000f\u001c;%i\u0005Qr-\u001a;Bg\"Kg/Z:feZ,'O\r\u0013eK\u001a\fW\u000f\u001c;%k\u0005Qr-\u001a;Bg\"Kg/Z:feZ,'O\r\u0013eK\u001a\fW\u000f\u001c;%m\u00059r-\u001a;Bg\"\u000bGm\\8q\rJ|W\u000e\u0013#G'\u0006\u0014G.\u001a\u000b\u0010e\u0006=\u0018\u0011_Az\u0005\u0007\u0011)Aa\u0002\u0003\n!9\u00111\u0002\rA\u0002\u00055\u0001bBA\u00131\u0001\u0007\u0011q\u0005\u0005\b\u0003kD\u0002\u0019AA|\u0003\r!7\u000f\u001b\t\u0005\u0003s\fy0\u0004\u0002\u0002|*!\u0011Q`A\u001e\u0003\t17/\u0003\u0003\u0003\u0002\u0005m(A\u0006%E\rN\u000b'\r\\3ECR\f7/\u001a;IC:$G.\u001a:\t\u000f\u0005U\u0002\u00041\u0001\u00028!I\u00111\f\r\u0011\u0002\u0003\u0007\u0011q\t\u0005\n\u0003\u000bB\u0002\u0013!a\u0001\u0003\u000fB\u0001\"a\u0018\u0019!\u0003\u0005\r\u0001V\u0001\"O\u0016$\u0018i\u001d%bI>|\u0007O\u0012:p[\"#eiU1cY\u0016$C-\u001a4bk2$H%N\u0001\"O\u0016$\u0018i\u001d%bI>|\u0007O\u0012:p[\"#eiU1cY\u0016$C-\u001a4bk2$HEN\u0001\"O\u0016$\u0018i\u001d%bI>|\u0007O\u0012:p[\"#eiU1cY\u0016$C-\u001a4bk2$HeN\u0001\tO\u0016$\u0018i]\"tmRi!O!\u0006\u0003\u0018\tm!Q\u0004B\u0010\u0005CAq!a\u0003\u001d\u0001\u0004\ti\u0001C\u0004\u0003\u001aq\u0001\r!a>\u0002\u000f!\fg\u000e\u001a7fe\"9\u0011Q\t\u000fA\u0002\u0005\u001d\u0003bBAM9\u0001\u0007\u00111\u0014\u0005\b\u0003ka\u0002\u0019AA\u001c\u0011\u001d\tI\u000b\ba\u0001\u0003W#\u0012C\u001dB\u0013\u0005O\u0011ICa\u000b\u0003.\t=\"\u0011\u0007B\u001e\u0011\u001d\tY!\ba\u0001\u0003\u001bAqA!\u0007\u001e\u0001\u0004\t9\u0010C\u0004\u0002Fu\u0001\r!a\u0012\t\u000f\u0005eU\u00041\u0001\u0002\u001c\"9\u0011QG\u000fA\u0002\u0005]\u0002bBAU;\u0001\u0007\u00111\u0016\u0005\b\u0005gi\u0002\u0019\u0001B\u001b\u0003\u001dy\u0007\u000f^5p]N\u0004R!\u0016B\u001c)RK1A!\u000f_\u0005\ri\u0015\r\u001d\u0005\b\u0005{i\u0002\u0019\u0001B \u0003\u0015\u0001\u0018\r\u001e5t!\u0015\tIE!\u0011U\u0013\u0011\u0011\u0019%a\u0016\u0003\u0007M+\u0017/A\u0005hKR\f5OS:p]Ri!O!\u0013\u0003L\t5#q\nB)\u0005'Bq!a\u0003\u001f\u0001\u0004\ti\u0001C\u0004\u0003\u001ay\u0001\r!a>\t\u000f\u0005\u0015c\u00041\u0001\u0002H!9\u0011\u0011\u0014\u0010A\u0002\u0005m\u0005bBA\u001b=\u0001\u0007\u0011q\u0007\u0005\b\u0003Ss\u0002\u0019AAV\u00035\u0019\u0017M\\+o]\u0016\u001cHOS:p]R\u0011!\u0011\f\t\u0004\u000f\nm\u0013b\u0001B/\u0011\n9!i\\8mK\u0006tG#\u0005:\u0003b\t\r$Q\rB4\u0005S\u0012YG!\u001c\u0003p!9\u00111\u0002\u0011A\u0002\u00055\u0001b\u0002B\rA\u0001\u0007\u0011q\u001f\u0005\b\u0003\u000b\u0002\u0003\u0019AA$\u0011\u001d\tI\n\ta\u0001\u00037Cq!!\u000e!\u0001\u0004\t9\u0004C\u0004\u0002*\u0002\u0002\r!a+\t\u000f\tM\u0002\u00051\u0001\u00036!9!Q\b\u0011A\u0002\t}\u0012\u0001D4fi\u0006\u001b\b+\u0019:rk\u0016$H#\u0004:\u0003v\t]$\u0011\u0010B>\u0005{\u0012y\bC\u0004\u0002\f\u0005\u0002\r!!\u0004\t\u000f\te\u0011\u00051\u0001\u0002x\"9\u0011QI\u0011A\u0002\u0005\u001d\u0003bBAMC\u0001\u0007\u00111\u0014\u0005\b\u0003k\t\u0003\u0019AA\u001c\u0011\u001d\tI+\ta\u0001\u0003W#\u0012C\u001dBB\u0005\u000b\u00139I!#\u0003\f\n5%q\u0012BJ\u0011\u001d\tYA\ta\u0001\u0003\u001bAqA!\u0007#\u0001\u0004\t9\u0010C\u0004\u0002F\t\u0002\r!a\u0012\t\u000f\u0005e%\u00051\u0001\u0002\u001c\"9\u0011Q\u0007\u0012A\u0002\u0005]\u0002bBAUE\u0001\u0007\u00111\u0016\u0005\b\u0005#\u0013\u0003\u0019\u0001B-\u0003-IgNZ3s'\u000eDW-\\1\t\u000f\tu\"\u00051\u0001\u0003@\u0005Aq-\u001a;Bg>\u00136\tF\u0007s\u00053\u0013YJ!(\u0003 \n\u0005&1\u0015\u0005\b\u0003\u0017\u0019\u0003\u0019AA\u0007\u0011\u001d\u0011Ib\ta\u0001\u0003oDq!!\u0012$\u0001\u0004\t9\u0005C\u0004\u0002\u001a\u000e\u0002\r!a'\t\u000f\u0005U2\u00051\u0001\u00028!9\u0011\u0011V\u0012A\u0002\u0005-F#\u0005:\u0003(\n%&1\u0016BW\u0005_\u0013\tLa-\u00036\"9\u00111\u0002\u0013A\u0002\u00055\u0001b\u0002B\rI\u0001\u0007\u0011q\u001f\u0005\b\u0003\u000b\"\u0003\u0019AA$\u0011\u001d\tI\n\na\u0001\u00037Cq!!\u000e%\u0001\u0004\t9\u0004C\u0004\u0002*\u0012\u0002\r!a+\t\u000f\tEE\u00051\u0001\u0003Z!9!Q\b\u0013A\u0002\t}\u0012AF4fi\u0006\u001bH)\u001a7uC\u001a\u0013x.\u001c%E\rN\u000b%\r\\3\u0015\u001bI\u0014YL!0\u0003@\n\u0005'1\u0019Bc\u0011\u001d\tY!\na\u0001\u0003\u001bAqA!\u0007&\u0001\u0004\t9\u0010C\u0004\u0002F\u0015\u0002\r!a\u0012\t\u000f\u0005eU\u00051\u0001\u0002\u001c\"9\u0011QG\u0013A\u0002\u0005]\u0002bBAUK\u0001\u0007\u00111V\u0001\u000bO\u0016$\u0018i\u001d#fYR\fGc\u0004:\u0003L\n5'q\u001aBj\u0005+\u00149N!7\t\u000f\u0005-a\u00051\u0001\u0002\u000e!9!\u0011\u0004\u0014A\u0002\u0005]\bB\u0002BiM\u0001\u0007A+\u0001\u0003qCRD\u0007bBA#M\u0001\u0007\u0011q\t\u0005\b\u000333\u0003\u0019AAN\u0011\u001d\t)D\na\u0001\u0003oAq!!+'\u0001\u0004\tY+\u0001\bhKR\f5o\u00158po\u001ad\u0017m[3\u0015\u001fI\u0014yN!9\u0003p\nE(1\u001fB{\u0005oDq!a\u0003(\u0001\u0004\ti\u0001C\u0004\u0003d\u001e\u0002\rA!:\u0002\u001d\u0011\fG/Y:fi\"\u000bg\u000e\u001a7feB!!q\u001dBv\u001b\t\u0011IO\u0003\u0003\u0002\u0014\u0005m\u0012\u0002\u0002Bw\u0005S\u0014a$\u00112tiJ\f7\r^*R\u0019R\u000b'\r\\3ECR\f7/\u001a;IC:$G.\u001a:\t\u000f\u0005eu\u00051\u0001\u0002\u001c\"9\u0011QI\u0014A\u0002\u0005\u001d\u0003bBA\u001bO\u0001\u0007\u0011q\u0007\u0005\b\u0003S;\u0003\u0019AAV\u0011\u0019\tyf\na\u0001)R)\"Oa?\u0003~\n}8\u0011AB\u0002\u0007\u000b\u00199a!\u0003\u0004\f\r5\u0001bBA\u0006Q\u0001\u0007\u0011Q\u0002\u0005\b\u0005GD\u0003\u0019\u0001Bs\u0011\u001d\tI\n\u000ba\u0001\u00037Cq!!\u0012)\u0001\u0004\t9\u0005C\u0004\u00026!\u0002\r!a\u000e\t\u000f\u0005%\u0006\u00061\u0001\u0002,\"1\u0011q\f\u0015A\u0002QCqA!%)\u0001\u0004\u0011I\u0006C\u0004\u00034!\u0002\rA!\u000e\t\r\u0005M\u0001\u00061\u0001U\u0003!9W\r^!t'FcEc\u0004:\u0004\u0014\rU1qCB\r\u00077\u0019iba\b\t\u000f\u0005-\u0011\u00061\u0001\u0002\u000e!9!1]\u0015A\u0002\t\u0015\bbBAMS\u0001\u0007\u00111\u0014\u0005\b\u0003\u000bJ\u0003\u0019AA$\u0011\u001d\t)$\u000ba\u0001\u0003oAq!!+*\u0001\u0004\tY\u000b\u0003\u0004\u0002`%\u0002\r\u0001\u0016\u000b\u001ae\u000e\r2QEB\u0014\u0007S\u0019Yc!\f\u00040\rE21GB\u001c\u0007w\u0019y\u0004C\u0004\u0002\f)\u0002\r!!\u0004\t\u000f\t\r(\u00061\u0001\u0003f\"9\u0011\u0011\u0014\u0016A\u0002\u0005m\u0005bBA#U\u0001\u0007\u0011q\t\u0005\b\u0003kQ\u0003\u0019AA\u001c\u0011\u001d\tIK\u000ba\u0001\u0003WCa!a\u0018+\u0001\u0004!\u0006b\u0002BIU\u0001\u0007!\u0011\f\u0005\u0007\u0007kQ\u0003\u0019\u0001+\u0002\u000f)$'mY+sY\"11\u0011\b\u0016A\u0002Q\u000b!B\u001b3cG\u0012\u0013\u0018N^3s\u0011\u001d\u0019iD\u000ba\u0001\u0005k\t1B\u001b3cG>\u0003H/[8og\"1\u00111\u0003\u0016A\u0002Q\u000bQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAB#!\u0011\u00199e!\u0015\u000e\u0005\r%#\u0002BB&\u0007\u001b\nA\u0001\\1oO*\u00111qJ\u0001\u0005U\u00064\u0018-C\u0002^\u0007\u0013\nA\u0002\u001d:pIV\u001cG/\u0011:jif,\"aa\u0016\u0011\u0007\u001d\u001bI&C\u0002\u0004\\!\u00131!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$2\u0001\\B1\u0011%\u0019\u0019'LA\u0001\u0002\u0004\u00199&A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0007S\u0002Raa\u001b\u0004r1l!a!\u001c\u000b\u0007\r=\u0004*\u0001\u0006d_2dWm\u0019;j_:LAaa\u001d\u0004n\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\u0011If!\u001f\t\u0011\r\rt&!AA\u00021\f\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0007/\n\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0007\u000b\na!Z9vC2\u001cH\u0003\u0002B-\u0007\u000fC\u0001ba\u00193\u0003\u0003\u0005\r\u0001\\\u0001\u0010\r\u0006\u001cH\u000fU1uQ\"\u000bg\u000e\u001a7feB\u00111\rN\n\u0004i\u0019{ECABF\u0003\u0019awnZ4feV\u00111Q\u0013\t\u0005\u0007/\u001bi*\u0004\u0002\u0004\u001a*!11TA\f\u0003\u0015awn\u001a\u001bk\u0013\u0011\u0019yj!'\u0003\r1{wmZ3s\u0003\u001dawnZ4fe\u0002\nq!\u001e8baBd\u00170\u0006\u0003\u0004(\u000e]F\u0003BBU\u0007_\u0003BaRBV)&\u00191Q\u0016%\u0003\r=\u0003H/[8o\u0011%\u0019\t\fOA\u0001\u0002\u0004\u0019\u0019,A\u0002yIA\u0002Ba\u0019\u0001\u00046B\u0019Qma.\u0005\u000b\u001dD$\u0019\u00015\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0007{\u0003Baa\u0012\u0004@&!1\u0011YB%\u0005\u0019y%M[3di\u0002")
public abstract class FastPathHandler<T>
implements Product,
scala.Serializable {
    private final String sparkObjectType;

    public static <T> Option<String> unapply(FastPathHandler<T> fastPathHandler) {
        return FastPathHandler$.MODULE$.unapply(fastPathHandler);
    }

    public static Logger logger() {
        return FastPathHandler$.MODULE$.logger();
    }

    public String sparkObjectType() {
        return this.sparkObjectType;
    }

    public Tuple2<T, FlowDatasetRef.InputDatasetDataframeReadMode> get(SQLContext sqlContext, Dataset dataset, SamplingParam sampling, List<String> partitions, List<String> columnNames, String filterExpression) {
        Schema dsSchema = StdDataikuSparkContext$.MODULE$.datasetStoredSchema(dataset);
        List<SchemaColumn> schemaColumns = package$.MODULE$.getSchemaColumns(dsSchema, columnNames);
        StructType schema = package$.MODULE$.dkuToSpark(schemaColumns);
        String logPrefix = new StringBuilder(6).append("get ").append(dataset.getFullName()).append(": ").toString();
        FastPathHandler$.MODULE$.logger().info((Object)new StringBuilder(31).append(logPrefix).append("Loading dataset as Spark ").append(this.sparkObjectType()).append(" type=").append(dataset.getType()).toString());
        String string = dataset.getType();
        if ("HDFS".equals(string)) {
            Tuple2<Object, String> hdfsAccessibility = StorageBackendsSupport$.MODULE$.isHDFSDatasetCompatible(dataset);
            if (!hdfsAccessibility._1$mcZ$sp()) {
                FastPathHandler$.MODULE$.logger().warn((Object)new StringBuilder(46).append(logPrefix).append("Direct read of HDFS dataset is not supported: ").append(hdfsAccessibility._2()).toString());
                FastPathHandler$.MODULE$.logger().warn((Object)new StringBuilder(70).append(logPrefix).append("Reading HDFS dataset as remote ").append(this.sparkObjectType()).append(". Computation will not be distributed: ").append(hdfsAccessibility._2()).toString());
                return this.getAsRemote(sqlContext, dataset, sampling, partitions, columnNames, filterExpression);
            }
            return this.getDataFrameFromHDFSableWithFastPathIfPossible(sqlContext, dataset, sampling, partitions, columnNames, filterExpression, schema, schemaColumns);
        }
        if ("S3".equals(string)) {
            Tuple2<Object, String> s3Accessibility = StorageBackendsSupport$.MODULE$.isS3DatasetCompatible(dataset, (AuthCtx)DSSAuthCtx.newNone(), false);
            if (!s3Accessibility._1$mcZ$sp()) {
                FastPathHandler$.MODULE$.logger().warn((Object)new StringBuilder(44).append(logPrefix).append("Direct read of S3 dataset is not supported: ").append(s3Accessibility._2()).toString());
                FastPathHandler$.MODULE$.logger().warn((Object)new StringBuilder(68).append(logPrefix).append("Reading S3 dataset as remote ").append(this.sparkObjectType()).append(". Computation will not be distributed: ").append(s3Accessibility._2()).toString());
                return this.getAsRemote(sqlContext, dataset, sampling, partitions, columnNames, filterExpression);
            }
            return this.getDataFrameFromHDFSableWithFastPathIfPossible(sqlContext, dataset, sampling, partitions, columnNames, filterExpression, schema, schemaColumns);
        }
        if ("Azure".equals(string)) {
            Tuple2<Object, String> azureAccessibility = StorageBackendsSupport$.MODULE$.isAzureDatasetCompatible(dataset, (AuthCtx)DSSAuthCtx.newNone(), false);
            if (!azureAccessibility._1$mcZ$sp()) {
                FastPathHandler$.MODULE$.logger().warn((Object)new StringBuilder(47).append(logPrefix).append("Direct read of Azure dataset is not supported: ").append(azureAccessibility._2()).toString());
                FastPathHandler$.MODULE$.logger().warn((Object)new StringBuilder(71).append(logPrefix).append("Reading Azure dataset as remote ").append(this.sparkObjectType()).append(". Computation will not be distributed: ").append(azureAccessibility._2()).toString());
                return this.getAsRemote(sqlContext, dataset, sampling, partitions, columnNames, filterExpression);
            }
            return this.getDataFrameFromHDFSableWithFastPathIfPossible(sqlContext, dataset, sampling, partitions, columnNames, filterExpression, schema, schemaColumns);
        }
        if ("GCS".equals(string)) {
            Tuple2<Object, String> gcsAccessibility = StorageBackendsSupport$.MODULE$.isGCSDatasetCompatible(dataset, (AuthCtx)DSSAuthCtx.newNone(), false);
            if (!gcsAccessibility._1$mcZ$sp()) {
                FastPathHandler$.MODULE$.logger().warn((Object)new StringBuilder(45).append(logPrefix).append("Direct read of GCS dataset is not supported: ").append(gcsAccessibility._2()).toString());
                FastPathHandler$.MODULE$.logger().warn((Object)new StringBuilder(69).append(logPrefix).append("Reading GCS dataset as remote ").append(this.sparkObjectType()).append(". Computation will not be distributed: ").append(gcsAccessibility._2()).toString());
                return this.getAsRemote(sqlContext, dataset, sampling, partitions, columnNames, filterExpression);
            }
            return this.getDataFrameFromHDFSableWithFastPathIfPossible(sqlContext, dataset, sampling, partitions, columnNames, filterExpression, schema, schemaColumns);
        }
        if ("hiveserver2".equals(string)) {
            return this.getAsHiveserver2(sqlContext, dataset, sampling, partitions, columnNames, filterExpression);
        }
        if ("Snowflake".equals(string)) {
            Tuple2<Object, String> snowflakeAccessibility = StorageBackendsSupport$.MODULE$.isSnowflakeReadCompatible(dataset, filterExpression, sampling);
            if (snowflakeAccessibility._1$mcZ$sp()) {
                FastPathHandler$.MODULE$.logger().info((Object)new StringBuilder(30).append(logPrefix).append("Using Snowflake read fast-path").toString());
                AbstractSQLTableDatasetHandler dsh = (AbstractSQLTableDatasetHandler)DatasetHandlerFactory.build((AuthCtx)DSSAuthCtx.newNone(), (Dataset)dataset);
                return this.getAsSnowflake(sqlContext, dsh, schema, partitions, sampling, schemaColumns, filterExpression);
            }
            FastPathHandler$.MODULE$.logger().warn((Object)new StringBuilder(51).append(logPrefix).append("Direct read of Snowflake dataset is not supported: ").append(snowflakeAccessibility._2()).toString());
            FastPathHandler$.MODULE$.logger().warn((Object)new StringBuilder(77).append(logPrefix).append("Reading Snowflake dataset as a remote ").append(this.sparkObjectType()).append(". Computation will not be distributed: ").append(snowflakeAccessibility._2()).toString());
            return this.getAsRemote(sqlContext, dataset, sampling, partitions, columnNames, filterExpression);
        }
        if ("UploadedFiles".equals(string) && StorageBackendsSupport$.MODULE$.isReadDatasetAccessible(dataset)) {
            UploadedFilesDatasetHandler dsh = (UploadedFilesDatasetHandler)DatasetHandlerFactory.build((AuthCtx)DSSAuthCtx.newNone(), (Dataset)dataset);
            Dataset realDataset = dsh.getRealDataset();
            String string2 = realDataset.getType();
            if ("HDFS".equals(string2) ? true : ("S3".equals(string2) ? true : ("GCS".equals(string2) ? true : "Azure".equals(string2)))) {
                return this.get(sqlContext, realDataset, sampling, partitions, columnNames, filterExpression);
            }
            FastPathHandler$.MODULE$.logger().warn((Object)new StringBuilder(137).append(logPrefix).append("Reading uploaded dataset as a remote ").append(this.sparkObjectType()).append(". Computation will not be distributed: Uploaded dataset is not on a compatible cloud storage or HDFS").toString());
            return this.getAsRemote(sqlContext, dataset, sampling, partitions, columnNames, filterExpression);
        }
        if (dataset.getParams() instanceof AbstractSQLDatasetHandler.AbstractSQLConfig) {
            Tuple2<Object, String> sqlAccessibility = StorageBackendsSupport$.MODULE$.isSQLReadCompatible(dataset, filterExpression, sampling);
            if (sqlAccessibility._1$mcZ$sp()) {
                FastPathHandler$.MODULE$.logger().info((Object)new StringBuilder(24).append(logPrefix).append("Using SQL read fast-path").toString());
                AbstractSQLTableDatasetHandler dsh = (AbstractSQLTableDatasetHandler)DatasetHandlerFactory.build((AuthCtx)DSSAuthCtx.newNone(), (Dataset)dataset);
                return this.getAsSQL(sqlContext, dsh, schema, partitions, sampling, schemaColumns, filterExpression);
            }
            FastPathHandler$.MODULE$.logger().warn((Object)new StringBuilder(45).append(logPrefix).append("Direct read of SQL dataset is not supported: ").append(sqlAccessibility._2()).toString());
            FastPathHandler$.MODULE$.logger().warn((Object)new StringBuilder(71).append(logPrefix).append("Reading SQL dataset as a remote ").append(this.sparkObjectType()).append(". Computation will not be distributed: ").append(sqlAccessibility._2()).toString());
            return this.getAsRemote(sqlContext, dataset, sampling, partitions, columnNames, filterExpression);
        }
        FastPathHandler$.MODULE$.logger().warn((Object)new StringBuilder(113).append(logPrefix).append("Reading dataset as a remote ").append(this.sparkObjectType()).append(". Computation will not be distributed: dataset type ").append(dataset.getType()).append(" cannot be read directly in Spark").toString());
        return this.getAsRemote(sqlContext, dataset, sampling, partitions, columnNames, filterExpression);
    }

    public SamplingParam get$default$3() {
        return null;
    }

    public List<String> get$default$4() {
        return null;
    }

    public List<String> get$default$5() {
        return null;
    }

    public String get$default$6() {
        return null;
    }

    public Tuple2<T, FlowDatasetRef.InputDatasetDataframeReadMode> getDataFrameFromHDFSableWithFastPathIfPossible(SQLContext sqlContext, Dataset dataset, SamplingParam sampling, List<String> partitions, List<String> columnNames, String filterExpression, StructType schema, List<SchemaColumn> schemaColumns) {
        String logPrefix = new StringBuilder(18).append("getFromHDFSable ").append(dataset.getFullName()).append(": ").toString();
        if (StdDataikuSparkContext$.MODULE$.isCsvDataset(dataset)) {
            Tuple2<Object, String> csvUsability = HadoopFormatsSupport$.MODULE$.getCsvReadUsability(sqlContext, dataset, sampling, filterExpression, partitions);
            if (csvUsability._1$mcZ$sp()) {
                FastPathHandler$.MODULE$.logger().info((Object)new StringBuilder(24).append(logPrefix).append("Using Csv read fast-path").toString());
                HDFSableDatasetHandler dsh = (HDFSableDatasetHandler)DatasetHandlerFactory.build((AuthCtx)DSSAuthCtx.newNone(), (Dataset)dataset);
                return this.getAsCsv(sqlContext, dsh, partitions, schema, sampling, schemaColumns);
            }
            FastPathHandler$.MODULE$.logger().warn((Object)new StringBuilder(47).append(logPrefix).append("Cannot use Csv read fast-path on Csv-").append(dataset.getType()).append(" dataset: ").append(csvUsability._2()).toString());
        }
        if (StdDataikuSparkContext$.MODULE$.isJsonDataset(dataset)) {
            Tuple2<Object, String> jsonUsability = HadoopFormatsSupport$.MODULE$.getJsonReadUsability(sqlContext, dataset, sampling, filterExpression, partitions, this.canUnnestJson());
            if (jsonUsability._1$mcZ$sp()) {
                FastPathHandler$.MODULE$.logger().info((Object)new StringBuilder(25).append(logPrefix).append("Using Json read fast-path").toString());
                HDFSableDatasetHandler dsh = (HDFSableDatasetHandler)DatasetHandlerFactory.build((AuthCtx)DSSAuthCtx.newNone(), (Dataset)dataset);
                return this.getAsJson(sqlContext, dsh, partitions, schema, sampling, schemaColumns);
            }
            FastPathHandler$.MODULE$.logger().warn((Object)new StringBuilder(49).append(logPrefix).append("Cannot use Json read fast-path on Json-").append(dataset.getType()).append(" dataset: ").append(jsonUsability._2()).toString());
        }
        if (StdDataikuSparkContext$.MODULE$.isParquetDataset(dataset)) {
            Tuple2<Object, String> parquetUsability = HadoopFormatsSupport$.MODULE$.getParquetReadUsability(sqlContext, dataset, sampling, filterExpression, partitions);
            if (parquetUsability._1$mcZ$sp()) {
                FastPathHandler$.MODULE$.logger().info((Object)new StringBuilder(28).append(logPrefix).append("Using Parquet read fast-path").toString());
                HDFSableDatasetHandler dsh = (HDFSableDatasetHandler)DatasetHandlerFactory.build((AuthCtx)DSSAuthCtx.newNone(), (Dataset)dataset);
                return this.getAsParquet(sqlContext, dsh, partitions, schema, sampling, schemaColumns);
            }
            FastPathHandler$.MODULE$.logger().warn((Object)new StringBuilder(55).append(logPrefix).append("Cannot use Parquet read fast-path on Parquet-").append(dataset.getType()).append(" dataset: ").append(parquetUsability._2()).toString());
        }
        if (StdDataikuSparkContext$.MODULE$.isORCDataset(dataset)) {
            Tuple2<Object, String> orcUsability = HadoopFormatsSupport$.MODULE$.getORCReadUsability(sqlContext, dataset, sampling, filterExpression, partitions);
            if (orcUsability._1$mcZ$sp()) {
                FastPathHandler$.MODULE$.logger().info((Object)new StringBuilder(24).append(logPrefix).append("Using ORC read fast-path").toString());
                HDFSableDatasetHandler dsh = (HDFSableDatasetHandler)DatasetHandlerFactory.build((AuthCtx)DSSAuthCtx.newNone(), (Dataset)dataset);
                return this.getAsORC(sqlContext, dsh, partitions, schema, sampling, schemaColumns);
            }
            FastPathHandler$.MODULE$.logger().warn((Object)new StringBuilder(47).append(logPrefix).append("Cannot use ORC read fast-path on ORC-").append(dataset.getType()).append(" dataset: ").append(orcUsability._2()).toString());
        }
        if (StdDataikuSparkContext$.MODULE$.isDeltaDataset(dataset)) {
            Tuple2<Object, String> deltaUsability = HadoopFormatsSupport$.MODULE$.getDeltaReadUsability(sqlContext, dataset, sampling, filterExpression, partitions);
            if (deltaUsability._1$mcZ$sp()) {
                FastPathHandler$.MODULE$.logger().info((Object)new StringBuilder(26).append(logPrefix).append("Using Delta read fast-path").toString());
                HDFSableDatasetHandler dsh = (HDFSableDatasetHandler)DatasetHandlerFactory.build((AuthCtx)DSSAuthCtx.newNone(), (Dataset)dataset);
                return this.getAsDeltaFromHDFSAble(sqlContext, dsh, partitions, schema, sampling, schemaColumns);
            }
            throw new UnsupportedOperationException(new StringBuilder(27).append(logPrefix).append("Cannot read Delta dataset: ").append(deltaUsability._2()).toString());
        }
        Tuple2<Object, String> universalFormatUsability = HadoopFormatsSupport$.MODULE$.getUniversalFormatReadUsability(dataset, sampling);
        if (universalFormatUsability._1$mcZ$sp()) {
            FastPathHandler$.MODULE$.logger().info((Object)new StringBuilder(28).append(logPrefix).append("Using regular Universal read").toString());
            HDFSableDatasetHandler dsh = (HDFSableDatasetHandler)DatasetHandlerFactory.build((AuthCtx)DSSAuthCtx.newNone(), (Dataset)dataset);
            return this.getAsHadoopFromHDFSable(sqlContext, dataset, dsh, sampling, columnNames, partitions, filterExpression);
        }
        FastPathHandler$.MODULE$.logger().warn((Object)new StringBuilder(47).append(logPrefix).append("Cannot use regular Universal read on ").append(dataset.getType()).append(" dataset: ").append(universalFormatUsability._2()).toString());
        FastPathHandler$.MODULE$.logger().warn((Object)new StringBuilder(66).append(logPrefix).append("Reading ").append(dataset.getType()).append(" dataset as remote ").append(this.sparkObjectType()).append(". Computation will not be distributed: ").append(universalFormatUsability._2()).toString());
        return this.getAsRemote(sqlContext, dataset, sampling, partitions, columnNames, filterExpression);
    }

    public SamplingParam getDataFrameFromHDFSableWithFastPathIfPossible$default$3() {
        return null;
    }

    public List<String> getDataFrameFromHDFSableWithFastPathIfPossible$default$4() {
        return null;
    }

    public List<String> getDataFrameFromHDFSableWithFastPathIfPossible$default$5() {
        return null;
    }

    public String getDataFrameFromHDFSableWithFastPathIfPossible$default$6() {
        return null;
    }

    public Tuple2<T, FlowDatasetRef.InputDatasetDataframeReadMode> getAsRemote(SQLContext sqlContext, Dataset dataset, SamplingParam sampling, List<String> partitions, List<String> columnNames, String filterExpression) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public SamplingParam getAsRemote$default$3() {
        return null;
    }

    public List<String> getAsRemote$default$4() {
        return null;
    }

    public List<String> getAsRemote$default$5() {
        return null;
    }

    public String getAsRemote$default$6() {
        return null;
    }

    public Tuple2<T, FlowDatasetRef.InputDatasetDataframeReadMode> getAsHiveserver2(SQLContext sqlContext, Dataset dataset, SamplingParam sampling, List<String> partitions, List<String> columnNames, String filterExpression) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public SamplingParam getAsHiveserver2$default$3() {
        return null;
    }

    public List<String> getAsHiveserver2$default$4() {
        return null;
    }

    public List<String> getAsHiveserver2$default$5() {
        return null;
    }

    public String getAsHiveserver2$default$6() {
        return null;
    }

    public Tuple2<T, FlowDatasetRef.InputDatasetDataframeReadMode> getAsHadoopFromHDFSable(SQLContext sqlContext, Dataset dataset, HDFSableDatasetHandler dsh, SamplingParam sampling, List<String> columnNames, List<String> partitions, String filterExpression) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public List<String> getAsHadoopFromHDFSable$default$5() {
        return null;
    }

    public List<String> getAsHadoopFromHDFSable$default$6() {
        return null;
    }

    public String getAsHadoopFromHDFSable$default$7() {
        return null;
    }

    public Tuple2<T, FlowDatasetRef.InputDatasetDataframeReadMode> getAsCsv(SQLContext sqlContext, HDFSableDatasetHandler handler, List<String> partitions, StructType schema, SamplingParam sampling, List<SchemaColumn> schemaColumns) {
        Seq<String> paths = HDFSDatasetRDD$.MODULE$.listDirectories(handler, partitions);
        FastPathHandler$.MODULE$.logger().info((Object)"read csv using sqlcontext");
        handler.addExtraConf(sqlContext.sparkContext().hadoopConfiguration(), true);
        handler.addExtraConf(package$.MODULE$.getSparkHadoopUtilConf(), true);
        CSVFormatConfig csvFormatConfig = (CSVFormatConfig)handler.getDataset().getFormatParamsAs(CSVFormatConfig.class);
        Map options = Predef$.MODULE$.Map().empty();
        if (csvFormatConfig.charset != null && csvFormatConfig.charset.length() > 0) {
            options = options.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"charset"), (Object)csvFormatConfig.charset));
        }
        if (csvFormatConfig.parseHeaderRow) {
            options = options.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"header"), (Object)"true"));
        }
        options = options.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sep"), (Object)String.valueOf(BoxesRunTime.boxToCharacter((char)csvFormatConfig.getSeparatorChar()))));
        options = options.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"timestampNTZFormat"), (Object)"yyyy-MM-dd HH:mm:ss[.SSS]"));
        CSVFormatConfig.CSVStyle cSVStyle = csvFormatConfig.style;
        if (CSVFormatConfig.CSVStyle.EXCEL.equals(cSVStyle)) {
            options = options.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"quote"), (Object)String.valueOf(BoxesRunTime.boxToCharacter((char)csvFormatConfig.getQuoteChar()))));
            options = options.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"escape"), (Object)String.valueOf(BoxesRunTime.boxToCharacter((char)csvFormatConfig.getQuoteChar()))));
        } else if (CSVFormatConfig.CSVStyle.UNIX.equals(cSVStyle)) {
            options = options.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"quote"), (Object)String.valueOf(BoxesRunTime.boxToCharacter((char)csvFormatConfig.getQuoteChar()))));
            options = options.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"escape"), (Object)String.valueOf(BoxesRunTime.boxToCharacter((char)csvFormatConfig.getEscapeChar()))));
        } else if (CSVFormatConfig.CSVStyle.ESCAPE_ONLY_NO_QUOTE.equals(cSVStyle)) {
            options = options.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"escape"), (Object)String.valueOf(BoxesRunTime.boxToCharacter((char)csvFormatConfig.getEscapeChar()))));
            options = options.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"quoteMode"), (Object)"NONE"));
        } else if (CSVFormatConfig.CSVStyle.NO_ESCAPE_NO_QUOTE.equals(cSVStyle)) {
            options = options.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"quoteMode"), (Object)"NONE"));
            options = options.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"escape"), (Object)""));
        } else {
            throw new MatchError((Object)cSVStyle);
        }
        CSVFormatConfig.DateSerializationFormat dateSerializationFormat = csvFormatConfig.dateSerializationFormat;
        if (CSVFormatConfig.DateSerializationFormat.HIVE.equals(dateSerializationFormat)) {
            options = options.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dateFormat"), (Object)"yyyy-MM-dd"));
        } else if (CSVFormatConfig.DateSerializationFormat.ISO.equals(dateSerializationFormat)) {
            options = options.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dateFormat"), (Object)"yyyy-MM-dd"));
        } else if (CSVFormatConfig.DateSerializationFormat.ISO_STRICT.equals(dateSerializationFormat)) {
            options = options.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dateFormat"), (Object)"yyyy-MM-dd"));
        } else if (CSVFormatConfig.DateSerializationFormat.ISO_FORCED_UTC.equals(dateSerializationFormat)) {
            options = options.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dateFormat"), (Object)"yyyy-MM-dd"));
        } else {
            throw new MatchError((Object)dateSerializationFormat);
        }
        return this.getAsCsv(sqlContext, handler, partitions, schema, sampling, schemaColumns, (Map<String, String>)options, paths);
    }

    public Tuple2<T, FlowDatasetRef.InputDatasetDataframeReadMode> getAsCsv(SQLContext sqlContext, HDFSableDatasetHandler handler, List<String> partitions, StructType schema, SamplingParam sampling, List<SchemaColumn> schemaColumns, Map<String, String> options, Seq<String> paths) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public Tuple2<T, FlowDatasetRef.InputDatasetDataframeReadMode> getAsJson(SQLContext sqlContext, HDFSableDatasetHandler handler, List<String> partitions, StructType schema, SamplingParam sampling, List<SchemaColumn> schemaColumns) {
        Seq<String> paths = HDFSDatasetRDD$.MODULE$.listDirectories(handler, partitions);
        FastPathHandler$.MODULE$.logger().info((Object)"read json using sqlcontext");
        handler.addExtraConf(sqlContext.sparkContext().hadoopConfiguration(), true);
        handler.addExtraConf(package$.MODULE$.getSparkHadoopUtilConf(), true);
        return this.getAsJson(sqlContext, handler, partitions, schema, sampling, schemaColumns, (Map<String, String>)Predef$.MODULE$.Map().empty(), paths);
    }

    public boolean canUnnestJson() {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public Tuple2<T, FlowDatasetRef.InputDatasetDataframeReadMode> getAsJson(SQLContext sqlContext, HDFSableDatasetHandler handler, List<String> partitions, StructType schema, SamplingParam sampling, List<SchemaColumn> schemaColumns, Map<String, String> options, Seq<String> paths) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public Tuple2<T, FlowDatasetRef.InputDatasetDataframeReadMode> getAsParquet(SQLContext sqlContext, HDFSableDatasetHandler handler, List<String> partitions, StructType schema, SamplingParam sampling, List<SchemaColumn> schemaColumns) {
        Seq<String> paths = HDFSDatasetRDD$.MODULE$.listDirectories(handler, partitions);
        FastPathHandler$.MODULE$.logger().info((Object)"read parquet using sqlcontext");
        handler.addExtraConf(sqlContext.sparkContext().hadoopConfiguration(), true);
        handler.addExtraConf(package$.MODULE$.getSparkHadoopUtilConf(), true);
        boolean hasDowncastedTypes = schemaColumns.exists((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)FastPathHandler.$anonfun$getAsParquet$1(c)));
        if (hasDowncastedTypes) {
            FastPathHandler$.MODULE$.logger().info((Object)"Found downcasted types, using native parquet reader with schema inferred by parquet");
        }
        boolean inferSchema = hasDowncastedTypes || StdDataikuSparkContext$.MODULE$.isParquetInputSchemaInferrenceEnabled(sqlContext);
        return this.getAsParquet(sqlContext, handler, partitions, schema, sampling, schemaColumns, inferSchema, paths);
    }

    public Tuple2<T, FlowDatasetRef.InputDatasetDataframeReadMode> getAsParquet(SQLContext sqlContext, HDFSableDatasetHandler handler, List<String> partitions, StructType schema, SamplingParam sampling, List<SchemaColumn> schemaColumns, boolean inferSchema, Seq<String> paths) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public Tuple2<T, FlowDatasetRef.InputDatasetDataframeReadMode> getAsORC(SQLContext sqlContext, HDFSableDatasetHandler handler, List<String> partitions, StructType schema, SamplingParam sampling, List<SchemaColumn> schemaColumns) {
        Seq<String> paths = HDFSDatasetRDD$.MODULE$.listDirectories(handler, partitions);
        FastPathHandler$.MODULE$.logger().info((Object)"read ORC using sqlcontext.");
        handler.addExtraConf(sqlContext.sparkContext().hadoopConfiguration(), true);
        handler.addExtraConf(package$.MODULE$.getSparkHadoopUtilConf(), true);
        boolean hasDowncastedTypes = schemaColumns.exists((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)FastPathHandler.$anonfun$getAsORC$1(c)));
        if (hasDowncastedTypes) {
            FastPathHandler$.MODULE$.logger().info((Object)"Found downcasted types, using native ORC reader with schema inferred by ORC");
        }
        FastPathHandler$.MODULE$.logger().info((Object)new StringBuilder(30).append("Accessing dataframe as ORC to ").append(paths.mkString(",")).toString());
        boolean inferSchema = hasDowncastedTypes || StdDataikuSparkContext$.MODULE$.isORCInputSchemaInferrenceEnabled(sqlContext);
        return this.getAsORC(sqlContext, handler, partitions, schema, sampling, schemaColumns, inferSchema, paths);
    }

    public Tuple2<T, FlowDatasetRef.InputDatasetDataframeReadMode> getAsORC(SQLContext sqlContext, HDFSableDatasetHandler handler, List<String> partitions, StructType schema, SamplingParam sampling, List<SchemaColumn> schemaColumns, boolean inferSchema, Seq<String> paths) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public Tuple2<T, FlowDatasetRef.InputDatasetDataframeReadMode> getAsDeltaFromHDFSAble(SQLContext sqlContext, HDFSableDatasetHandler handler, List<String> partitions, StructType schema, SamplingParam sampling, List<SchemaColumn> schemaColumns) {
        String path = handler.getFullyQualifiedRootPath();
        FastPathHandler$.MODULE$.logger().info((Object)"read Delta using sqlcontext.");
        handler.addExtraConf(sqlContext.sparkContext().hadoopConfiguration(), true);
        handler.addExtraConf(package$.MODULE$.getSparkHadoopUtilConf(), true);
        return this.getAsDelta(sqlContext, handler, path, partitions, schema, sampling, schemaColumns);
    }

    public Tuple2<T, FlowDatasetRef.InputDatasetDataframeReadMode> getAsDelta(SQLContext sqlContext, HDFSableDatasetHandler handler, String path, List<String> partitions, StructType schema, SamplingParam sampling, List<SchemaColumn> schemaColumns) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public Tuple2<T, FlowDatasetRef.InputDatasetDataframeReadMode> getAsSnowflake(SQLContext sqlContext, AbstractSQLTableDatasetHandler datasetHandler, StructType schema, List<String> partitions, SamplingParam sampling, List<SchemaColumn> schemaColumns, String filterExpression) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        Dataset dataset = datasetHandler.getDataset();
        SimpleSelectQueryBuilder query = SimpleSelectQueryBuilder.selectAll().from(datasetHandler.getResolvedTable(), datasetHandler.getResolvedTable().getTable());
        if (filterExpression != null) {
            GrelToQueryTranslator translator = new GrelToQueryTranslator((GrelTranslator.GrelMapping)new GrelToQueryMapping((SQLDialect)new SnowflakeSQLDialect()));
            Expression expression = new Expression(filterExpression, datasetHandler.getDataset().getSchema());
            ExpressionBuilder value = (ExpressionBuilder)translator.translateToQuery((Expression)expression, (boolean)true).result;
            boxedUnit2 = query.where(value);
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        if (partitions != null) {
            PartitioningScheme partitioningScheme = dataset.getPartitioningSchema();
            java.util.List sourcePartitions = PartitionFactory.fromPartitionSpec((PartitioningScheme)partitioningScheme, (String)partitions.mkString(","));
            boxedUnit = query.where(ExpressionUtils.getPartitionFilterClause((PartitioningScheme)partitioningScheme, (Dataset)dataset, (java.util.List)sourcePartitions, (SQLDialect)new SnowflakeSQLDialect()));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        boolean hasDowncastedTypes = schemaColumns.exists((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)FastPathHandler.$anonfun$getAsSnowflake$1(c)));
        if (hasDowncastedTypes) {
            FastPathHandler$.MODULE$.logger().info((Object)"Found downcasted types, using native Snowflake reader with schema inferred by Snowflake");
        }
        Map<String, String> options = SnowflakeFastpathSupport$.MODULE$.getConnectionOptions(datasetHandler.getConnectionName(), datasetHandler.getResolvedTable().getCatalog(), datasetHandler.getResolvedTable().getSchemaNullIfBlank(), dataset.getProjectKey());
        String sql = query.toSQL((SQLDialect)SnowflakeFastpathSupport$.MODULE$.SnowflakeSqlDialect());
        boolean inferSchema = hasDowncastedTypes || StdDataikuSparkContext$.MODULE$.isSnowflakeInputSchemaInferrenceEnabled(sqlContext);
        return this.getAsSnowflake(sqlContext, datasetHandler, schema, partitions, sampling, schemaColumns, filterExpression, inferSchema, options, sql);
    }

    public Tuple2<T, FlowDatasetRef.InputDatasetDataframeReadMode> getAsSnowflake(SQLContext sqlContext, AbstractSQLTableDatasetHandler datasetHandler, StructType schema, List<String> partitions, SamplingParam sampling, List<SchemaColumn> schemaColumns, String filterExpression, boolean inferSchema, Map<String, String> options, String sql) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public Tuple2<T, FlowDatasetRef.InputDatasetDataframeReadMode> getAsSQL(SQLContext sqlContext, AbstractSQLTableDatasetHandler datasetHandler, StructType schema, List<String> partitions, SamplingParam sampling, List<SchemaColumn> schemaColumns, String filterExpression) {
        Map map;
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        StructType schemaFixedUp;
        Dataset dataset = datasetHandler.getDataset();
        SQLConnectionProvider.SQLConnectionData connData = datasetHandler.getConnectionData();
        SQLDialect dialect = connData.getDialect();
        SimpleSelectQueryBuilder query = SimpleSelectQueryBuilder.select().from(datasetHandler.getResolvedTable(), datasetHandler.getResolvedTable().getTable());
        schemaColumns.foreach((Function1 & Serializable & scala.Serializable)sc -> query.column(sc.getName()));
        StructType structType = dialect instanceof RedshiftSQLDialect ? new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).map((Function1 & Serializable & scala.Serializable)f -> new StructField(f.name().toLowerCase(), f.dataType(), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)))) : (dialect instanceof OracleSQLDialect ? new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).map((Function1 & Serializable & scala.Serializable)f -> {
            DataType dataType = f.dataType();
            if (LongType$.MODULE$.equals(dataType)) {
                return new StructField(f.name(), (DataType)new DecimalType(38, 0), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            }
            return f;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)))) : (schemaFixedUp = dialect instanceof TeradataSQLDialect ? new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).map((Function1 & Serializable & scala.Serializable)f -> {
            DataType dataType = f.dataType();
            if (DoubleType$.MODULE$.equals(dataType)) {
                return new StructField(f.name(), (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            }
            return f;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)))) : schema));
        if (filterExpression != null) {
            GrelToQueryTranslator translator = new GrelToQueryTranslator((GrelTranslator.GrelMapping)new GrelToQueryMapping(dialect));
            Expression expression = new Expression(filterExpression, datasetHandler.getDataset().getSchema());
            ExpressionBuilder value = (ExpressionBuilder)translator.translateToQuery((Expression)expression, (boolean)true).result;
            boxedUnit2 = query.where(value);
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        if (partitions != null) {
            PartitioningScheme partitioningScheme = dataset.getPartitioningSchema();
            java.util.List sourcePartitions = PartitionFactory.fromPartitionSpec((PartitioningScheme)partitioningScheme, (String)partitions.mkString(","));
            boxedUnit = query.where(ExpressionUtils.getPartitionFilterClause((PartitioningScheme)partitioningScheme, (Dataset)dataset, (java.util.List)sourcePartitions, (SQLDialect)dialect));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        boolean hasDowncastedTypes = schemaColumns.exists((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)FastPathHandler.$anonfun$getAsSQL$5(c)));
        if (hasDowncastedTypes) {
            FastPathHandler$.MODULE$.logger().info((Object)"Found downcasted types, using native SQL reader with schema inferred by Spark");
        }
        SQLConnectionProvider.SparkJDBCInfo connectionInfo = connData.getSparkConnectionInfo(datasetHandler.getAuthCtx(), dataset.getProjectKey());
        String sql = new StringBuilder(6).append("(").append(query.toSQL(dialect)).append(") tbl").toString();
        boolean inferSchema = hasDowncastedTypes || StdDataikuSparkContext$.MODULE$.isSQLInputSchemaInferrenceEnabled(sqlContext, dataset.getParams().getConnection());
        Map connectionOptions = ((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(connectionInfo.properties.stringPropertyNames()).asScala()).map((Function1 & Serializable & scala.Serializable)n -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)n.toString()), (Object)connectionInfo$1.properties.getProperty((String)n).toString()), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        scala.collection.mutable.Map datasetOptions = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(datasetHandler.getSparkConnectionInfo()).asScala();
        Map allOptions = ((TraversableOnce)connectionOptions.toSeq().$plus$plus((GenTraversableOnce)datasetOptions.toSet(), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        if (new StringOps(Predef$.MODULE$.augmentString((String)allOptions.getOrElse((Object)"numPartitions", (Function0 & Serializable & scala.Serializable)() -> "0"))).toInt() < 0) {
            int numExecutors = new StringOps(Predef$.MODULE$.augmentString(sqlContext.sparkContext().getConf().get("spark.executor.instances", "1"))).toInt();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numPartitions"), (Object)Integer.toString(numExecutors));
            map = ((TraversableOnce)((MapLike)allOptions.filter((Function1 & Serializable & scala.Serializable)kv -> BoxesRunTime.boxToBoolean((boolean)FastPathHandler.$anonfun$getAsSQL$8(kv)))).toSeq().$plus$plus((GenTraversableOnce)Nil$.MODULE$.$colon$colon((Object)tuple2), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        } else {
            map = allOptions;
        }
        Map allOptionsWithNumPartitions = map;
        FastPathHandler$.MODULE$.logger().info((Object)new StringBuilder(43).append("Read in ").append(allOptionsWithNumPartitions.getOrElse((Object)"numPartitions", (Function0 & Serializable & scala.Serializable)() -> "N/A")).append(" partitions with schema ").append(schema).append(" and sql : ").append(sql).toString());
        return this.getAsSQL(sqlContext, datasetHandler, schemaFixedUp, partitions, sampling, schemaColumns, filterExpression, inferSchema, connectionInfo.url, connectionInfo.driver, (Map<String, String>)allOptionsWithNumPartitions, sql);
    }

    public Tuple2<T, FlowDatasetRef.InputDatasetDataframeReadMode> getAsSQL(SQLContext sqlContext, AbstractSQLTableDatasetHandler datasetHandler, StructType schema, List<String> partitions, SamplingParam sampling, List<SchemaColumn> schemaColumns, String filterExpression, boolean inferSchema, String jdbcUrl, String jdbcDriver, Map<String, String> jdbcOptions, String sql) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public String productPrefix() {
        return "FastPathHandler";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.sparkObjectType();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof FastPathHandler;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof FastPathHandler)) return false;
        boolean bl = true;
        if (!bl) return false;
        FastPathHandler fastPathHandler = (FastPathHandler)x$1;
        String string = this.sparkObjectType();
        String string2 = fastPathHandler.sparkObjectType();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (!fastPathHandler.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$getAsParquet$1(SchemaColumn c) {
        return c.originalType != null;
    }

    public static final /* synthetic */ boolean $anonfun$getAsORC$1(SchemaColumn c) {
        return c.originalType != null;
    }

    public static final /* synthetic */ boolean $anonfun$getAsSnowflake$1(SchemaColumn c) {
        return c.originalType != null;
    }

    public static final /* synthetic */ boolean $anonfun$getAsSQL$5(SchemaColumn c) {
        return c.originalType != null;
    }

    public static final /* synthetic */ boolean $anonfun$getAsSQL$8(Tuple2 kv) {
        return !"numPartitions".equals(kv._1());
    }

    public FastPathHandler(String sparkObjectType) {
        this.sparkObjectType = sparkObjectType;
        Product.$init$((Product)this);
    }
}

