/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.spark.ml.prediction;

import com.dataiku.dip.analysis.model.prediction.PreTrainPredictionModelingParams;
import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.dataiku.dip.analysis.model.prediction.ResolvedClassicalPredictionCoreParams;
import com.dataiku.dip.analysis.model.prediction.ResolvedPredictionPreprocessingParams;
import com.dataiku.dip.spark.MLLibJob$;
import com.dataiku.dip.spark.ml.HasCategoricalFeatures;
import com.dataiku.dip.spark.ml.HasLabelCol;
import com.dataiku.dip.spark.ml.Util$;
import com.dataiku.dip.spark.ml.prediction.H2ODeepLearningProbabilistic;
import com.dataiku.dip.spark.ml.prediction.H2ODeepLearningRegressor;
import com.dataiku.dip.spark.ml.prediction.H2OGLMProbabilistic;
import com.dataiku.dip.spark.ml.prediction.H2OGLMRegressor;
import com.dataiku.dip.spark.ml.prediction.H2OGradientBoostingProbabilistic;
import com.dataiku.dip.spark.ml.prediction.H2OGradientBoostingRegressor;
import com.dataiku.dip.spark.ml.prediction.H2ONaiveBayesProbabilistic;
import com.dataiku.dip.spark.ml.prediction.H2ORandomForestProbabilistic;
import com.dataiku.dip.spark.ml.prediction.H2ORandomForestRegressor;
import com.dataiku.dip.spark.ml.prediction.ParameterResolution$;
import com.dataiku.dip.spark.ml.prediction.ensembles.Ensemble;
import com.dataiku.dip.spark.ml.prediction.ensembles.Ensemble$;
import java.io.Serializable;
import org.apache.spark.ml.Estimator;
import scala.Function1;
import scala.MatchError;
import scala.collection.IndexedSeq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.runtime.Nothing$;

public final class Predictors$ {
    public static Predictors$ MODULE$;

    static {
        new Predictors$();
    }

    public List<Estimator<?>> getRegressionPredictors(ResolvedClassicalPredictionCoreParams coreParams, PreTrainPredictionModelingParams modelingParams, ResolvedPredictionPreprocessingParams prepParams, IndexedSeq<String> categoricalFeatures) {
        String target = coreParams.target_variable;
        PreTrainPredictionModelingParams.Algorithm algorithm = modelingParams.algorithm;
        Ensemble temp = PreTrainPredictionModelingParams.Algorithm.MLLIB_CUSTOM.equals(algorithm) ? MLLibJob$.MODULE$.getCustomEstimator(modelingParams.custom_mllib_grid.initializationCode) : (PreTrainPredictionModelingParams.Algorithm.SPARK_ENSEMBLE.equals(algorithm) ? new Ensemble(modelingParams.ensemble_params, coreParams, prepParams, Ensemble$.MODULE$.$lessinit$greater$default$4()) : (PreTrainPredictionModelingParams.Algorithm.SPARKLING_DEEP_LEARNING.equals(algorithm) ? ((HasCategoricalFeatures)((Object)((HasLabelCol)((Object)new H2ODeepLearningRegressor().setDeepLearningParameters(modelingParams.deep_learning_sparkling_grid).setFeaturesCol(Util$.MODULE$.FEATURES_COLUMN()))).setLabelCol(target))).setCategoricalFeaturesCols(categoricalFeatures) : (PreTrainPredictionModelingParams.Algorithm.SPARKLING_GBM.equals(algorithm) ? ((HasCategoricalFeatures)((Object)((HasLabelCol)((Object)new H2OGradientBoostingRegressor().setParams(modelingParams.gbm_sparkling_grid).setFeaturesCol(Util$.MODULE$.FEATURES_COLUMN()))).setLabelCol(target))).setCategoricalFeaturesCols(categoricalFeatures) : (PreTrainPredictionModelingParams.Algorithm.SPARKLING_GLM.equals(algorithm) ? ((HasCategoricalFeatures)((Object)((HasLabelCol)((Object)new H2OGLMRegressor().setParams(modelingParams.glm_sparkling_grid).setFeaturesCol(Util$.MODULE$.FEATURES_COLUMN()))).setLabelCol(target))).setCategoricalFeaturesCols(categoricalFeatures) : (PreTrainPredictionModelingParams.Algorithm.SPARKLING_RF.equals(algorithm) ? ((HasCategoricalFeatures)((Object)((HasLabelCol)((Object)new H2ORandomForestRegressor().setParams(modelingParams.rf_sparkling_grid).setFeaturesCol(Util$.MODULE$.FEATURES_COLUMN()))).setLabelCol(target))).setCategoricalFeaturesCols(categoricalFeatures) : ParameterResolution$.MODULE$.resolve(coreParams, prepParams, modelingParams))))));
        Ensemble ensemble = temp;
        if (ensemble instanceof Estimator) {
            Estimator estimator = ensemble;
            return new .colon.colon((Object)estimator, (List)Nil$.MODULE$);
        }
        if (ensemble instanceof List) {
            List list = (List)ensemble;
            return list;
        }
        throw new MatchError((Object)ensemble);
    }

    public List<Estimator<?>> getBinaryPredictor(ResolvedClassicalPredictionCoreParams coreParams, PreTrainPredictionModelingParams modelingParams, ResolvedPredictionPreprocessingParams prepParams, IndexedSeq<String> categoricalFeatures) {
        String target = coreParams.target_variable;
        PreTrainPredictionModelingParams.Algorithm algorithm = modelingParams.algorithm;
        Ensemble temp = PreTrainPredictionModelingParams.Algorithm.MLLIB_CUSTOM.equals(algorithm) ? MLLibJob$.MODULE$.getCustomEstimator(modelingParams.custom_mllib_grid.initializationCode) : (PreTrainPredictionModelingParams.Algorithm.SPARK_ENSEMBLE.equals(algorithm) ? new Ensemble(modelingParams.ensemble_params, coreParams, prepParams, Ensemble$.MODULE$.$lessinit$greater$default$4()) : (PreTrainPredictionModelingParams.Algorithm.SPARKLING_DEEP_LEARNING.equals(algorithm) ? ((HasCategoricalFeatures)((Object)((HasLabelCol)((Object)new H2ODeepLearningProbabilistic().setDeepLearningParameters(modelingParams.deep_learning_sparkling_grid).setFeaturesCol(Util$.MODULE$.FEATURES_COLUMN()))).setLabelCol(target))).setCategoricalFeaturesCols(categoricalFeatures) : (PreTrainPredictionModelingParams.Algorithm.SPARKLING_GBM.equals(algorithm) ? ((HasCategoricalFeatures)((Object)((HasLabelCol)((Object)new H2OGradientBoostingProbabilistic().setParams(modelingParams.gbm_sparkling_grid).setFeaturesCol(Util$.MODULE$.FEATURES_COLUMN()))).setLabelCol(target))).setCategoricalFeaturesCols(categoricalFeatures) : (PreTrainPredictionModelingParams.Algorithm.SPARKLING_GLM.equals(algorithm) ? ((HasCategoricalFeatures)((Object)((HasLabelCol)((Object)new H2OGLMProbabilistic().setParams(modelingParams.glm_sparkling_grid).setFeaturesCol(Util$.MODULE$.FEATURES_COLUMN()))).setLabelCol(target))).setCategoricalFeaturesCols(categoricalFeatures) : (PreTrainPredictionModelingParams.Algorithm.SPARKLING_RF.equals(algorithm) ? ((HasCategoricalFeatures)((Object)((HasLabelCol)((Object)new H2ORandomForestProbabilistic().setParams(modelingParams.rf_sparkling_grid).setFeaturesCol(Util$.MODULE$.FEATURES_COLUMN()))).setLabelCol(target))).setCategoricalFeaturesCols(categoricalFeatures) : (PreTrainPredictionModelingParams.Algorithm.SPARKLING_NB.equals(algorithm) ? ((HasCategoricalFeatures)((Object)((HasLabelCol)((Object)new H2ONaiveBayesProbabilistic().setParams(modelingParams.nb_sparkling_grid).setFeaturesCol(Util$.MODULE$.FEATURES_COLUMN()))).setLabelCol(target))).setCategoricalFeaturesCols(categoricalFeatures) : ParameterResolution$.MODULE$.resolve(coreParams, prepParams, modelingParams)))))));
        Ensemble ensemble = temp;
        if (ensemble instanceof Estimator) {
            Estimator estimator = ensemble;
            return new .colon.colon((Object)estimator, (List)Nil$.MODULE$);
        }
        if (ensemble instanceof List) {
            List list = (List)ensemble;
            return list;
        }
        throw new MatchError((Object)ensemble);
    }

    public List<Estimator<?>> getMulticlassPredictor(ResolvedClassicalPredictionCoreParams coreParams, PreTrainPredictionModelingParams modelingParams, ResolvedPredictionPreprocessingParams prepParams, IndexedSeq<String> categoricalFeatures) {
        String target = coreParams.target_variable;
        PreTrainPredictionModelingParams.Algorithm algorithm = modelingParams.algorithm;
        Ensemble temp = PreTrainPredictionModelingParams.Algorithm.MLLIB_CUSTOM.equals(algorithm) ? MLLibJob$.MODULE$.getCustomEstimator(modelingParams.custom_mllib_grid.initializationCode) : (PreTrainPredictionModelingParams.Algorithm.SPARK_ENSEMBLE.equals(algorithm) ? new Ensemble(modelingParams.ensemble_params, coreParams, prepParams, Ensemble$.MODULE$.$lessinit$greater$default$4()) : (PreTrainPredictionModelingParams.Algorithm.SPARKLING_DEEP_LEARNING.equals(algorithm) ? ((HasCategoricalFeatures)((Object)((HasLabelCol)((Object)new H2ODeepLearningProbabilistic().setDeepLearningParameters(modelingParams.deep_learning_sparkling_grid).setFeaturesCol(Util$.MODULE$.FEATURES_COLUMN()))).setLabelCol(target))).setCategoricalFeaturesCols(categoricalFeatures) : (PreTrainPredictionModelingParams.Algorithm.SPARKLING_GBM.equals(algorithm) ? ((HasCategoricalFeatures)((Object)((HasLabelCol)((Object)new H2OGradientBoostingProbabilistic().setParams(modelingParams.gbm_sparkling_grid).setFeaturesCol(Util$.MODULE$.FEATURES_COLUMN()))).setLabelCol(target))).setCategoricalFeaturesCols(categoricalFeatures) : (PreTrainPredictionModelingParams.Algorithm.SPARKLING_GLM.equals(algorithm) ? ((HasCategoricalFeatures)((Object)((HasLabelCol)((Object)new H2OGLMProbabilistic().setParams(modelingParams.glm_sparkling_grid).setFeaturesCol(Util$.MODULE$.FEATURES_COLUMN()))).setLabelCol(target))).setCategoricalFeaturesCols(categoricalFeatures) : (PreTrainPredictionModelingParams.Algorithm.SPARKLING_RF.equals(algorithm) ? ((HasCategoricalFeatures)((Object)((HasLabelCol)((Object)new H2ORandomForestProbabilistic().setParams(modelingParams.rf_sparkling_grid).setFeaturesCol(Util$.MODULE$.FEATURES_COLUMN()))).setLabelCol(target))).setCategoricalFeaturesCols(categoricalFeatures) : (PreTrainPredictionModelingParams.Algorithm.SPARKLING_NB.equals(algorithm) ? ((HasCategoricalFeatures)((Object)((HasLabelCol)((Object)new H2ONaiveBayesProbabilistic().setParams(modelingParams.nb_sparkling_grid).setFeaturesCol(Util$.MODULE$.FEATURES_COLUMN()))).setLabelCol(target))).setCategoricalFeaturesCols(categoricalFeatures) : ParameterResolution$.MODULE$.resolve(coreParams, prepParams, modelingParams)))))));
        Ensemble ensemble = temp;
        if (ensemble instanceof Estimator) {
            Estimator estimator = ensemble;
            return new .colon.colon((Object)estimator, (List)Nil$.MODULE$);
        }
        if (ensemble instanceof List) {
            List list = (List)ensemble;
            return list;
        }
        throw new MatchError((Object)ensemble);
    }

    public List<Estimator<Nothing$>> getPredictors(ResolvedClassicalPredictionCoreParams coreParams, PreTrainPredictionModelingParams modelingParams, ResolvedPredictionPreprocessingParams prepParams, IndexedSeq<String> categoricalFeatures) {
        List<Estimator<?>> list;
        PredictionMLTask.PredictionType predictionType = coreParams.prediction_type;
        if (PredictionMLTask.PredictionType.REGRESSION.equals(predictionType)) {
            list = this.getRegressionPredictors(coreParams, modelingParams, prepParams, categoricalFeatures);
        } else if (PredictionMLTask.PredictionType.BINARY_CLASSIFICATION.equals(predictionType)) {
            list = this.getBinaryPredictor(coreParams, modelingParams, prepParams, categoricalFeatures);
        } else if (PredictionMLTask.PredictionType.MULTICLASS.equals(predictionType)) {
            list = this.getMulticlassPredictor(coreParams, modelingParams, prepParams, categoricalFeatures);
        } else {
            throw new IllegalArgumentException(new StringBuilder(31).append("Prediction type ").append(predictionType).append(" not supported.").toString());
        }
        return (List)list.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1, List$.MODULE$.canBuildFrom());
    }

    private Predictors$() {
        MODULE$ = this;
    }
}

