/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.activity;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.metrics.Model;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.datasets.DatasetMetricsStatusService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.LazyHashMap;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConnectionDataReportingService {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private DatasetAccessService datasetAccessService;
    @Autowired
    private DatasetMetricsStatusService datasetMetricsService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku");

    public ConnectionData getConnectionData_NT(String connectionId) throws Exception {
        ConnectionData cd = new ConnectionData();
        List<Dataset> datasets = this.listDatasetOfConnection_NT(connectionId);
        logger.infoV("Connection %s is used by %d datasets", new Object[]{connectionId, datasets.size()});
        List<DataPoint> dataPoints = this.getForDatasets(datasets);
        cd.byProject = this.aggregateByProject(dataPoints);
        cd.global = this.aggregateGlobally(dataPoints);
        return cd;
    }

    public ProjectData getConnectionProjectData_NT(String connectionId, String projectKey) throws Exception {
        ProjectData pd = new ProjectData();
        pd.projectKey = projectKey;
        List<Dataset> datasets = this.listDatasetOfProjectAndConnection_NT(connectionId, projectKey);
        logger.infoV("Connection %s is used by %d datasets in %s", new Object[]{connectionId, datasets.size(), projectKey});
        pd.dataPoints = this.getForDatasets(datasets);
        return pd;
    }

    public FutureResponse<?> updateForProject(AuthCtx user, String connectionId, String projectKey, boolean computeRecords, boolean forceRecompute) throws Exception {
        List<Dataset> datasets = this.listDatasetOfProjectAndConnection_NT(connectionId, projectKey);
        return this.updateStatusForDatasets(user, datasets, computeRecords, forceRecompute);
    }

    public FutureResponse<?> updateForDataset(AuthCtx user, String projectKey, String datasetName, boolean computeRecords, boolean forceRecompute) throws Exception {
        ArrayList datasets = null;
        try (Transaction t = this.transactionService.beginRead();){
            datasets = Lists.newArrayList((Object[])new Dataset[]{this.datasetAccessService.getMandatoryUnsafe(projectKey, datasetName)});
        }
        return this.updateStatusForDatasets(user, datasets, computeRecords, forceRecompute);
    }

    private void computeRatios(List<AggregatedDataPoint> ret) {
        long totalRecords = 0L;
        long totalSize = 0L;
        for (AggregatedDataPoint adp : ret) {
            if (adp.records.totalValue > 0L) {
                totalRecords += adp.records.totalValue;
            }
            if (adp.size.totalValue <= 0L) continue;
            totalSize += adp.size.totalValue;
        }
        for (AggregatedDataPoint adp : ret) {
            if (totalRecords > 0L && adp.records.totalValue > 0L) {
                adp.records.ratioOfTotal = (double)adp.records.totalValue / (double)totalRecords;
            }
            if (totalSize <= 0L || adp.size.totalValue <= 0L) continue;
            adp.size.ratioOfTotal = (double)adp.size.totalValue / (double)totalSize;
        }
    }

    private List<AggregatedDataPoint> aggregateByProject(List<DataPoint> points) {
        LazyHashMap lm = new LazyHashMap(AggregatedDataPoint.class);
        for (DataPoint dp : points) {
            AggregatedDataPoint adp = (AggregatedDataPoint)lm.getOrCreate((Object)dp.projectKey);
            ++adp.nbDatasets;
            adp.key = dp.projectKey;
            adp.size.merge(dp.size);
            adp.records.merge(dp.records);
        }
        ArrayList ret = Lists.newArrayList((Iterable)lm.values());
        this.computeRatios(ret);
        return ret;
    }

    private AggregatedDataPoint aggregateGlobally(List<DataPoint> points) {
        AggregatedDataPoint adp = new AggregatedDataPoint();
        for (DataPoint dp : points) {
            ++adp.nbDatasets;
            adp.size.merge(dp.size);
            adp.records.merge(dp.records);
        }
        return adp;
    }

    private List<DataPoint> getForDatasets(List<Dataset> datasets) throws Exception {
        ArrayList<DataPoint> dataPoints = new ArrayList<DataPoint>();
        for (Dataset dataset : datasets) {
            DataPoint dataPoint = new DataPoint();
            dataPoint.projectKey = dataset.getProjectKey();
            dataPoint.datasetName = dataset.getName();
            DatasetMetricsStatusService.DatasetSummaryStatus dss = this.datasetMetricsService.getCachedSummaryStatus(dataset);
            dataPoint.records = new Model.AggregatedDatasetsMetricValue();
            dataPoint.records.merge(dss.records);
            dataPoint.size = new Model.AggregatedDatasetsMetricValue();
            dataPoint.size.merge(dss.size);
            dataPoints.add(dataPoint);
            long totalRecords = 0L;
            long totalSize = 0L;
            for (DataPoint dp : dataPoints) {
                if (dp.records.totalValue > 0L) {
                    totalRecords += dp.records.totalValue;
                }
                if (dp.size.totalValue <= 0L) continue;
                totalSize += dp.size.totalValue;
            }
            for (DataPoint dp : dataPoints) {
                if (totalRecords > 0L && dp.records.totalValue > 0L) {
                    dp.records.ratioOfTotal = (double)dp.records.totalValue / (double)totalRecords;
                }
                if (totalSize <= 0L || dp.size.totalValue <= 0L) continue;
                dp.size.ratioOfTotal = (double)dp.size.totalValue / (double)totalSize;
            }
        }
        return dataPoints;
    }

    private List<Dataset> listDatasetOfConnection_NT(String connectionId) throws IOException {
        ArrayList<Dataset> datasets = new ArrayList<Dataset>();
        logger.infoV("Getting connection usage for %s", new Object[]{connectionId});
        try (Transaction t = this.transactionService.beginRead();){
            for (String spProjectKey : this.projectsService.listKeys()) {
                for (SerializedDataset sd : this.datasetsDAO.listUnsafe(spProjectKey)) {
                    if (sd.getParams() == null || !StringUtils.equals((String)connectionId, (String)sd.getParams().getConnection())) continue;
                    datasets.add(Dataset.fromSerializedUnsafe(sd));
                }
            }
        }
        return datasets;
    }

    private List<Dataset> listDatasetOfProjectAndConnection_NT(String connectionId, String projectKey) throws IllegalArgumentException, IOException {
        ArrayList<Dataset> datasets = new ArrayList<Dataset>();
        logger.infoV("Getting connection usage for %s in project %s", new Object[]{connectionId, projectKey});
        try (Transaction t = this.transactionService.beginRead();){
            for (SerializedDataset sd : this.datasetsDAO.listUnsafe(projectKey)) {
                if (!StringUtils.equals((String)connectionId, (String)sd.getParams().getConnection())) continue;
                datasets.add(Dataset.fromSerializedUnsafe(sd));
            }
        }
        return datasets;
    }

    private FutureResponse<?> updateStatusForDatasets(AuthCtx user, List<Dataset> datasets, boolean computeRecords, boolean forceRecompute) throws Exception {
        return this.datasetMetricsService.refreshMultiSummaries_F(user, datasets, computeRecords, forceRecompute);
    }

    public static class ConnectionData {
        AggregatedDataPoint global;
        public List<AggregatedDataPoint> byProject = new ArrayList<AggregatedDataPoint>();
    }

    public static class AggregatedDataPoint {
        public String key;
        public int nbDatasets;
        public Model.AggregatedDatasetsMetricValue size = new Model.AggregatedDatasetsMetricValue();
        public Model.AggregatedDatasetsMetricValue records = new Model.AggregatedDatasetsMetricValue();
    }

    public static class ProjectData {
        public String projectKey;
        public List<DataPoint> dataPoints = new ArrayList<DataPoint>();
    }

    static class DataPoint {
        public String projectKey;
        public String creator;
        public String datasetName;
        public Model.AggregatedDatasetsMetricValue size;
        public Model.AggregatedDatasetsMetricValue records;

        DataPoint() {
        }
    }
}

