/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.activity;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.activity.UsageSummaryBuilderUtils;
import com.dataiku.dip.badges.TypeBadge;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.pivot.frontend.model.ChartDef;
import com.dataiku.dip.pivot.frontend.model.DimensionDef;
import com.dataiku.dip.pivot.frontend.model.NADimensionDef;
import com.dataiku.dip.security.SSOSettings;
import com.dataiku.dip.security.auth.UserSourceType;
import com.dataiku.dip.server.services.CloudStacksCloud;
import com.dataiku.dip.server.services.DeploymentMode;
import com.dataiku.dip.server.services.licensing.LimitsStatusComputer;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.apache.commons.math3.stat.descriptive.rank.PSquarePercentile;

public class UsageSummaryModel {

    public static class TypeBadgesReport {
        public Map<TypeBadge, Integer> nbProjectBadgesPerType = new HashMap<TypeBadge, Integer>();
    }

    public static class WorkspaceDetailedReport
    extends WorkspaceSummaryReport {
        public String id;
        public int reportVersion = 1;
    }

    public static class ChartsProjectReport
    extends ChartsSummaryReport {
        public List<JsonObject> details = new ArrayList<JsonObject>();
    }

    public static class RecipesProjectReport
    extends RecipesSummaryReport {
        public List<JsonObject> details = new ArrayList<JsonObject>();
    }

    public static class DatasetsProjectReport
    extends DatasetsSummaryReport {
        public List<JsonObject> details = new ArrayList<JsonObject>();
    }

    public static class AnalysisProjectReport
    extends AnalysisSummaryReport {
        public List<JsonObject> details = new ArrayList<JsonObject>();
    }

    public static class ShakerRecipesProjectReport
    extends ShakerRecipeSummaryReport {
        public List<JsonObject> details = new ArrayList<JsonObject>();
    }

    public static class ProjectDetailedReport {
        public String id;
        public int reportVersion = 3;
        public DatasetsProjectReport datasets;
        public RecipesProjectReport recipes;
        public ShakerRecipesProjectReport shakerRecipes;
        public FiltersSummaryReport filters;
        public ChartsProjectReport charts;
        public AnalysisProjectReport analysis;
        public ScenariosSummaryReport scenarios = new ScenariosSummaryReport();
        public APIServicesSummaryReport apiServices = new APIServicesSummaryReport();
        public NotebooksSummaryReport notebooks = new NotebooksSummaryReport();
        public InsightsSummaryReport insights = new InsightsSummaryReport();
        public DashboardsSummaryReport dashboards = new DashboardsSummaryReport();
        public WikisSummaryReport wiki = new WikisSummaryReport();
        public LibrariesSummaryReport libraries = new LibrariesSummaryReport();
        public LabelingTasksSummaryReport labelingTasks = new LabelingTasksSummaryReport();
        public CodeStudiosSummaryReport codeStudios = new CodeStudiosSummaryReport();
        public ExposedObjectsSummaryReport exposedObjects = new ExposedObjectsSummaryReport();
        public Boolean sparkPipelinesEnabled;
        public Boolean sqlPipelinesEnabled;
        public Boolean hasK8sClusterIdSet;
        public SerializedProject.ProjectAppType projectAppType;
        public Boolean useAsRecipe;
        public Integer instanceCount;
        public GeneralSettingsDAO.InheritableEnabledSetting.LocalValue limitedVisibilityEnabled;
        public GeneralSettingsDAO.InheritableEnabledSetting.LocalValue appLimitedVisibilityEnabled;
        public GeneralSettingsDAO.InheritableEnabledSetting.LocalValue sharingRequestsEnabled;
        public GeneralSettingsDAO.InheritableEnabledSetting.LocalValue accessRequestEnabled;
        public GeneralSettingsDAO.InheritableEnabledSetting.LocalValue appAccessRequestEnabled;
        public Boolean hasExplicitContainer;
        public Boolean hasExplicitContainerForVisualRecipesWorkloads;
        public Map<TypeBadge, Integer> nbContributorsPerProjectTypeBadge = new HashMap<TypeBadge, Integer>();
        public Boolean autogeneratedDocumentationEnabled;
    }

    public static class DSSVisualizationThemeReport {
        public int counts;
    }

    public static class PythonCodeEnvsSummaryReport {
        public String baseEnvVersion;
        public Map<String, Integer> versionsCount = new HashMap<String, Integer>();
    }

    public static class StreamingEndpointsSummaryReport {
        public int all;
        public Map<String, Integer> allByType = new HashMap<String, Integer>();
        public Map<String, Integer> notFlow = new HashMap<String, Integer>();
        public Map<String, Integer> flowInput = new HashMap<String, Integer>();
        public Map<String, Integer> flowIO = new HashMap<String, Integer>();
        public Map<String, Integer> flowOutput = new HashMap<String, Integer>();
    }

    public static class LabelingTasksSummaryReport {
        public int nbLabelingTasks;
        public Map<String, Integer> nbLabelingTasksByTpe = new HashMap<String, Integer>();
    }

    public static class ApiKeyReport {
        public int globalScopeApiKeysWithGroupsCount;
        public int globalScopeApiKeysWithoutGroupsCount;
    }

    public static class UserDetailedReport {
        public Map<UserSourceType, Long> byType = new HashMap<UserSourceType, Long>();
        public int nbUsers;
        public int nbUsersWithAutomaticStackUpEnabled;

        public UserDetailedReport() {
            for (UserSourceType type : UserSourceType.values()) {
                this.byType.put(type, 0L);
            }
        }

        public void inc(UserSourceType type) {
            this.byType.put(type, this.byType.get(type) + 1L);
        }
    }

    public static class LicensingProfilesDetailedReport {
        public Map<String, List<String>> disabledByLogin = new HashMap<String, List<String>>();
        public Map<String, List<String>> byLogin = new HashMap<String, List<String>>();
        public Map<String, List<String>> validTrialsByLogin = new HashMap<String, List<String>>();
        public Map<String, List<String>> expiredTrialsByLogin = new HashMap<String, List<String>>();
        public Map<String, List<String>> illegalTrialsByLogin = new HashMap<String, List<String>>();
    }

    public static class SummaryReport {
        public int reportVersion = 4;
        public int projects;
        public int privateProjects;
        public int limitedVisibilityProjects;
        public int inheritedVisibilityProjects;
        public DatasetsSummaryReport datasets = new DatasetsSummaryReport();
        public DataQualitySummaryReport rules = new DataQualitySummaryReport();
        public DataQualityTemplatesSummaryReport dataQualityTemplates = new DataQualityTemplatesSummaryReport();
        public StreamingEndpointsSummaryReport streamingEndpoints = new StreamingEndpointsSummaryReport();
        public LabelingTasksSummaryReport labelingTasks = new LabelingTasksSummaryReport();
        public RecipesSummaryReport recipes = new RecipesSummaryReport();
        public ShakerRecipeSummaryReport shakerRecipes = new ShakerRecipeSummaryReport();
        public JoinRecipeSummaryReport joinRecipes = new JoinRecipeSummaryReport();
        public LLMEvaluationRecipeSummaryReport llmEvaluationRecipes = new LLMEvaluationRecipeSummaryReport();
        public RAGEmbeddingRecipeSummaryReport ragEmbeddingRecipe = new RAGEmbeddingRecipeSummaryReport();
        public RetrievableKnowledgeSummaryReport retrievableKnowledge = new RetrievableKnowledgeSummaryReport();
        public RetrievalAugmentedLLLMSummaryReport retrievalAugmentedLLM = new RetrievalAugmentedLLLMSummaryReport();
        public AgentSummaryReport agents = new AgentSummaryReport();
        public AnalysisSummaryReport analysis = new AnalysisSummaryReport();
        public ScenariosSummaryReport scenarios = new ScenariosSummaryReport();
        public FiltersSummaryReport filters = new FiltersSummaryReport();
        public APIServicesSummaryReport apiServices = new APIServicesSummaryReport();
        public ChartsSummaryReport charts = new ChartsSummaryReport();
        public InsightsSummaryReport insights = new InsightsSummaryReport();
        public DashboardsSummaryReport dashboards = new DashboardsSummaryReport();
        public NotebooksSummaryReport notebooks = new NotebooksSummaryReport();
        public APIDeployerSummaryReport apiDeployer = new APIDeployerSummaryReport();
        public ProjectDeployerSummaryReport projectDeployer = new ProjectDeployerSummaryReport();
        public WikisSummaryReport wikis = new WikisSummaryReport();
        public LibrariesSummaryReport libraries = new LibrariesSummaryReport();
        public CodeStudiosSummaryReport codeStudios = new CodeStudiosSummaryReport();
        public CodeStudioTemplatesSummaryReport codeStudioTemplates = new CodeStudioTemplatesSummaryReport();
        public ProjectFoldersSummaryReport projectFolders = new ProjectFoldersSummaryReport();
        public WorksheetsSummaryReport worksheets = new WorksheetsSummaryReport();
        public WorkspacesSummaryReport workspaces = new WorkspacesSummaryReport();
        public MecSummaryReport mecs = new MecSummaryReport();
        public PromptStudiosSummaryReport promptStudios = new PromptStudiosSummaryReport();
        public LLMCostLimitingSummaryReport llmCostLimiting = new LLMCostLimitingSummaryReport();
        public LLMRateLimitingSummaryReport llmRateLimiting = new LLMRateLimitingSummaryReport();
        public LimitsStatusComputer.LicenseLimitsStatus licenseLimits;
        public LicensingProfilesDetailedReport licenseProfileDetails = new LicensingProfilesDetailedReport();
        public UserDetailedReport userDetailedReport = new UserDetailedReport();
        public Map<String, Long> userActivity = new HashMap<String, Long>();
        public ApplicationConfigurator.DSSNodeType nodeType;
        public DeploymentMode deploymentMode;
        public CloudStacksCloud cloudStacksCloud;
        public ApiKeyReport apiKeys = new ApiKeyReport();
        public UDMSummaryReport udms = new UDMSummaryReport();
        public PluginsSummaryReport plugins = new PluginsSummaryReport();
        public GeneralSettingsSummaryReport generalSettings = new GeneralSettingsSummaryReport();
        public ProjectStandardsSummaryReport projectStandards = new ProjectStandardsSummaryReport();
        public Map<String, Integer> projectByAppType = new HashMap<String, Integer>();
        public AppManifestsSummaryReport appManifests = new AppManifestsSummaryReport();
        public AppInstancesSummaryReport appInstances = new AppInstancesSummaryReport();
        public ModelEvaluationStoreSummaryReport modelEvaluationStores = new ModelEvaluationStoreSummaryReport();
        public ExperimentTrackingSummaryReport experimentTracking = new ExperimentTrackingSummaryReport();
        public ExternalModelsSummaryReport externalModels = new ExternalModelsSummaryReport();
        public FeatureStoreSummaryReport featureStore = new FeatureStoreSummaryReport();
        public ClustersSummaryReport clusters = new ClustersSummaryReport();
        public ConnectionsSummaryReport connections = new ConnectionsSummaryReport();
        public ExposedObjectsSummaryReport exposedObjects = new ExposedObjectsSummaryReport();
        public PythonCodeEnvsSummaryReport pythonCodeEnvs = new PythonCodeEnvsSummaryReport();
        public DataCollectionsSummaryReport dataCollections;
        public PopularDatasetsReport popularDatasets;
        public UnifiedMonitoringReport unifiedMonitoring;
        public DSSVisualizationThemeReport dssVisualizationThemeReport = new DSSVisualizationThemeReport();
        public TypeBadgesReport typeBadgesReport = new TypeBadgesReport();
    }

    public static class MonitoringReportWithProjects
    extends MonitoringReport {
        public List<ProjectMonitoringReport> projectsSummaries = new ArrayList<ProjectMonitoringReport>();
    }

    public static class ProjectMonitoringReport
    extends MonitoringReport {
        public String projectKey;
        public String projectName;
    }

    public static class MonitoringReport {
        public int projects;
        public DatasetsSummaryReport datasets = new DatasetsSummaryReport();
        public RecipesSummaryReport recipes = new RecipesSummaryReport();
        public AnalysisSummaryReport analysis = new AnalysisSummaryReport();
        public ScenariosSummaryReport scenarios = new ScenariosSummaryReport();
        public APIServicesSummaryReport apiServices = new APIServicesSummaryReport();
        public ChartsSummaryReport charts = new ChartsSummaryReport();
        public InsightsSummaryReport insights = new InsightsSummaryReport();
        public DashboardsSummaryReport dashboards = new DashboardsSummaryReport();
        public NotebooksSummaryReport notebooks = new NotebooksSummaryReport();
        public LabelingTasksSummaryReport labelingTasks = new LabelingTasksSummaryReport();
        public WorkspacesSummaryReport workspaces = new WorkspacesSummaryReport();
        public UDMSummaryReport udms = new UDMSummaryReport();
    }

    public static class UnifiedMonitoringAlertingReport {
        public Map<String, Integer> nbAlertsByType = new HashMap<String, Integer>();
        public Map<String, Integer> nbReportersByType = new HashMap<String, Integer>();
        public Map<String, Integer> nbAlertsEnabledOrDisabled = new HashMap<String, Integer>();
        public Map<String, Integer> nbAlertsValidOrInvalid = new HashMap<String, Integer>();
    }

    public static class UnifiedMonitoringReport {
        public Map<String, Integer> nbBatchInfrasByType = new HashMap<String, Integer>();
        public Map<String, Integer> nbRealTimeInfrasByType = new HashMap<String, Integer>();
        public UnifiedMonitoringAlertingReport unifiedMonitoringAlerting = new UnifiedMonitoringAlertingReport();
    }

    public static class PopularDatasetsReport {
        public int popularDatasetsCount;
        public long medianComputationDuration;

        public PopularDatasetsReport(int popularDatasetsCount, long medianComputationDuration) {
            this.popularDatasetsCount = popularDatasetsCount;
            this.medianComputationDuration = medianComputationDuration;
        }
    }

    public static class DataCollectionsSummaryReport {
        public int dataCollectionGlobalCount;
        public int itemsGlobalCount;
        public int itemsGlobalMax;
        public int datasetsGlobalCount;
        public int datasetsGlobalMax;
    }

    public static class ExposedObjectsSummaryReport {
        public int quickSharedObjects;
        public int managedSharedObjects;
        public int quickSharedDatasets;
        public int managedSharedDatasets;
    }

    public static class ConnectionsSummaryReport {
        public int all;
        public Map<String, Integer> connectionsByType = new HashMap<String, Integer>();
        public int llmQueryForbiddenTermsDetection;
        public int llmQueryPIIDetection;
        public int llmQueryToxicityDetection;
        public int llmPromptInjectionDetection;
        public List<LLMConnectionSummary> llmConnections = new ArrayList<LLMConnectionSummary>();
    }

    public static class LLMConnectionSummary {
        public String type;
        public Set<String> enabledCompletionStandardModels = new HashSet<String>();
        public Set<String> enabledTextEmbeddingStandardModels = new HashSet<String>();
        public Set<String> enabledImageEmbeddingStandardModels = new HashSet<String>();
        public int enabledCompletionCustomModels;
        public int enabledTextEmbeddingCustomModels;
        public int enabledImageEmbeddingCustomModels;
        public Boolean queryForbiddenTermsDetection;
        public Boolean queryPIIDetection;
        public Boolean queryToxicityDetection;
        public Boolean promptInjectionDetection;
    }

    public static class ClustersSummaryReport {
        public int all;
        public Map<String, Integer> clustersByType = new HashMap<String, Integer>();
    }

    public static class WorkspacesSummaryReport
    extends WorkspaceSummaryReport {
        public int all;
    }

    public static class WorkspaceSummaryReport {
        public int objects;
        public Map<String, Integer> objectsByType = new HashMap<String, Integer>();
        public int users;
        public Map<String, Integer> usersByRole = new HashMap<String, Integer>();
        public int groups;
        public Map<String, Integer> groupsByRole = new HashMap<String, Integer>();
    }

    public static class FeatureStoreSummaryReport {
        public long nbFeatureGroups;
    }

    public static class ProxyModelSummaryReport {
        public int all = 0;
        public Map<String, Integer> byType = new HashMap<String, Integer>();
        public Map<String, Integer> byPredictionType = new HashMap<String, Integer>();
    }

    public static class MLflowSummaryReport {
        public int all = 0;
        public Map<String, Integer> byFlavor = new HashMap<String, Integer>();
        public Map<String, Integer> byPredictionType = new HashMap<String, Integer>();
    }

    public static class ExternalModelsSummaryReport {
        public MLflowSummaryReport mlflowModels = new MLflowSummaryReport();
        public ProxyModelSummaryReport proxyModels = new ProxyModelSummaryReport();
    }

    public static class ExperimentTrackingSummaryReport {
        public int nbExperiments;
    }

    public static class ModelEvaluationStoreSummaryReport {
        public int nbMES;
        public int nbME;
        public int nbTabularMES;
        public int nbTabularME;
        public int nbTimeseriesMES;
        public int nbTimeseriesME;
        public int nbLLMMES;
        public int nbLLMME;
        public int nbAgentMES;
        public int nbAgentME;
    }

    public static class ApplicationInstances {
        public int applicationAsRecipeInstances;
        public int applicationInstances;
    }

    public static class AppInstancesSummaryReport {
        public ApplicationInstances projectApplicationInstances = new ApplicationInstances();
        public ApplicationInstances pluginApplicationInstances = new ApplicationInstances();
    }

    public static class AppManifestsSummaryReport {
        public int all;
        public Map<Integer, Integer> allBySectionCount = new HashMap<Integer, Integer>();
        public Map<Integer, Integer> allByTileCount = new HashMap<Integer, Integer>();
        public Map<String, Integer> tileByType = new HashMap<String, Integer>();
        public int useAsRecipe;
        public int includesDatasetData;
        public int includesFolderData;
        public int includesModelData;
        public int privateAccessibility;
        public int limitedAccessAccessibility;
        public int inheritedAccessibility;
        public int includesCodeStudioData;
        public int includesKnowledgeBankData;
        public int includesPromptStudiosHistories;
    }

    public static class LLMRateLimitingSummaryReport {
        public int nbProvidersWithCustomEntries;
        public int nbCustomCompletionDefault;
        public int nbCustomEmbeddingDefault;
        public int nbCustomImageGenerationDefault;
        public int nbCustomModels;
    }

    public static class LLMCostLimitingSummaryReport {
        public int nbQuotas;
        public int nbBlockingQuotas;
        public int nbNonBlockingQuotasSetToZero;
        public int nbBlockingQuotasSetToZero;
        public int nbQuotasWithAlerts;
        public int nbQuotasWithFilters;
        public Map<String, Integer> nbQuotasByFilterDimension = new HashMap<String, Integer>();
        public Map<String, Integer> nbQuotasByResetPeriodDimension = new HashMap<String, Integer>();
        public int nbQuotasWithAllowedQueries;
        public int nbQuotasWithBlockedQueries;
        public int nbQuotasCurrentlyBlocked;
        boolean hasFallbackQuotaQueries = false;
        public List<LLMCostLimitingQuotaReport> quotas = new ArrayList<LLMCostLimitingQuotaReport>();
    }

    public static class LLMCostLimitingQuotaReport {
        public boolean isFallback;
        public boolean isBlocking;
        public String resetPeriod;
        public int rollingPeriods;
        public boolean isSetToZero;
        public boolean hasAlerts;
        public boolean hasFilters;
        public Map<String, Integer> nbClausesByFilterDimension = new HashMap<String, Integer>();
        public boolean hasAllowedQueries;
        public boolean hasBlockedQueries;
        public boolean isCurrentlyBlocked;
    }

    public static class PromptStudiosSummaryReport {
        public int nbPromptStudios;
        public int nbPrompts;
        public Map<String, Integer> nbPromptsPerLLMType = new HashMap<String, Integer>();
    }

    public static class MecSummaryReport {
        public int nbModelComparisons;
        public int nbComparedModels;
        public Map<String, Integer> nbComparisonPerPredictionType = new HashMap<String, Integer>();
        public Map<String, Integer> nbComparisonPerModelTaskType = new HashMap<String, Integer>();
    }

    public static class WorksheetsSummaryReport {
        public int nbWorksheets;
        public int nbCards;
        public int nbCardsWithSplit;
        public Map<String, Integer> nbCardsPerType = new HashMap<String, Integer>();
    }

    public static class ProjectFoldersSummaryReport {
        public int nbProjectFolders;
        public int maxDepth;
        public int nbProjectsInRoot;
        public int nbProjectsTotal;
    }

    public static class ProjectStandardsSummaryReport {
        public Map<String, Integer> nbChecksByScope = new HashMap<String, Integer>();
    }

    public static class GeneralSettingsSummaryReport {
        public boolean sso;
        public SSOSettings.SSOProtocol ssoProtocol;
        public boolean ssoProvisioningEnabled;
        public boolean ldap;
        public boolean ldapAuthEnabled;
        public boolean ldapProvisioningEnabled;
        public boolean azureADSupplierEnabled;
        public boolean azureADProvisioningEnabled;
        public boolean pamAuthenticatorEnabled;
        public boolean customAuthenticatorEnabled;
        public boolean customUserSupplierEnabled;
        public boolean enableEmailAndDisplayNameModification;
        public boolean hashApiKeys;
        public int apiKeysLifetimeDays;
        public boolean onboardingExperience;
        public boolean opalsEnabled;
        public boolean prepareAICompletionEnabled;
        public boolean aiExplanationsEnabled;
        public boolean storiesAIEnabled;
        public boolean storiesVocalEnabled;
        public boolean enrichDSSUserFromLdapEnabled;
        public boolean mus;
        public boolean hasDSSURL;
        public boolean hasAdminContact;
        public boolean graphite;
        public boolean cgroups;
        public boolean externalRuntimeDatabases;
        public boolean streaming;
        public boolean showProjectsGraphView;
        public GeneralSettingsDAO.DeployerMode deployerMode;
        public boolean portRangeLimitation;
        public GeneralSettingsDAO.InheritableEnabledSetting projectsAccessibilityMode;
        public GeneralSettingsDAO.InheritableEnabledSetting projectsAccessRequestMode;
        public GeneralSettingsDAO.InheritableEnabledSetting appsAccessibilityMode;
        public GeneralSettingsDAO.InheritableEnabledSetting appsAccessRequestMode;
        public boolean permissionsByEmailEnabled;
        public boolean hasDefaultK8sClusterId;
        public boolean hasQuickSharingElementsEnabled;
        public GeneralSettingsDAO.InheritableEnabledSetting objectSharingRequestsMode;
        public GeneralSettingsDAO.TrialBehavior trialBehavior;
        public GeneralSettingsDAO.NoneUsersCallToActionBehavior noneUsersCallToActionBehavior;
        public String userProfileForTrialsStartedByNoneUsers;
        public GeneralSettingsDAO.TrialExpirationBehavior trialExpirationBehavior;
        public String trialExpirationTargetProfile;
        public boolean allowRequestAccessWithStartedTrial;
        public boolean hasSignUpMessage;
        public boolean allowProfileUpgradeRequests;
        public boolean hasUpgradeProfileMessage;
        public Map<String, Integer> containerConfigByTypeAndWorkload = new HashMap<String, Integer>();
        public boolean hasDefaultExecutionConfig;
        public boolean hasDefaultExecutionConfigForVisualRecipesWorkloads;
        public boolean welcomeEmailEnabled;
        public boolean notificationEmailChannelEnabled;
        public int welcomeEmailsSentCount;
        public boolean prepareAICompletionUseLocal;
        public boolean aiGenerateSQLUseLocal;
        public boolean aiExplanationsUseLocal;
        public boolean storiesAIUseLocal;
        public boolean hasDSSVisualizationThemeSet;
        public boolean autogeneratedDocumentationEnabled;
    }

    public static class LibrariesSummaryReport {
        public int nbFiles;
        public int nbPythonRoots;
        public int nbRRoots;
        public int nbGitRefs;
        public int nbImports;
    }

    public static class NotebooksSummaryReport {
        public int nbSqlNotebooks;
        public int nbSearchNotebooks;
        public int nbJupyterNotebooks;
        public int nbJupyterNotebooksOnGit;
        public Map<String, Integer> notebooksByType = new HashMap<String, Integer>();
    }

    public static class PluginsSummaryReport {
        public List<String> pluginIds = new ArrayList<String>();
        int nbCustomJS;
        int nbPythonDatasets;
        int nbJavaDatasets;
        int nbRecipes;
        int nbPythonProbes;
        int nbSQLProbes;
        int nbPythonFormats;
        int nbJavaFormats;
        int nbPythonExporters;
        int nbJavaExporters;
        int nbPythonChecks;
        int nbStandardWebapps;
        int nbShinyWebapps;
        int nbBokehWebapps;
        int nbDashWebapps;
        int nbStreamlitWebapps;
        int nbPythonScenarioSteps;
        int nbPythonScenarioTriggers;
        int nbPythonRunnables;
        int nbJavaRunnables;
        int nbPythonFSProviders;
        int nbJavaFSProviders;
        int nbSQLDialects;
        int nbJythonProcessors;
        int nbPythonClusters;
        int nbCustomFields;
        int nbJavaPolicyHooks;
        int nbApplicationAsRecipes;
        int nbApplications;
        boolean devExplicitCommit;
    }

    public static class UDMSummaryReport {
        public int nbUDM;
        public int nbDetectable;
        public Map<String, Integer> udmByType = new HashMap<String, Integer>();
        public Map<String, Integer> detectableByType = new HashMap<String, Integer>();
    }

    public static class WikisSummaryReport {
        public int nbWikis;
        public int nbArticles;
        public int maxNbArticlePerWiki;
        public int nbNonEmptyArticles;
        public int maxNbNonEmptyArticlePerWiki;
    }

    public static class APIServicesSummaryReport {
        public int services;
        public Map<String, Integer> servicesByAuthorizationMethod = new HashMap<String, Integer>();
        public int servicesWithOpenAPI;
        public int endpoints;
        public int endpointsWithEnrich;
        public Map<String, Integer> endpointsByType = new HashMap<String, Integer>();
        public Map<String, Integer> autoOpenAPIByType = new HashMap<String, Integer>();
        public Map<String, Integer> manualOpenAPIByType = new HashMap<String, Integer>();
        public Map<String, Integer> datasetResourcesByType = new HashMap<String, Integer>();
    }

    public static class DashboardsSummaryReport {
        public int nbDashboards;
        public int nbEmptyDashboards;
        public int nbNonEmptyDashboards;
        public int nbDashboardsWithAutoStackUpEnabled;
        public int nbPublic;
        public int nbSlides;
        public DashboardStats stats = new DashboardStats();
        public Map<String, TilesSummaryReport> tiles = new HashMap<String, TilesSummaryReport>();
    }

    public static class GroupTilesSummaryReport
    extends TilesSummaryReport {
        public int nbChildTiles = 0;
    }

    public static class TilesSummaryReport {
        public int total = 0;
        public int maxByPage = -2147483647;
    }

    public static class DashboardStats {
        public SimpleStats datasetSourcesPerPage;
        public SimpleStats pages;
    }

    public static class SimpleStats {
        public int min = Integer.MAX_VALUE;
        public int max = -2147483647;
        public int sum = 0;
        public double median;
        public double mean;
        transient PSquarePercentile medianPSQuare = new PSquarePercentile(50.0);

        public void addValue(int value) {
            this.min = Math.min(this.min, value);
            this.max = Math.max(this.max, value);
            this.sum += value;
            this.medianPSQuare.increment((double)value);
            this.median = this.medianPSQuare.getResult();
            this.mean = (double)this.sum / (double)this.medianPSQuare.getN();
        }
    }

    public static class CodeStudioTemplatesSummaryReport {
        public int nbCodeStudioTemplates;
        public Map<String, Integer> countByType = new HashMap<String, Integer>();
        public Map<String, Integer> blockCountByType = new HashMap<String, Integer>();
    }

    public static class CodeStudiosSummaryReport {
        public int nbCodeStudios;
        public int nbCodeStudioWebapps;
        public Map<String, Integer> countByBlockType = new HashMap<String, Integer>();
    }

    public static class InsightsSummaryReport {
        public int nbInsights;
        public int nbInsightsNotPublished;
        public Map<String, Integer> countByType = new HashMap<String, Integer>();
    }

    public static class ChartAxisSummaryReport {
        private int count = 0;
        private Map<String, Integer> binningMode = new HashMap<String, Integer>();

        public int getCount() {
            return this.count;
        }

        public void setCount(int count) {
            this.count = count;
        }

        public Map<String, Integer> getBinningMode() {
            return this.binningMode;
        }

        public void setBinningMode(Map<String, Integer> binningMode) {
            this.binningMode = binningMode;
        }
    }

    public static class ChartAxesSummaryReport
    extends HashMap<String, ChartAxisSummaryReport> {
        int computeTotalNumberOfDimension() {
            int result = 0;
            for (ChartAxisSummaryReport axisSummaryReport : this.values()) {
                result += axisSummaryReport.count;
            }
            return result;
        }

        void add(DimensionDef chartDimension) {
            if (chartDimension.type == null) {
                return;
            }
            String type = chartDimension.type.name().toLowerCase();
            ChartAxisSummaryReport axisSummaryReport = this.getOrCreate(type);
            ++axisSummaryReport.count;
            switch (chartDimension.type) {
                case NUMERICAL: {
                    this.incrementBinningModeCounter(axisSummaryReport.binningMode, chartDimension.numParams.mode.name());
                    break;
                }
                case DATE: {
                    this.incrementBinningModeCounter(axisSummaryReport.binningMode, chartDimension.dateParams.mode.name());
                    break;
                }
            }
        }

        void add(ChartDef.Unaggregated unaggregated) {
            if (unaggregated.type == null) {
                return;
            }
            String type = unaggregated.type.name().toLowerCase();
            ChartAxisSummaryReport axisSummaryReport = this.getOrCreate(type);
            ++axisSummaryReport.count;
        }

        void add(NADimensionDef chartDimension) {
            if (chartDimension.type == null) {
                return;
            }
            String type = chartDimension.type.toLowerCase();
            ChartAxisSummaryReport axisSummaryReport = this.getOrCreate(type);
            ++axisSummaryReport.count;
        }

        void add(ChartDef.NADimensionPair pair) {
            if (pair == null) {
                return;
            }
            if (pair.uaYDimension != null) {
                pair.uaYDimension.forEach(this::add);
            }
            if (pair.uaXDimension != null) {
                pair.uaXDimension.forEach(this::add);
            }
        }

        void merge(ChartAxesSummaryReport other) {
            for (Map.Entry entry : other.entrySet()) {
                ChartAxisSummaryReport actualAxis = this.getOrCreate((String)entry.getKey());
                ChartAxisSummaryReport otherAxis = (ChartAxisSummaryReport)entry.getValue();
                actualAxis.count += otherAxis.count;
                UsageSummaryBuilderUtils.mergeCountMap(actualAxis.binningMode, otherAxis.binningMode);
            }
        }

        private ChartAxisSummaryReport getOrCreate(String key) {
            if (!this.containsKey(key)) {
                this.put(key, new ChartAxisSummaryReport());
            }
            return (ChartAxisSummaryReport)this.get(key);
        }

        private void incrementBinningModeCounter(Map<String, Integer> binningModeCounters, String binningMode) {
            UsageSummaryBuilderUtils.inc(binningModeCounters, binningMode.toLowerCase());
        }
    }

    public static class ChartsSummaryReport {
        public int nbCharts;
        public int nbUDAFs;
        public int nbReusableDimensions;
        public int nbHierarchies;
        public int nbChartsWithUDAF;
        public int nbChartsWithReusableDimensions;
        public int nbChartsWithHierarchies;
        public int nbOfReferenceLines;
        public Map<String, Integer> countConnectPoints = new HashMap<String, Integer>();
        public Map<String, Integer> countPerType = new HashMap<String, Integer>();
        public Map<String, Integer> countPerOrigin = new HashMap<String, Integer>();
        public Map<String, Integer> countPerEngine = new HashMap<String, Integer>();
        public ChartAxesSummaryReport axesDetails = new ChartAxesSummaryReport();
    }

    public static class AnalysisSummaryReport {
        public int nbAnalyses;
        public int nbPredMLTasks;
        public int nbClustMLTasks;
        public Map<String, Integer> processorsByType = new HashMap<String, Integer>();
        public VisualIfRuleSummary visualIfProcessor;
    }

    public static class AgentSummaryReport {
        public int nbAgents;
        public Map<String, Integer> byType = new HashMap<String, Integer>();
    }

    public static class RetrievalAugmentedLLLMSummaryReport {
        public int nbRALLM;
        public Map<Integer, Integer> allByMaxDocumentsCount = new HashMap<Integer, Integer>();
        public int nbUseSimilarity;
        public int nbUseSimilarityThreshold;
        public int nbUseMMR;
        public int nbUseHybridSearch;
        public int nbUseAdvancedReranking;
        public int nbPrintSources;
        public int nbIncludeContentInSources;
        public Map<String, Integer> outputFormatByType = new HashMap<String, Integer>();
        public Map<String, Integer> retrievalSourceByType = new HashMap<String, Integer>();
        public int nbUsingFaithfulnessGuardrails;
        public int nbUsingRelevancyGuardrails;
    }

    public static class RetrievableKnowledgeSummaryReport {
        public int nbKb;
        public Map<String, Integer> vectorStoreType = new HashMap<String, Integer>();
    }

    public static class RAGEmbeddingRecipeSummaryReport {
        public int nbRecipes;
        public Map<String, Integer> vectorStoreUpdateMethod = new HashMap<String, Integer>();
    }

    public static class LLMEvaluationRecipeSummaryReport {
        public int nbRecipes;
        public Map<String, Integer> metricsByType = new HashMap<String, Integer>();
    }

    public static class JoinRecipeSummaryReport {
        public JoinRecipeSubSummary join = new JoinRecipeSubSummary();
        public JoinRecipeSubSummary fuzzyjoin = new JoinRecipeSubSummary();
        public JoinRecipeSubSummary geojoin = new JoinRecipeSubSummary();

        public static class JoinRecipeSubSummary {
            public int nbRecipes;
            public Map<String, Integer> type = new HashMap<String, Integer>();
        }
    }

    public static class ShakerRecipeSummaryReport {
        public int nbRecipes;
        public Map<String, Integer> processorsByType = new HashMap<String, Integer>();
        public VisualIfRuleSummary visualIfProcessor;
    }

    public static class FiltersSummaryReport {
        public FilterStats all = new FilterStats();
        public Map<String, Map<String, FilterStats>> byLocation = new HashMap<String, Map<String, FilterStats>>();
    }

    public static class FilterStats {
        public int nbFilters = 0;
        public ConditionFilterStatUnit condition;
        public FilterStatUnit formula;
        public FilterStatUnit sql;
        public FilterStatUnit elasticSearchQueryString;
        public FilterStatUnit unknownType;
    }

    public static class ConditionFilterStatUnit {
        public int nbFilters = 0;
        public SortedMap<Integer, Integer> countByFilterDepth;
        public Double avgDepth;
        public Integer maxDepth;
        public Double avgNbConditions;
        public Integer maxNbConditions;
    }

    public static class FilterStatUnit {
        public int nbFilters;
    }

    public static class VisualIfRuleSummary {
        public int nbProcessors;
        public double avgNumberOfRule;
        public int maxNbOfRule;
        public double avgNbOfConditions;
        public int maxNbOfConditions;
        public double avNbOfGroups;
        public int maxNbOfGroups;
        public double avgDepth;
        public int maxDepth;
        public double avgNbThen;
        public int maxNbThen;
        public double avgNbElse;
        public int maxNbElse;
    }

    public static class RecipesSummaryReport {
        public int all;
        public Map<String, Integer> byType = new HashMap<String, Integer>();
        public Map<String, Integer> pdepByType = new HashMap<String, Integer>();
        public Map<String, Integer> repeatingByType = new HashMap<String, Integer>();
    }

    public static class DataQualityTemplatesSummaryReport {
        public int templateCount;
        public int totalRuleCount;
        public Map<String, Integer> ruleCountByType = new HashMap<String, Integer>();
    }

    public static class DataQualitySummaryReport {
        public int all;
        public Map<String, Integer> byType = new HashMap<String, Integer>();
    }

    public static class ProjectDeployerSummaryReport
    extends DeployerSummaryReport {
        List<Integer> publishedBundles = new ArrayList<Integer>();
        Integer nbPublishedProjects;
        AutomationNodeInfraPolicies nbInfraPoliciesByOption;

        @Override
        public void addNumberOfPackages(int nbBundles) {
            this.publishedBundles.add(nbBundles);
            this.nbPublishedProjects = this.publishedBundles.size();
        }
    }

    public static class AutomationNodeInfraPolicies {
        Map<String, Integer> permissionsPropagationByType = new HashMap<String, Integer>();
        int deployAsUser;
        int runAsUser;
    }

    public static class APIDeployerSummaryReport
    extends DeployerSummaryReport {
        List<Integer> publishedAPIServicesVersions = new ArrayList<Integer>();
        Integer nbPublishedApiServices;
        Integer nbDeploymentsWithOpenAPI;

        @Override
        public void addNumberOfPackages(int nbVersions) {
            this.publishedAPIServicesVersions.add(nbVersions);
            this.nbPublishedApiServices = this.publishedAPIServicesVersions.size();
        }
    }

    public static class DeployerSourceNode {
        String installID;
        String lastPublish;

        public DeployerSourceNode() {
        }

        public DeployerSourceNode(String installID, String lastPublish) {
            this.installID = installID;
            this.lastPublish = lastPublish;
        }
    }

    static abstract class DeployerSummaryReport {
        List<Integer> nbDeploymentsByStage = new ArrayList<Integer>();
        Map<String, Integer> nbDeploymentsByType = new HashMap<String, Integer>();
        Map<String, Integer> nbInfrasByType = new HashMap<String, Integer>();
        Map<String, Integer> nbDatabricksInfrasByModelStorageType = new HashMap<String, Integer>();
        Map<String, Integer> nbHooksByType = new HashMap<String, Integer>();
        Set<DeployerSourceNode> sourceDesignNodes = new HashSet<DeployerSourceNode>();

        DeployerSummaryReport() {
        }

        abstract void addNumberOfPackages(int var1);
    }

    public static class ScenariosSummaryReport {
        public int all;
        public int withTriggers;
        public int active;
        public int activeWithTriggers;
        public int markedAsTest;
        public Map<String, Integer> scenarioByType = new HashMap<String, Integer>();
        public Map<String, Integer> stepByType = new HashMap<String, Integer>();
        public Map<String, Integer> stepByTypeInTestScenario = new HashMap<String, Integer>();
        public Map<String, Integer> triggerByType = new HashMap<String, Integer>();
        public Map<String, Integer> reporterByType = new HashMap<String, Integer>();
    }

    public static class DatasetsSummaryReport {
        public int all;
        public Map<String, Integer> allByType = new HashMap<String, Integer>();
        public int managed;
        public Map<String, Integer> managedByType = new HashMap<String, Integer>();
        public Map<String, Integer> repeatingByType = new HashMap<String, Integer>();
        public Map<String, Long> sizeByType = new HashMap<String, Long>();
        public Map<String, Long> partitionedByType = new HashMap<String, Long>();
        public Map<String, Long> partitionsByType = new HashMap<String, Long>();
        public Map<String, Integer> notFlow = new HashMap<String, Integer>();
        public Map<String, Integer> flowInput = new HashMap<String, Integer>();
        public Map<String, Integer> flowIO = new HashMap<String, Integer>();
        public Map<String, Integer> flowOutput = new HashMap<String, Integer>();
        public int withDataQualityRules = 0;
        public int monitored = 0;
    }
}

