/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.activity.filterutils;

import com.dataiku.dip.activity.UsageSummaryModel;
import com.dataiku.dip.activity.filterutils.FilterAggregator;
import com.dataiku.dip.activity.filterutils.FilterAnalyzer;
import com.dataiku.dip.dataflow.exec.filter.FilterDesc;
import com.dataiku.dip.utils.DKULogger;
import java.util.HashMap;
import java.util.Map;

public class FilterReportBuilder {
    private FilterAggregator allAggregator = new FilterAggregator();
    private Map<String, Map<String, FilterAggregator>> aggregatorsByLocation = new HashMap<String, Map<String, FilterAggregator>>();
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.usage");

    private static Map<String, FilterAggregator> mergeAggregatorMaps(Map<String, FilterAggregator> map1, Map<String, FilterAggregator> map2) {
        map2.forEach((k2, v2) -> map1.merge((String)k2, (FilterAggregator)v2, (agg1, agg2) -> {
            agg1.add((FilterAggregator)agg2);
            return agg1;
        }));
        return map1;
    }

    public void add(FilterReportBuilder other) {
        this.allAggregator.add(other.allAggregator);
        other.aggregatorsByLocation.forEach((k, v) -> this.aggregatorsByLocation.merge((String)k, (Map<String, FilterAggregator>)v, FilterReportBuilder::mergeAggregatorMaps));
    }

    private void appendByLocation(String unitKey, String location, FilterAnalyzer.FilterSummary filterSummary) {
        Map aggregatorMap = this.aggregatorsByLocation.computeIfAbsent(unitKey, key -> new HashMap());
        FilterAggregator aggregator = aggregatorMap.computeIfAbsent(location, key -> new FilterAggregator());
        aggregator.appendFilter(filterSummary);
    }

    void appendFilterSummary(String unitKey, String locationKey, FilterAnalyzer.FilterSummary filterSummary) {
        if (unitKey == null) {
            logger.warn((Object)"Problem in filter report building code unitKey cannot be null");
            return;
        }
        if (locationKey == null) {
            logger.warn((Object)"Problem in filter report building code locationKey cannot be null");
            return;
        }
        if (filterSummary != null) {
            this.allAggregator.appendFilter(filterSummary);
            this.appendByLocation(unitKey, locationKey, filterSummary);
        }
    }

    public void appendFilter(String unitKey, String locationKey, FilterDesc filter) {
        if (filter != null && filter.enabled) {
            FilterAnalyzer.FilterSummary fs = FilterAnalyzer.analyzeFilter(filter);
            this.appendFilterSummary(unitKey, locationKey, fs);
        }
    }

    private Map<String, UsageSummaryModel.FilterStats> createStatsMapForUnit(Map<String, FilterAggregator> aggregatorMap) {
        HashMap<String, UsageSummaryModel.FilterStats> statsMap = new HashMap<String, UsageSummaryModel.FilterStats>();
        for (Map.Entry<String, FilterAggregator> entry : aggregatorMap.entrySet()) {
            UsageSummaryModel.FilterStats filterStats = entry.getValue().buildStats();
            statsMap.put(entry.getKey(), filterStats);
        }
        return statsMap;
    }

    private void populateByLocationReport(UsageSummaryModel.FiltersSummaryReport report) {
        for (Map.Entry<String, Map<String, FilterAggregator>> entry : this.aggregatorsByLocation.entrySet()) {
            report.byLocation.put(entry.getKey(), this.createStatsMapForUnit(entry.getValue()));
        }
    }

    public UsageSummaryModel.FiltersSummaryReport toFilterSummaryReport() {
        UsageSummaryModel.FiltersSummaryReport report = new UsageSummaryModel.FiltersSummaryReport();
        report.all = this.allAggregator.buildStats();
        this.populateByLocationReport(report);
        return report;
    }
}

