/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.agents.tools;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.agents.tools.AgentTool;
import com.dataiku.dip.agents.tools.AgentToolMeta;
import com.dataiku.dip.agents.tools.AgentToolRunner;
import com.dataiku.dip.agents.tools.PythonAgentToolServer;
import com.dataiku.dip.agents.tools.PythonAgentToolServerAPI;
import com.dataiku.dip.agents.tools.PythonAgentToolServerPool;
import com.dataiku.dip.agents.tools.custom.LoadedCustomAgentTool;
import com.dataiku.dip.custom.PluginSettingsResolver;
import com.dataiku.dip.io.CustomPythonKernelException;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.SmartLogTail;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.google.gson.JsonObject;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractPythonAgentToolRunner
implements AgentToolRunner {
    protected PythonAgentToolServerAPI serverAPI;
    protected final DSSAuthCtx authCtx;
    protected String projectKey;
    protected final AgentTool at;
    protected boolean devMode;
    protected boolean devKernel;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.agents.tools.python");

    public AbstractPythonAgentToolRunner(DSSAuthCtx authCtx, AgentTool agentTool) throws Exception {
        this.authCtx = authCtx;
        this.at = agentTool;
        this.projectKey = agentTool.projectKey;
    }

    protected abstract void initOnce() throws IOException;

    @Override
    public SmartLogTail getKernelLog() throws Exception {
        this.initOnce();
        return this.serverAPI.getKernelLog();
    }

    protected void initToolServer(String envName, String containerConfName, String clusterId, @Nullable String libFolder, String pyClazz, String code, @Nullable LoadedCustomAgentTool desc, @Nullable PluginSettingsResolver.ResolvedSettings expandedPluginSettings, boolean loadPythonLibs) throws Exception {
        JsonObject pluginConfig;
        String pluginId = desc != null ? desc.ownerPluginId : null;
        JsonObject config = expandedPluginSettings != null ? expandedPluginSettings.config : null;
        JsonObject jsonObject = pluginConfig = expandedPluginSettings != null ? expandedPluginSettings.pluginConfig : null;
        if (this.devMode) {
            File logBaseDir = DKUApp.getFile((String[])new String[]{"agent-tools", this.at.projectKey, this.at.id, "logs"});
            PythonAgentToolServer toolServer = new PythonAgentToolServer(this.authCtx, this.at.projectKey, this.at.id, pyClazz, code, envName, containerConfName, pluginId, libFolder, config, pluginConfig, loadPythonLibs);
            try {
                toolServer.start(false, true, logBaseDir);
            }
            catch (Exception e) {
                logger.warn((Object)"Kernel failed to start, closing it", (Throwable)e);
                IOUtils.closeQuietly((Closeable)toolServer, null);
                throw e;
            }
            this.serverAPI = toolServer;
        } else {
            PythonAgentToolServerPool kernelPool = (PythonAgentToolServerPool)SpringUtils.getBean(PythonAgentToolServerPool.class);
            this.serverAPI = kernelPool.getServerAPI(this.authCtx, this.at, pyClazz, code, pluginId, libFolder, loadPythonLibs, config, pluginConfig, envName, containerConfName, clusterId, this.devKernel);
        }
    }

    @Override
    public void close() {
        if (this.serverAPI != null) {
            IOUtils.closeQuietly((Closeable)this.serverAPI);
        }
    }

    @Override
    public void init() throws Exception {
    }

    @Override
    public AgentToolRunner.AgentToolOutput run(AgentToolRunner.AgentToolInput input) throws Exception {
        this.initOnce();
        try {
            return this.serverAPI.runAsync(input).get();
        }
        catch (Exception e) {
            if (e.getCause() instanceof CustomPythonKernelException) {
                throw (CustomPythonKernelException)e.getCause();
            }
            throw new IOException("Processing failed", e);
        }
    }

    @Override
    public boolean stopDevKernel() {
        PythonAgentToolServerPool kernelPool = (PythonAgentToolServerPool)SpringUtils.getBean(PythonAgentToolServerPool.class);
        return kernelPool.stopDevKernel(this.authCtx, this.at);
    }

    public AgentToolMeta.ToolDescriptor getResultingDescriptor(AgentTool tool) throws Exception {
        this.initOnce();
        try {
            AgentToolMeta.ToolDescriptor ret = this.serverAPI.getResultingDescriptorAsync(tool).get();
            ret.name = tool.name.replaceAll("[^A-Za-z0-9_]", "_") + "_" + SecretKeyGenerator.generate((int)6);
            if (StringUtils.isNotBlank((String)tool.additionalDescriptionForLLM)) {
                if (StringUtils.isNotBlank((String)ret.description)) {
                    ret.description = ret.description + "\n\n";
                }
                ret.description = ret.description + tool.additionalDescriptionForLLM;
            }
            return ret;
        }
        catch (Exception e) {
            throw new IOException("Fetching descriptor from Python tool failed", e);
        }
    }

    public JsonObject loadSampleQuery(AgentTool tool) throws Exception {
        this.initOnce();
        try {
            return this.serverAPI.loadSampleQuery(tool).get();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("The plugin developer of %s tool did not provide a default sample query. Please implement `load_sample_query()` in the plugin.", this.at.name));
        }
    }
}

