/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.agents.tools.utils;

import com.google.common.collect.Lists;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class JsonSchemaElement {
    public Type type;
    public String description;
    public JsonSchemaElement items;
    public Integer minItems;
    public Boolean uniqueItems;
    public Map<String, JsonSchemaElement> properties;
    public List<String> required;
    @SerializedName(value="enum")
    public List<String> enumOptions;
    public String $ref;
    public Map<String, JsonSchemaElement> $defs;

    public static JsonSchemaElement object(String description) {
        JsonSchemaElement ret = new JsonSchemaElement();
        ret.type = Type.object;
        ret.description = description;
        ret.properties = new LinkedHashMap<String, JsonSchemaElement>();
        return ret;
    }

    public static JsonSchemaElement string(String description) {
        JsonSchemaElement ret = new JsonSchemaElement();
        ret.type = Type.string;
        ret.description = description;
        return ret;
    }

    public static JsonSchemaElement bool(String description) {
        JsonSchemaElement ret = new JsonSchemaElement();
        ret.type = Type.bool;
        ret.description = description;
        return ret;
    }

    public static JsonSchemaElement stringEnum(String description, Class<? extends Enum> enumClass) {
        return JsonSchemaElement.stringEnum(description, Arrays.stream(enumClass.getEnumConstants()).map(v -> v.name()).collect(Collectors.toList()));
    }

    public static JsonSchemaElement stringEnum(String description, @Nullable List<String> enumOptions) {
        JsonSchemaElement ret = new JsonSchemaElement();
        ret.type = Type.string;
        if (enumOptions != null && !enumOptions.isEmpty()) {
            ret.enumOptions = enumOptions;
        }
        ret.description = description;
        return ret;
    }

    public static JsonSchemaElement number(String description) {
        JsonSchemaElement ret = new JsonSchemaElement();
        ret.type = Type.number;
        ret.description = description;
        return ret;
    }

    public static JsonSchemaElement simpleArray(String description, Type itemType) {
        JsonSchemaElement ret = new JsonSchemaElement();
        ret.description = description;
        ret.type = Type.array;
        ret.items = new JsonSchemaElement();
        ret.items.type = itemType;
        return ret;
    }

    public static JsonSchemaElement complexArray(String description, JsonSchemaElement item) {
        JsonSchemaElement ret = new JsonSchemaElement();
        ret.description = description;
        ret.type = Type.array;
        ret.items = item;
        return ret;
    }

    public static JsonSchemaElement ref(String refTo) {
        JsonSchemaElement ret = new JsonSchemaElement();
        ret.$ref = refTo;
        return ret;
    }

    public JsonSchemaElement withRequired(String ... required) {
        if (this.required == null) {
            this.required = new ArrayList<String>();
        }
        this.required.addAll(Lists.newArrayList((Object[])required));
        return this;
    }

    public static enum Type {
        object,
        array,
        string,
        integer,
        number,
        bool;


        public String toString() {
            if (this.equals((Object)bool)) {
                return "boolean";
            }
            return this.name();
        }
    }
}

