/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.aigenerations.recipes;

import com.dataiku.dip.aigenerations.AIRecipeGenerationService;
import com.dataiku.dip.aigenerations.recipes.AIRecipe;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dataflow.exec.topn.TopNRecipePayloadParams;
import com.dataiku.dip.i18n.TranslationService;
import com.dataiku.dip.server.SpringUtils;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class AITopn
extends AIRecipe {
    public static final String type = "topn";
    public Params params;

    @Override
    public List<AIRecipeGenerationService.CreationMessage> validate(List<Dataset> datasets, String contextProjectKey, String lang) {
        ArrayList<AIRecipeGenerationService.CreationMessage> creationMessages = new ArrayList<AIRecipeGenerationService.CreationMessage>();
        this.params.checkSingleInputDataset(datasets, type, contextProjectKey);
        this.params.checkSingleOutputDataset(type);
        TranslationService ts = (TranslationService)SpringUtils.getBean(TranslationService.class);
        if (this.params.retrieve_column_mode == null) {
            this.params.retrieve_column_mode = RetreiveColumnMode.ALL_COLUMNS;
        }
        if (this.params.row_selection_mode == null) {
            this.params.row_selection_mode = RowSelectionMode.WHOLE_DATASET;
        }
        if (this.params.number_first_rows == null) {
            this.params.number_first_rows = 0;
        }
        if (this.params.number_last_rows == null) {
            this.params.number_last_rows = 0;
        }
        if (this.params.ordering_columns == null || this.params.ordering_columns.isEmpty()) {
            creationMessages.add(new AIRecipeGenerationService.CreationMessage(AIRecipeGenerationService.CreationMessage.Level.WARNING, ts.translateNoContext(lang, "RIGHT_PANEL.TABS.GENERATE_RECIPE.TOPN.UNABLE_TO_DETERMINE_COLUMN_TO_ORDER", "Unable to determine which column(s) to use to order your dataset", new Object[0])));
        }
        if (this.params.number_first_rows == 0 && this.params.number_last_rows == 0) {
            creationMessages.add(new AIRecipeGenerationService.CreationMessage(AIRecipeGenerationService.CreationMessage.Level.WARNING, ts.translateNoContext(lang, "RIGHT_PANEL.TABS.GENERATE_RECIPE.TOPN.UNABLE_TO_DETERMINE_NUMBER_ROWS", "Unable to determine what number of top / last rows you want to fetch", new Object[0])));
        }
        if (this.params.row_selection_mode.equals((Object)RowSelectionMode.DATASET_GROUP) && (this.params.row_column_group == null || this.params.row_column_group.isEmpty())) {
            creationMessages.add(new AIRecipeGenerationService.CreationMessage(AIRecipeGenerationService.CreationMessage.Level.WARNING, ts.translateNoContext(lang, "RIGHT_PANEL.TABS.GENERATE_RECIPE.TOPN.UNABLE_TO_DETERMINE_COLUMN_TO_GROUP", "Unable to determine which column(s) to use to group the rows of your dataset", new Object[0])));
        }
        if (this.params.retrieve_column_mode.equals((Object)RetreiveColumnMode.SUBSET_OF_COLUMNS) && (this.params.retrieved_columns == null || this.params.retrieved_columns.isEmpty())) {
            creationMessages.add(new AIRecipeGenerationService.CreationMessage(AIRecipeGenerationService.CreationMessage.Level.WARNING, ts.translateNoContext(lang, "RIGHT_PANEL.TABS.GENERATE_RECIPE.TOPN.UNABLE_TO_DETERMINE_COLUMN_TO_RETRIEVE", "Unable to determine which column(s) needs to be retrieved as part of the output dataset", new Object[0])));
        }
        return creationMessages;
    }

    @Override
    public AIRecipeGenerationService.AIMetaCreation generateRecipeMetaPayload(AIRecipeGenerationService.RecipeGenerationContext recipeGenerationContext) {
        AIRecipeGenerationService.AIMetaCreation metaCreation = new AIRecipeGenerationService.AIMetaCreation();
        metaCreation.messages = this.validate(recipeGenerationContext.datasets, recipeGenerationContext.contextProjectKey, recipeGenerationContext.lang);
        TopNRecipePayloadParams topNRecipePayloadParams = new TopNRecipePayloadParams();
        this.enrichParams(recipeGenerationContext.datasets, topNRecipePayloadParams, recipeGenerationContext.contextProjectKey);
        metaCreation.datasetInputNames = List.of(this.params.input_dataset);
        metaCreation.datasetOutputNames = List.of(this.params.output_dataset);
        metaCreation.payload = new Gson().toJson((Object)topNRecipePayloadParams);
        return metaCreation;
    }

    public void enrichParams(List<Dataset> datasets, TopNRecipePayloadParams recipeParams, String contextProjectKey) {
        Dataset dataset = Params.getDataset(datasets, this.params.input_dataset, contextProjectKey);
        Set validColumnNames = dataset.getSchema().columns.stream().map(SchemaColumn::getName).collect(Collectors.toSet());
        recipeParams.firstRows = this.params.number_first_rows;
        recipeParams.lastRows = this.params.number_last_rows;
        List<Object> list = recipeParams.orders = this.params.ordering_columns == null ? Collections.emptyList() : this.params.ordering_columns.stream().filter(oc -> validColumnNames.contains(oc.column)).map(oc -> {
            TopNRecipePayloadParams.Order ret = new TopNRecipePayloadParams.Order();
            ret.column = oc.column;
            ret.desc = oc.asc == null || oc.asc == false;
            return ret;
        }).collect(Collectors.toList());
        if (this.params.row_selection_mode.equals((Object)RowSelectionMode.DATASET_GROUP)) {
            recipeParams.keys = this.params.row_column_group == null ? Collections.emptyList() : this.params.row_column_group.stream().filter(validColumnNames::contains).collect(Collectors.toList());
        }
        recipeParams.denseRank = this.params.include_dense_rank != null && this.params.include_dense_rank != false;
        recipeParams.duplicateCount = this.params.count_row != null && this.params.count_row != false;
        recipeParams.rank = this.params.include_rank != null && this.params.include_rank != false;
        boolean bl = recipeParams.rowNumber = this.params.include_row_number != null && this.params.include_row_number != false;
        if (this.params.retrieve_column_mode.equals((Object)RetreiveColumnMode.ALL_COLUMNS)) {
            recipeParams.retrievedColumnsSelectionMode = TopNRecipePayloadParams.RetrievedColumnsSelectionMode.ALL;
        } else {
            recipeParams.retrievedColumnsSelectionMode = TopNRecipePayloadParams.RetrievedColumnsSelectionMode.EXPLICIT;
            recipeParams.retrievedColumns = this.params.retrieved_columns == null ? Collections.emptyList() : this.params.retrieved_columns.stream().filter(validColumnNames::contains).collect(Collectors.toList());
        }
    }

    public static class Params
    extends AIRecipe.AIRecipeParams {
        public Integer number_first_rows;
        public Integer number_last_rows;
        public List<AIRecipe.OrderingColumn> ordering_columns;
        public RowSelectionMode row_selection_mode;
        public List<String> row_column_group;
        public Boolean count_row;
        public Boolean include_rank;
        public Boolean include_dense_rank;
        public Boolean include_row_number;
        public RetreiveColumnMode retrieve_column_mode;
        public List<String> retrieved_columns;
    }

    public static enum RetreiveColumnMode {
        ALL_COLUMNS,
        SUBSET_OF_COLUMNS;

    }

    public static enum RowSelectionMode {
        WHOLE_DATASET,
        DATASET_GROUP;

    }
}

