/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.coreservices;

import com.dataiku.dip.engine.AsyncCloser;
import com.dataiku.dip.io.AlivenessCheckableAndClosable;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.util.DKUExecutors;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.Pair;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.PostConstruct;

public abstract class CacheableKernelService {
    private final Cache<Pair<String, String>, AlivenessCheckableAndClosable> kernelCache = this.initKernelCache();
    protected static final DKULogger logger = DKULogger.getLogger((String)"dku.doctor.cacheable-kernel");

    protected abstract int getKernelCacheExpirationTimeInSeconds();

    protected synchronized AlivenessCheckableAndClosable acquireKernel(AuthCtx authCtx, CacheableKernelBuilder builder) throws Exception {
        Pair<String, String> key = builder.getKey(authCtx);
        AlivenessCheckableAndClosable kernel = (AlivenessCheckableAndClosable)this.kernelCache.getIfPresent(key);
        if (kernel == null || !kernel.isAlive()) {
            logger.info((Object)"No cached kernel, creating new one");
            kernel = builder.createKernel(authCtx);
            this.kernelCache.put(key, (Object)kernel);
        }
        return kernel;
    }

    protected void invalidateCache(Function<Pair<String, String>, Boolean> shouldInvalidateCallback) {
        HashSet<Pair> filteredKeys = new HashSet<Pair>();
        for (Pair key : this.kernelCache.asMap().keySet()) {
            if (!shouldInvalidateCallback.apply((Pair<String, String>)key).booleanValue()) continue;
            filteredKeys.add(key);
        }
        logger.info((Object)("Invalidating " + filteredKeys.size() + " kernel(s)"));
        this.kernelCache.invalidateAll(filteredKeys);
    }

    private Cache<Pair<String, String>, AlivenessCheckableAndClosable> initKernelCache() {
        logger.infoV("Init kernel cache", new Object[0]);
        RemovalListener removalListener = removalNotification -> {
            logger.info((Object)("Removal listener notified of removal of kernel " + String.valueOf(removalNotification.getKey()) + " -> " + String.valueOf(removalNotification.getValue())));
            try {
                new AsyncCloser().close((AutoCloseable)removalNotification.getValue());
            }
            catch (Exception e) {
                logger.error((Object)"Failed to remove kernel", (Throwable)e);
            }
        };
        return CacheBuilder.newBuilder().expireAfterAccess((long)this.getKernelCacheExpirationTimeInSeconds(), TimeUnit.SECONDS).removalListener(removalListener).build();
    }

    private void cleanup() {
        logger.info((Object)("Running kernel cache cleanup on cache manager " + this.getClass().getSimpleName()));
        this.kernelCache.cleanUp();
    }

    @PostConstruct
    public void postConstruct() {
        int CLEANUP_PERIOD_MN = 5;
        logger.infoV("Scheduling periodic cleanup of kernel and result cache every %d minutes, starting in %d minutes", new Object[]{5, 5});
        DKUExecutors.newNamedSingleDaemonThreadExecutor(this.getClass().getSimpleName() + "Cache-cleanup").scheduleWithFixedDelay(this::cleanup, 5L, 5L, TimeUnit.MINUTES);
    }

    public static interface CacheableKernelBuilder {
        public AlivenessCheckableAndClosable createKernel(AuthCtx var1) throws Exception;

        public Pair<String, String> getKey(AuthCtx var1);
    }
}

