/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml;

import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.cluster.SparkSettings;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.services.licensing.AbstractLicenseFeaturesStatusBuilder;
import com.dataiku.dip.server.services.licensing.LicenseEnforcementService;
import com.dataiku.dip.spark.SparkExecutionConfig;
import com.dataiku.dip.util.DatasetLocUtils;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MLBackendsService {
    @Autowired
    private LicenseEnforcementService enforcementService;
    @Autowired
    private DatasetAccessService datasetAccessService;

    public List<MLBackendDesc> listMLBackends(AuthCtx authCtx, String projectKey, String datasetSmartName, String taskType) throws Exception {
        Dataset dataset = this.datasetAccessService.getMandatory(DatasetLocUtils.resolveSmart(projectKey, datasetSmartName));
        String connectionType = null;
        if (DatasetInspector.isSQLOrHive(dataset)) {
            String connectionName = dataset.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class).connection;
            AbstractSQLConnection connection = ConnectionsDAO.get().getMandatoryConnectionAs(authCtx, connectionName, AbstractSQLConnection.class);
            connectionType = connection.type;
        }
        SparkSettings sparkSettings = new ClusterSelector().selectForProject(authCtx, projectKey).getSparkSettings();
        AbstractLicenseFeaturesStatusBuilder.LicenseFeaturesStatus licensedFeatures = this.enforcementService.getFeaturesStatus();
        ArrayList<MLBackendDesc> backends = new ArrayList<MLBackendDesc>(3);
        MLBackendDesc python = new MLBackendDesc(MLTask.BackendType.PY_MEMORY, "In-memory");
        python.description = taskType.equals("prediction") ? "In-memory training using Python libraries (scikit-learn and XGBoost)" : "In-memory training using Python libraries (scikit-learn)";
        python.available = true;
        backends.add(python);
        MLBackendDesc keras = new MLBackendDesc(MLTask.BackendType.KERAS, "Keras / TensorFlow");
        keras.description = "Deep learning with Keras and TensorFlow";
        keras.available = true;
        backends.add(keras);
        MLBackendDesc mllib = new MLBackendDesc(MLTask.BackendType.MLLIB, "MLLib");
        mllib.description = "Distributed ML using Spark MLLib";
        if (!licensedFeatures.sparkMLLibAllowed) {
            mllib.statusMessage = "Not enabled with your license.";
        } else if (sparkSettings != null && sparkSettings.sparkEnabled) {
            if (sparkSettings.executionConfigs.size() > 0) {
                mllib.available = true;
                mllib.instances = new ArrayList<String>(sparkSettings.executionConfigs.size());
                for (SparkExecutionConfig config : sparkSettings.executionConfigs) {
                    mllib.instances.add(config.name);
                }
            } else {
                mllib.statusMessage = "No spark conf is defined.";
            }
        } else {
            mllib.statusMessage = "Spark is not enabled";
        }
        backends.add(mllib);
        MLBackendDesc deepHub = new MLBackendDesc(MLTask.BackendType.DEEP_HUB, "DeepHub");
        deepHub.description = "Computer vision backend";
        deepHub.available = true;
        backends.add(deepHub);
        return backends;
    }

    public static class MLBackendDesc {
        MLTask.BackendType type;
        String displayName;
        String description;
        List<String> instances;
        boolean available;
        String statusMessage;

        public MLBackendDesc(MLTask.BackendType type, String displayName) {
            this.type = type;
            this.displayName = displayName;
        }
    }
}

